/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.http.ParseException;
import com.contrastsecurity.thirdparty.oa4j.http.entity.ContentType;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

@DontObfuscate
@HeapUsage.SupportsHeapProfiling
public final class ContrastContentType {
    @HeapUsage.Deep
    private final ContentType contentType;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final Charset charset;
    @HeapUsage.Deep
    private final String header;
    private final boolean isJson;
    private final boolean isXml;
    private static final String[] MEDIA_CONTENT_TYPES = new String[]{"image/", "text/css", "text/javascript", "font/woff"};
    private static final String[] JSON_TYPES = new String[]{"/json", "+json"};
    private static final String[] XML_TYPES = new String[]{"/xml", "+xml"};
    private static final Logger logger = LoggerFactory.getLogger(ContrastContentType.class);

    private ContrastContentType(String string, String string2) {
        this.header = string;
        this.contentType = this.parseContentType(string);
        this.charset = this.parseCharset(string2);
        this.isXml = StringUtils.containsAnyIgnoreCase(this.getMimeType(), XML_TYPES);
        this.isJson = StringUtils.containsAnyIgnoreCase(this.getMimeType(), JSON_TYPES);
    }

    public static ContrastContentType parse(String string) {
        return new ContrastContentType(string, null);
    }

    public static ContrastContentType parse(String string, String string2) {
        return new ContrastContentType(string, string2);
    }

    public String getMimeType() {
        return this.contentType != null ? this.contentType.getMimeType() : "";
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isMedia() {
        return StringUtils.containsAnyIgnoreCase(this.getMimeType(), MEDIA_CONTENT_TYPES);
    }

    public boolean isXml() {
        return this.isXml;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public boolean isDocument() {
        return this.isJson || this.isXml;
    }

    public boolean isParameters() {
        return this.getMimeType().startsWith("application/x-www-form-urlencoded");
    }

    public boolean isMultipart() {
        return this.getMimeType().startsWith("multipart/form-data");
    }

    public boolean isFormEncodedContentType() {
        String string = this.getMimeType();
        return string.contains("application/x-www-form-urlencoded") || string.contains("multipart/form-data");
    }

    public String getMultipartBoundary() {
        return this.contentType != null ? this.contentType.getParameter("boundary") : null;
    }

    public String getHeader() {
        return this.header;
    }

    private Charset parseCharset(String string) {
        if (this.contentType != null && this.contentType.getCharset() != null) {
            return this.contentType.getCharset();
        }
        if (this.isJson()) {
            return StandardCharsets.UTF_8;
        }
        if (string == null) {
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Charset.defaultCharset();
        }
    }

    private ContentType parseContentType(String string) {
        if (string == null) {
            logger.debug("Content-type is null");
            return null;
        }
        try {
            return ContentType.parse(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            logger.debug("Charset from content-type: {} is not valid.", (Object)string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            logger.debug("Charset from content-type: {} is not available.", (Object)string);
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                String string2 = string.substring(0, string.indexOf(59));
                return ContentType.create(string2);
            }
            logger.warn("The given text={} does not represent a valid Content-Type value.", (Object)string);
        }
        catch (ParseException parseException) {
            logger.warn("The given text={} does not represent a valid Content-Type value.", (Object)string);
        }
        return null;
    }
}

