/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.http.HttpHeader;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.HttpResponseFactory;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.RequestLifecycleListener;
import com.contrastsecurity.agent.http.StandardHttpHeader;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o.c;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.protect.rules.g.d;
import com.contrastsecurity.agent.pool.PurgeableObjectPool;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.agent.util.C2Compiler;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
@m
public class HttpManager
implements a {
    private final PluginManager pluginManager;
    private final AtomicBoolean isFirstRequest;
    private final f firstRequestEndListener;
    private final c eventBus;
    private final PurgeableObjectPool<MemoryBuffer> memoryBufferPool;
    private final DistributionSummary contentLengthDistributionSummary;
    private final DistributionSummary memoryBufferDistributionSummary;
    private final Counter multipartContentTypeCounter;
    private final DistributionSummary multipartContentLengthDistributionSummary;
    private final boolean featureSamplingEnabled;
    private final int featureSamplingFrequency;
    private final C2Compiler c2Compiler;
    private final ScheduledExecutorService commonExecutor;
    private final int maxResponseBodySize;
    private final boolean integrationTestsEnabled;
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    public HttpManager(Config config, PluginManager pluginManager, f f2, c c2, Clock clock, TelemetryMetrics telemetryMetrics, C2Compiler c2Compiler, ScheduledExecutorService scheduledExecutorService) {
        this.pluginManager = pluginManager;
        this.firstRequestEndListener = f2;
        this.isFirstRequest = new AtomicBoolean(true);
        this.eventBus = c2;
        this.featureSamplingEnabled = config.getBoolean(ConfigProperty.FEATURE_REQUEST_SAMPLING_ENABLED);
        this.featureSamplingFrequency = config.getInt(ConfigProperty.FEATURE_REQUEST_SAMPLING_FREQUENCY);
        this.memoryBufferPool = new MemoryBuffer.MemoryBufferPool(clock, config);
        this.contentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("requestContentLengthExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
        this.memoryBufferDistributionSummary = telemetryMetrics.newDistributionSummary("memoryBufferTotalCountExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("Number of Objects Currently Being Managed by MemoryBufferPool").withBucketBoundaries(d.j).withBaseUnit("count").register();
        this.multipartContentTypeCounter = telemetryMetrics.newCounter("multipartContentTypeCount", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The number of requests seen with a Multipart Content-Type").register();
        this.multipartContentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("multipartContentLengths", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of Multipart requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
        this.c2Compiler = Objects.requireNonNull(c2Compiler);
        this.commonExecutor = Objects.requireNonNull(scheduledExecutorService);
        int n2 = config.getInt(ConfigProperty.MAX_RESPONSE_BODY_SIZE);
        this.maxResponseBodySize = n2 < 0 ? HttpResponse.DEFAULT_BODY_SIZE_LIMIT : n2;
        this.integrationTestsEnabled = config.getBoolean(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES);
    }

    public PurgeableObjectPool<MemoryBuffer> getMemoryBufferPool() {
        return this.memoryBufferPool;
    }

    public HttpRequest onRequestStart(ContrastContext contrastContext, HttpRequestFactory httpRequestFactory) {
        if (contrastContext == null) {
            logger.debug("onRequestStart() ContrastContext was null, cannot continue");
            return null;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("{} - onRequestStart() Application is null, cannot continue", (Object)contrastContext.http().identities());
            return null;
        }
        if (httpRequestFactory == null) {
            logger.debug("{} - onRequestStart() HttpRequestFactory is null, cannot continue", (Object)contrastContext.http().identities());
            return null;
        }
        HttpRequest httpRequest = httpRequestFactory.create();
        if (httpRequest == null) {
            logger.debug("{} - onRequestStart() HttpRequest was null, cannot continue", (Object)contrastContext.http().identities());
            return null;
        }
        httpRequestFactory.postCreateProcessing(contrastContext);
        contrastContext.http().setRequest(httpRequest);
        contrastContext.http().clearBodyListeners();
        this.preCalculateUrlExclusions(application, httpRequest);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<RequestLifecycleListener> list = contrastPlugin.getRequestLifecycleListeners();
            for (RequestLifecycleListener requestLifecycleListener : list) {
                requestLifecycleListener.onRequestStart(contrastContext);
            }
            if (!contrastPlugin.requiresHttpRequestBodyBuffering(contrastContext)) {
                return;
            }
            httpRequest.enableCapturing();
            atomicInteger.set(Math.max(atomicInteger.get(), contrastPlugin.limitRequestBodySizeCapturing()));
            contrastContext.http().addRequestBodyListeners(contrastPlugin.getRequestBodyListeners());
        });
        if (atomicInteger.get() > 0) {
            if (httpRequest.isGzipFromHeader()) {
                httpRequest.maxBufferSize(atomicInteger.get());
            } else {
                httpRequest.maxBufferSize(Math.min(atomicInteger.get(), httpRequest.getContentLength()));
            }
        }
        this.pluginManager.forEachDisabled(contrastContext, contrastPlugin -> {
            List<RequestLifecycleListener> list = contrastPlugin.getRequestLifecycleListeners();
            for (RequestLifecycleListener requestLifecycleListener : list) {
                requestLifecycleListener.onRequestStartDisabled(contrastContext);
            }
        });
        return httpRequest;
    }

    @ScopedSensor
    public void onByteRead(ContrastContext contrastContext, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpContext httpContext = contrastContext.http();
            HttpRequest httpRequest = httpContext.getRequest();
            if (httpRequest == null) {
                scopeProvider.leaveScope();
                return;
            }
            if (n2 < 0) {
                if (n2 == -1) {
                    for (k k2 : httpContext.getRequestBodyListeners()) {
                        k2.onBodyReadEnd(contrastContext);
                    }
                }
            } else if (httpRequest.writeToBuffer(this.memoryBufferPool, n2)) {
                for (k k3 : httpContext.getRequestBodyListeners()) {
                    k3.onBodyChunkRead(contrastContext);
                }
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(ContrastContext contrastContext, int n2, byte[] byArray, int n3) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpContext httpContext = contrastContext.http();
            HttpRequest httpRequest = httpContext.getRequest();
            if (httpRequest == null) {
                scopeProvider.leaveScope();
                return;
            }
            if (n2 == -1) {
                for (k k2 : httpContext.getRequestBodyListeners()) {
                    k2.onBodyReadEnd(contrastContext);
                }
            } else if (httpRequest.writeToBuffer(this.memoryBufferPool, byArray, n3, n2)) {
                for (k k3 : httpContext.getRequestBodyListeners()) {
                    k3.onBodyChunkRead(contrastContext);
                }
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onFullBytesRead(ContrastContext contrastContext, byte[] byArray, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.onBytesRead(contrastContext, n2, byArray, 0);
            for (k k2 : contrastContext.http().getRequestBodyListeners()) {
                k2.onBodyReadEnd(contrastContext);
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onByteWritten(ContrastContext contrastContext, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpResponse httpResponse = contrastContext.http().getResponse();
            if (httpResponse != null) {
                httpResponse.writeToBuffer(this.memoryBufferPool, n2);
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesWritten(ContrastContext contrastContext, byte[] byArray, int n2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.onBytesWritten(contrastContext, byArray, 0, n2);
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesWritten(ContrastContext contrastContext, byte[] byArray, int n2, int n3) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpResponse httpResponse = contrastContext.http().getResponse();
            if (httpResponse != null) {
                httpResponse.writeToBuffer(this.memoryBufferPool, byArray, n2, n3);
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    public void onResponseStart(ContrastContext contrastContext, HttpResponseFactory httpResponseFactory) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("{} - Current HTTPRequest was null", (Object)contrastContext.http().identities());
            return;
        }
        if (httpResponseFactory == null) {
            logger.debug("{} - HttpResponseFactory was null", (Object)contrastContext.http().identities());
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("{} - Current application was null", (Object)contrastContext.http().identities());
            return;
        }
        HttpResponse httpResponse = httpResponseFactory.create();
        contrastContext.http().setResponse(httpResponse);
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            if (contrastPlugin.requiresHttpResponseBuffering(contrastContext)) {
                httpResponse.enableCapturing();
                httpResponse.maxBufferSize(this.maxResponseBodySize);
                logger.debug("{} - Capturing response to memory with max size of {}", (Object)contrastContext.http().identities(), (Object)this.maxResponseBodySize);
            }
        });
        httpResponseFactory.postCreateProcessing(contrastContext);
    }

    public void onResponseHeaderSet(ContrastContext contrastContext, String string, String string2) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            logger.debug("{} - Header name or value was blank, header: {}, headerVal: {}", contrastContext.http().identities(), string, string2);
            return;
        }
        HttpContext httpContext = contrastContext.http();
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpContext.getRequest() == null) {
            logger.debug("{} - Request was null", (Object)contrastContext.http().identities());
            return;
        }
        if (httpResponse == null) {
            logger.debug("{} - Response was null", (Object)contrastContext.http().identities());
            return;
        }
        boolean bl2 = false;
        HttpHeader httpHeader = HttpHeader.get(string);
        if (httpHeader == StandardHttpHeader.CONTENT_DISPOSITION && string2.contains("attachment")) {
            bl2 = true;
        } else if (httpHeader == StandardHttpHeader.CONTENT_TYPE && !StringUtils.startsWithAny(string2.toLowerCase(), ALLOWED_CONTENT_TYPES)) {
            bl2 = true;
        }
        Map<String, List<String>> map = httpResponse.getHeaders();
        List list = map.getOrDefault(httpHeader.headerName(), new ArrayList());
        list.add(string2);
        map.put(httpHeader.headerName(), list);
        if (bl2) {
            httpResponse.disableCapturing();
            logger.debug("{} - Disabling saving response to memory:{}: {}, {}", contrastContext.http().identities(), string, string2, contrastContext.http().getRequest().getUri());
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<RequestLifecycleListener> list = contrastPlugin.getRequestLifecycleListeners();
            for (RequestLifecycleListener requestLifecycleListener : list) {
                requestLifecycleListener.onResponseHeaderSet(contrastContext, string, string2);
            }
        });
    }

    public void onRequestEnd(ContrastContext contrastContext) {
        HttpContext httpContext = contrastContext.http();
        HttpRequest httpRequest = httpContext.getRequest();
        if (httpRequest == null || !httpRequest.endRequest()) {
            return;
        }
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpResponse != null) {
            this.eventBus.a(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled() && httpResponse == null) {
            this.logCrumbData(contrastContext);
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            List<RequestLifecycleListener> list = contrastPlugin.getRequestLifecycleListeners();
            for (RequestLifecycleListener requestLifecycleListener : list) {
                try {
                    requestLifecycleListener.onRequestEnd(contrastContext);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("{} - Problem ending request watching with {}", contrastContext.http().identities(), requestLifecycleListener, throwable2);
                }
            }
        });
        this.pluginManager.forEachDisabled(contrastContext, contrastPlugin -> {
            List<RequestLifecycleListener> list = contrastPlugin.getRequestLifecycleListeners();
            for (RequestLifecycleListener requestLifecycleListener : list) {
                try {
                    requestLifecycleListener.onRequestEndDisabled(contrastContext);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("{} - Problem ending request watching with {}", contrastContext.http().identities(), requestLifecycleListener, throwable2);
                }
            }
        });
        this.contentLengthDistributionSummary.record(httpRequest.getContentLength());
        this.memoryBufferDistributionSummary.record(this.getMemoryBufferPool().totalCount());
        if (httpRequest.getContentType().isMultipart()) {
            this.multipartContentTypeCounter.increment();
            this.multipartContentLengthDistributionSummary.record(httpRequest.getContentLength());
        }
        httpRequest.closeBuffer();
        if (httpResponse != null) {
            httpResponse.closeBuffer();
        }
        httpContext.clear();
        contrastContext.application().current(null);
        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpRequest.startTimeNs());
        httpRequest.getJfrEvent().a(httpRequest, httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}\n\t- {}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2, contrastContext.http().identities());
        }
        if (this.isFirstRequest.get() && this.isFirstRequest.getAndSet(false)) {
            this.c2Compiler.reEnableC2CompilationIfNecessary(this.commonExecutor, 1L);
            this.firstRequestEndListener.onFirstRequestEnd(l2);
        }
        if (this.integrationTestsEnabled) {
            IntegrationTestServices.getInstance().onRequestEnd(httpRequest);
        }
    }

    public void onMultipartHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("{} - Current application is null", (Object)contrastContext.http().identities());
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("{} - Current request is null", (Object)contrastContext.http().identities());
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            h h2 = contrastPlugin.getMultipartListener();
            h2.onHeaderRead(contrastContext, multipartItem);
        });
    }

    public void onParametersResolved(ContrastContext contrastContext) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("{} - Current application is null", (Object)contrastContext.http().identities());
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("{} - Current request is null", (Object)contrastContext.http().identities());
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            i i2 = contrastPlugin.getParameterListener();
            i2.a(contrastContext);
        });
    }

    public void onMoreParametersResolved(ContrastContext contrastContext, Map<String, String[]> map) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("{} - Current application is null", (Object)contrastContext.http().identities());
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("{} - Current request is null", (Object)contrastContext.http().identities());
            return;
        }
        this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
            i i2 = contrastPlugin.getParameterListener();
            i2.a(contrastContext, map);
        });
    }

    @Override
    @ScopedSensor
    public void onBodyInputReceived(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.protect.d.h h2, String string, String string2) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            Application application = contrastContext.application().current();
            if (application == null) {
                logger.debug("{} - Current application is null", (Object)contrastContext.http().identities());
                scopeProvider.leaveScope();
                return;
            }
            HttpRequest httpRequest = contrastContext.http().getRequest();
            if (httpRequest == null) {
                logger.debug("{} - Current request is null", (Object)contrastContext.http().identities());
                scopeProvider.leaveScope();
                return;
            }
            this.pluginManager.forEachEnabled(contrastContext, contrastPlugin -> {
                a a2 = contrastPlugin.getBodyInputListener();
                a2.onBodyInputReceived(contrastContext, h2, string, string2);
            });
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    public boolean isSamplingCurrentRequest(ContrastContext contrastContext, g g2) {
        if (!this.featureSamplingEnabled) {
            return false;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        return httpRequest != null && httpRequest.isSampling(g2, this::initialIsSamplingValue);
    }

    private void logCrumbData(ContrastContext contrastContext) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("{} - Unexpected null response for request=[{}], CRUMB:\n{}", contrastContext.http().identities(), contrastContext.http().getRequest(), stringBuilder);
    }

    private boolean initialIsSamplingValue(g g2) {
        return ThreadLocalRandom.current().nextInt(1, this.featureSamplingFrequency + 1) == 1;
    }

    private void preCalculateUrlExclusions(Application application, HttpRequest httpRequest) {
        com.contrastsecurity.agent.apps.exclusions.c.a(application, httpRequest);
    }
}

