/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages;

import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public interface Maskable<T> {
    public static final String MASKED = "xxxx";
    public static final List<String> MASKED_SINGLETON_LIST = Collections.singletonList("xxxx");
    public static final String[] NORMALIZATION_TOKENS = new String[]{"{n}", "{uuid}", "{sid}", "{hash}"};
    public static final Set<String> HEADER_ALLOWLIST = Sets.of("Content-Type", "Content-Length", "Host", "Accept", "Accept-Encoding", "Sec-Fetch-Dest", "Sec-Fetch-Mode", "Sec-Fetch-Site", "Sec-Fetch-User", "X-Requested-With", "X-Forwarded-Host", "X-Frame-Options", "X-Content-Type-Options", "Cache-Control", "User-Agent");

    public T mask();

    public static String maskUri(String string) {
        StringJoiner stringJoiner = new StringJoiner("/", "/", "");
        for (String string2 : string.split("/")) {
            if (string2.isEmpty()) continue;
            if (StringUtils.startsWithAny(string2, NORMALIZATION_TOKENS) || string2.length() <= 2) {
                stringJoiner.add(string2);
                continue;
            }
            stringJoiner.add(string2.substring(0, 2) + MASKED);
        }
        return stringJoiner.toString();
    }

    public static Map<String, List<String>> maskHeaders(Map<String, List<String>> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string : map.keySet()) {
            hashMap.put(string, HEADER_ALLOWLIST.contains(string) ? map.get(string) : MASKED_SINGLETON_LIST);
        }
        return hashMap;
    }
}

