/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.protect;

import com.contrastsecurity.agent.messages.app.activity.protect.AttackResult;
import com.contrastsecurity.agent.messages.app.activity.protect.RuleEventsDTM;
import java.util.Collections;

public final class ProtectionRuleActivityDTM<T> {
    private final long startTime;
    private final RuleEventsDTM<T> ineffective;
    private final RuleEventsDTM<T> blocked;
    private final RuleEventsDTM<T> exploited;
    private final RuleEventsDTM<T> blockedAtPerimeter;
    private final RuleEventsDTM<T> suspicious;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private ProtectionRuleActivityDTM(Builder<T> builder) {
        this.startTime = ((Builder)builder).startTime;
        this.ineffective = ((Builder)builder).ineffective;
        this.blocked = ((Builder)builder).blocked;
        this.exploited = ((Builder)builder).exploited;
        this.blockedAtPerimeter = ((Builder)builder).blockedAtPerimeter;
        this.suspicious = ((Builder)builder).suspicious;
    }

    public RuleEventsDTM<T> getWithAttackResult(AttackResult attackResult) {
        switch (attackResult) {
            case SUSPICIOUS: {
                return this.suspicious;
            }
            case BLOCKED: {
                return this.blocked;
            }
            case EXPLOITED: {
                return this.exploited;
            }
            case BLOCKED_AT_PERIMETER: {
                return this.blockedAtPerimeter;
            }
        }
        return this.ineffective;
    }

    public RuleEventsDTM<T> getIneffective() {
        return this.ineffective;
    }

    public RuleEventsDTM<T> getBlocked() {
        return this.blocked;
    }

    public RuleEventsDTM<T> getExploited() {
        return this.exploited;
    }

    public RuleEventsDTM<T> getBlockedAtPerimeter() {
        return this.blockedAtPerimeter;
    }

    public RuleEventsDTM<T> getSuspicious() {
        return this.suspicious;
    }

    public static final class Builder<T> {
        private long startTime;
        private RuleEventsDTM<T> ineffective = new RuleEventsDTM(Collections.emptyList(), 0, System.currentTimeMillis());
        private RuleEventsDTM<T> blocked = new RuleEventsDTM(Collections.emptyList(), 0, System.currentTimeMillis());
        private RuleEventsDTM<T> exploited = new RuleEventsDTM(Collections.emptyList(), 0, System.currentTimeMillis());
        private RuleEventsDTM<T> blockedAtPerimeter = new RuleEventsDTM(Collections.emptyList(), 0, System.currentTimeMillis());
        private RuleEventsDTM<T> suspicious = new RuleEventsDTM(Collections.emptyList(), 0, System.currentTimeMillis());

        public Builder<T> startTime(long l2) {
            this.startTime = l2;
            return this;
        }

        public Builder<T> ineffective(RuleEventsDTM<T> ruleEventsDTM) {
            this.ineffective = ruleEventsDTM;
            return this;
        }

        public Builder<T> blocked(RuleEventsDTM<T> ruleEventsDTM) {
            this.blocked = ruleEventsDTM;
            return this;
        }

        public Builder<T> exploited(RuleEventsDTM<T> ruleEventsDTM) {
            this.exploited = ruleEventsDTM;
            return this;
        }

        public Builder<T> blockedAtPerimeter(RuleEventsDTM<T> ruleEventsDTM) {
            this.blockedAtPerimeter = ruleEventsDTM;
            return this;
        }

        public Builder<T> suspicious(RuleEventsDTM<T> ruleEventsDTM) {
            this.suspicious = ruleEventsDTM;
            return this;
        }

        public ProtectionRuleActivityDTM<T> build() {
            return new ProtectionRuleActivityDTM(this);
        }
    }
}

