/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.finding.trace;

import java.util.Collections;
import java.util.List;

public final class EventSignatureDTM {
    private final String returnType;
    private final String className;
    private final String methodName;
    private final List<String> argTypes;
    private final boolean constructor;
    private final int flags;
    private final String operator;

    private EventSignatureDTM(Builder builder) {
        this.returnType = builder.returnType;
        this.className = builder.className;
        this.constructor = builder.constructor;
        this.flags = builder.flags;
        this.methodName = builder.methodName;
        this.argTypes = builder.argTypes;
        this.operator = builder.operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getArgTypes() {
        return this.argTypes;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return "EventSignatureDTM{returnType='" + this.returnType + '\'' + ", className='" + this.className + '\'' + ", methodName='" + this.methodName + '\'' + ", argTypes=" + this.argTypes + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String returnType;
        private String className;
        private String methodName;
        private List<String> argTypes = Collections.emptyList();
        private boolean constructor;
        private int flags;
        private String operator;

        private Builder() {
        }

        public Builder setReturnType(String string) {
            this.returnType = string;
            return this;
        }

        public Builder setClassName(String string) {
            this.className = string;
            return this;
        }

        public Builder setMethodName(String string) {
            this.methodName = string;
            return this;
        }

        public Builder setArgTypes(List<String> list) {
            this.argTypes = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder setConstructor(boolean bl2) {
            this.constructor = bl2;
            return this;
        }

        public Builder setFlags(int n2) {
            this.flags = n2;
            return this;
        }

        public Builder setOperator(String string) {
            this.operator = string;
            return this;
        }

        public EventSignatureDTM build() {
            return new EventSignatureDTM(this);
        }
    }
}

