/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.routes;

import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.contrastapi_v1_0.StandardRequestMethod;
import com.contrastsecurity.agent.messages.Maskable;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceTypeDTM;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.thirdparty.cggl.gson.JsonArray;
import com.contrastsecurity.thirdparty.cggl.gson.JsonDeserializationContext;
import com.contrastsecurity.thirdparty.cggl.gson.JsonDeserializer;
import com.contrastsecurity.thirdparty.cggl.gson.JsonElement;
import com.contrastsecurity.thirdparty.cggl.gson.JsonObject;
import com.contrastsecurity.thirdparty.cggl.gson.JsonParseException;
import com.contrastsecurity.thirdparty.cggl.gson.JsonPrimitive;
import com.contrastsecurity.thirdparty.cggl.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.cggl.gson.JsonSerializer;
import com.contrastsecurity.thirdparty.cggl.gson.annotations.JsonAdapter;
import com.contrastsecurity.thirdparty.cggl.gson.annotations.SerializedName;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ObjectUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@HeapUsage.SupportsHeapProfiling
public class ObservedRoute
implements Maskable<ObservedRoute> {
    public static final Set<RequestMethod> OBSERVABLE_HTTP_METHODS = Sets.of(StandardRequestMethod.GET, StandardRequestMethod.HEAD, StandardRequestMethod.POST, StandardRequestMethod.PUT, StandardRequestMethod.DELETE, StandardRequestMethod.OPTIONS);
    @SerializedName(value="verb")
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final RequestMethod requestMethod;
    @HeapUsage.Deep
    private final String url;
    @HeapUsage.Deep
    private final String signature;
    @SerializedName(value="session_id")
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final String sessionId;
    @JsonAdapter(value=EventSourceSerializerDeserializer.class)
    @HeapUsage.Deep
    private final Set<EventSourceDTM> sources;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final String template;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    private final RouteType type;

    private ObservedRoute(Builder builder) {
        this.requestMethod = Objects.requireNonNull(builder.requestMethod);
        this.url = Objects.requireNonNull(builder.url).startsWith("/") ? builder.url : "/" + builder.url;
        this.signature = Objects.requireNonNull(builder.signature);
        this.sessionId = Objects.requireNonNull(builder.sessionId);
        this.sources = Sets.copy(builder.sources);
        this.type = ObjectUtils.defaultIfNull(builder.type, RouteType.HTTP);
        if (builder.template == null || builder.template.length() == 1) {
            this.template = builder.template;
        } else {
            String string = builder.template.startsWith("/") ? builder.template : "/" + builder.template;
            this.template = string = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public RequestMethod requestMethod() {
        return this.requestMethod;
    }

    public String url() {
        return this.url;
    }

    public String signature() {
        return this.signature;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public Collection<EventSourceDTM> sources() {
        return this.sources;
    }

    public String template() {
        return this.template;
    }

    public RouteType type() {
        return this.type;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().signature(this.signature).requestMethod(this.requestMethod).url(this.url).sessionId(this.sessionId).template(this.template).type(this.type);
        this.sources.forEach(builder::addSource);
        return builder;
    }

    public JsonElement toRouteCoverageJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("count", new JsonPrimitive(1));
        jsonObject.add("signature", new JsonPrimitive(this.signature));
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("url", new JsonPrimitive(this.url));
        jsonObject2.add("type", new JsonPrimitive(this.type.toString()));
        if (this.requestMethod != null) {
            jsonObject2.add("verb", new JsonPrimitive(this.requestMethod.methodName()));
        }
        JsonArray jsonArray = new JsonArray(1);
        jsonArray.add(jsonObject2);
        jsonObject.add("observations", jsonArray);
        JsonArray jsonArray2 = new JsonArray(1);
        jsonArray2.add(jsonObject);
        return jsonArray2;
    }

    public static Optional<ObservedRoute> fromRouteCoverageJson(JsonArray jsonArray, String string) {
        if (jsonArray == null || string == null || jsonArray.size() != 1) {
            return Optional.empty();
        }
        JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
        JsonObject jsonObject2 = jsonObject.getAsJsonArray("observations").get(0).getAsJsonObject();
        StandardRequestMethod standardRequestMethod = jsonObject2.get("verb").getAsString() == null ? StandardRequestMethod.ALL : RequestMethod.of(jsonObject2.get("verb").getAsString());
        RouteType routeType = RouteType.valueOf(jsonObject2.get("type").getAsString());
        return Optional.of(ObservedRoute.builder().signature(jsonObject.get("signature").getAsString()).requestMethod(standardRequestMethod).url(jsonObject2.get("url").getAsString()).sessionId(string).type(routeType).build());
    }

    public String toString() {
        return "ObservedRoute{requestMethod=" + this.requestMethod + ", url='" + this.url + '\'' + ", signature='" + this.signature + '\'' + ", sessionId='" + this.sessionId + '\'' + ", sources=" + this.sources + ", template='" + this.template + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservedRoute observedRoute = (ObservedRoute)object;
        return this.requestMethod == observedRoute.requestMethod && Objects.equals(this.url, observedRoute.url) && Objects.equals(this.signature, observedRoute.signature) && Objects.equals(this.sessionId, observedRoute.sessionId) && Objects.equals(this.sources, observedRoute.sources) && Objects.equals(this.template, observedRoute.template) && Objects.equals((Object)this.type, (Object)observedRoute.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestMethod, this.url, this.signature, this.sessionId, this.sources, this.template, this.type});
    }

    public int hashForReporting() {
        return Objects.hash(new Object[]{this.requestMethod, this.signature, this.sources, this.type});
    }

    @Override
    public ObservedRoute mask() {
        Builder builder = this.toBuilder();
        String string = builder.template;
        if (string != null) {
            builder.url(string);
        } else {
            builder.url(Maskable.maskUri(builder.url));
        }
        return builder.build();
    }

    public static boolean isValid(ObservedRoute observedRoute) {
        return observedRoute != null && observedRoute.sources != null && !StringUtils.isBlank(observedRoute.signature) && !StringUtils.isBlank(observedRoute.url);
    }

    @HeapUsage.SupportsHeapProfiling
    private static final class ObservedRouteJson
    extends ObservedRoute {
        private ObservedRouteJson(Builder builder) {
            super(builder);
        }
    }

    public static final class ObservedRouteSerializer
    implements JsonSerializer<ObservedRoute> {
        private final Supplier<Boolean> isProductionSupplier;

        public ObservedRouteSerializer(Supplier<Boolean> supplier) {
            this.isProductionSupplier = Objects.requireNonNull(supplier);
        }

        @Override
        public JsonElement serialize(ObservedRoute observedRoute, Type type, JsonSerializationContext jsonSerializationContext) {
            boolean bl2 = this.isProductionSupplier.get();
            if (bl2) {
                return jsonSerializationContext.serialize(observedRoute.mask(), (Type)((Object)ObservedRouteJson.class));
            }
            return jsonSerializationContext.serialize(observedRoute, (Type)((Object)ObservedRouteJson.class));
        }
    }

    private static final class EventSourceSerializerDeserializer
    implements JsonDeserializer<Set<EventSourceDTM>>,
    JsonSerializer<Set<EventSourceDTM>> {
        private EventSourceSerializerDeserializer() {
        }

        @Override
        public JsonElement serialize(Set<EventSourceDTM> set, Type type, JsonSerializationContext jsonSerializationContext) {
            if (set == null || set.isEmpty()) {
                return new JsonArray();
            }
            JsonArray jsonArray = new JsonArray(set.size());
            for (EventSourceDTM eventSourceDTM : set) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("name", eventSourceDTM.getSourceName());
                jsonObject.addProperty("type", eventSourceDTM.getSourceType().toString());
                jsonArray.add(jsonObject);
            }
            return jsonArray;
        }

        @Override
        public Set<EventSourceDTM> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement == null || !jsonElement.isJsonArray() || jsonElement.getAsJsonArray().isEmpty()) {
                return Collections.emptySet();
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            HashSet<EventSourceDTM> hashSet = new HashSet<EventSourceDTM>(jsonArray.size());
            for (JsonElement jsonElement2 : jsonArray) {
                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                if (jsonObject.get("type") == null) continue;
                hashSet.add(new EventSourceDTM(EventSourceTypeDTM.valueOf(jsonObject.get("type").getAsString()), jsonObject.get("name") != null ? jsonObject.get("name").getAsString() : null));
            }
            return hashSet;
        }
    }

    public static final class Builder {
        private RequestMethod requestMethod;
        private String url;
        private String signature;
        private String sessionId;
        private final Collection<EventSourceDTM> sources = new HashSet<EventSourceDTM>();
        private Collection<String> mappings = Collections.emptyList();
        private String template;
        private RouteType type;

        public Builder requestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder url(String string) {
            this.url = string;
            return this;
        }

        public Builder signature(String string) {
            this.signature = string;
            return this;
        }

        public Builder sessionId(String string) {
            this.sessionId = string;
            return this;
        }

        public Builder addSource(EventSourceDTM eventSourceDTM) {
            this.sources.add(Objects.requireNonNull(eventSourceDTM));
            return this;
        }

        public Builder template(String string) {
            this.template = string;
            return this;
        }

        public Builder type(RouteType routeType) {
            this.type = routeType;
            return this;
        }

        public ObservedRoute build() {
            return new ObservedRoute(this);
        }
    }
}

