/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.opentelemetry;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.opentelemetry.b;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.CollectionRegistration;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.export.MetricProducer;
import java.time.Duration;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@DontObfuscate
public final class FakeMetricReader
implements MetricReader {
    private final BlockingQueue<MetricData> metrics = new ArrayBlockingQueue<MetricData>(500);
    private final ScheduledExecutorService executorService;

    FakeMetricReader(ScheduledExecutorService scheduledExecutorService) {
        this.executorService = scheduledExecutorService;
    }

    public Stream<MetricData> observedMetrics() {
        return this.observedMetrics(Duration.ofMillis(5000L));
    }

    public Stream<MetricData> observedMetrics(Duration duration) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new b<MetricData>(this.metrics, duration), 0), false);
    }

    public void clear() {
        this.metrics.clear();
    }

    @Override
    public void register(CollectionRegistration collectionRegistration) {
        MetricProducer metricProducer = MetricProducer.asMetricProducer(collectionRegistration);
        this.executorService.scheduleAtFixedRate(() -> metricProducer.collectAllMetrics().forEach(this.metrics::offer), 10L, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.metrics.clear();
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporalitySelector.deltaPreferred().getAggregationTemporality(instrumentType);
    }
}

