/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.opentelemetry;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.h.b;
import com.contrastsecurity.agent.opentelemetry.ContrastHttpSenderProvider;
import com.contrastsecurity.agent.opentelemetry.FakeLogRecordProcessor;
import com.contrastsecurity.agent.opentelemetry.FakeMetricReader;
import com.contrastsecurity.agent.opentelemetry.FakeSpanProcessor;
import com.contrastsecurity.agent.opentelemetry.a;
import com.contrastsecurity.agent.opentelemetry.d;
import com.contrastsecurity.agent.opentelemetry.h;
import com.contrastsecurity.agent.opentelemetry.j;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.BatchLogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.LogRecordExporter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.PeriodicMetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

@DontObfuscate
public class OtelGlobalConfig {
    private final boolean otelEnabled;
    private final boolean tracingEnabled;
    private final Clock clock;
    private final Sampler sampler;
    private final SpanProcessor spanProcessor;
    private final boolean metricsEnabled;
    private final MetricReader metricReader;
    private final ExemplarFilter exemplarFilter;
    private final LogRecordProcessor logRecordProcessor;
    public static final OtelGlobalConfig NO_OP = new OtelGlobalConfig(false, false, null, null, null, false, null, null, null);

    private OtelGlobalConfig(boolean bl2, boolean bl3, Clock clock, SpanProcessor spanProcessor, Sampler sampler, boolean bl4, MetricReader metricReader, ExemplarFilter exemplarFilter, LogRecordProcessor logRecordProcessor) {
        this.sampler = sampler;
        this.tracingEnabled = bl3;
        this.clock = clock;
        this.spanProcessor = spanProcessor;
        this.metricReader = metricReader;
        this.metricsEnabled = bl4;
        this.otelEnabled = bl2;
        this.exemplarFilter = exemplarFilter;
        this.logRecordProcessor = logRecordProcessor;
    }

    static OtelGlobalConfig createFakeConfig(Config config, ScheduledExecutorService scheduledExecutorService, Clock clock) {
        if (!config.getBoolean(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES)) {
            throw new UnsupportedOperationException("OtelGlobalConfig.createFakeConfig must be used in conjunction with " + IntegrationTestServices.class.getSimpleName() + ", which is not available in production.");
        }
        Sampler sampler = Sampler.parentBasedBuilder(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, config, h.b.a)).setRemoteParentSampled(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, config, h.b.a)).build();
        FakeSpanProcessor fakeSpanProcessor = new FakeSpanProcessor();
        FakeMetricReader fakeMetricReader = new FakeMetricReader(scheduledExecutorService);
        FakeLogRecordProcessor fakeLogRecordProcessor = new FakeLogRecordProcessor();
        return new OtelGlobalConfig(true, true, clock, fakeSpanProcessor, sampler, true, fakeMetricReader, ExemplarFilter.alwaysOn(), fakeLogRecordProcessor);
    }

    static OtelGlobalConfig from(Config config, Clock clock, b b2, ScheduledExecutorService scheduledExecutorService, String string, String string2, String string3) {
        AutoCloseable autoCloseable;
        Objects.requireNonNull(config);
        Objects.requireNonNull(b2);
        Objects.requireNonNull(scheduledExecutorService);
        boolean bl2 = string2 != null;
        boolean bl3 = string != null;
        Preconditions.check(bl2 || bl3, "Both tracing and metrics endpoints cannot be null");
        ContrastHttpSenderProvider.initialize(config, b2);
        SpanProcessor spanProcessor = null;
        Sampler sampler = null;
        if (bl3) {
            sampler = Sampler.parentBasedBuilder(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, config, h.b.a)).setRemoteParentSampled(OtelGlobalConfig.createRouteSampler(scheduledExecutorService, config, h.b.a)).build();
            spanProcessor = config.getBoolean(ConfigProperty.OBSERVE_TRACING_SAMPLING_ENABLE) ? new j(OtlpHttpSpanExporter.builder().setEndpoint(string).build(), clock, config.getLong(ConfigProperty.OBSERVE_TRACING_SAMPLING_INTERVAL), config.getInt(ConfigProperty.ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE)) : new a(OtlpHttpSpanExporter.builder().setEndpoint(string).build());
        }
        d.c c2 = null;
        ExemplarFilter exemplarFilter = null;
        BatchLogRecordProcessor batchLogRecordProcessor = null;
        if (bl2) {
            autoCloseable = Executors.newSingleThreadScheduledExecutor(com.contrastsecurity.agent.scope.b.a("Contrast OTel Metrics Reporting"));
            long l2 = config.getLong(ConfigProperty.OBSERVE_METRICS_EXPORT_INTERVAL);
            Preconditions.check(l2 > 0L, "Metrics export interval must be greater than 0");
            c2 = new d.c(PeriodicMetricReader.builder(OtlpHttpMetricExporter.builder().setAggregationTemporalitySelector(AggregationTemporalitySelector.deltaPreferred()).setEndpoint(string2).build()).setInterval(Duration.ofMillis(l2)).setExecutor((ScheduledExecutorService)autoCloseable).build());
            exemplarFilter = ExemplarFilter.alwaysOn();
        }
        if (string3 != null) {
            autoCloseable = OtlpHttpLogRecordExporter.builder().setEndpoint(string3).build();
            batchLogRecordProcessor = BatchLogRecordProcessor.builder((LogRecordExporter)autoCloseable).build();
        }
        return new OtelGlobalConfig(true, bl3, clock, spanProcessor, sampler, bl2, c2, exemplarFilter, batchLogRecordProcessor);
    }

    private static Sampler createRouteSampler(ScheduledExecutorService scheduledExecutorService, Config config, h.b b2) {
        return new h(scheduledExecutorService, config.getLong(ConfigProperty.OBSERVE_TRACING_SAMPLING_INTERVAL), b2);
    }

    static String telemetryEndpointOrOverride(Config config, ConfigProperty configProperty) {
        String string;
        String string2 = config.getOrNull(configProperty);
        if (string2 != null) {
            return string2;
        }
        switch (configProperty) {
            case OBSERVE_METRICS_ENDPOINT: {
                string = "metrics";
                break;
            }
            case OBSERVE_TRACING_ENDPOINT: {
                string = "traces";
                break;
            }
            case OBSERVE_LOG_RECORD_ENDPOINT: {
                string = "events";
                break;
            }
            default: {
                throw new IllegalArgumentException("Signal must be metrics, traces, or events");
            }
        }
        String string3 = config.getOrNull(ConfigProperty.TEAMSERVER_URL);
        if (string3 != null) {
            string3 = (string3 = string3.replaceFirst("/Contrast/?$", "/")).endsWith("/") ? string3 : string3 + "/";
            string3 = string3 + "agents/v2.0/observability/" + string;
        }
        return string3;
    }

    public boolean isOtelEnabled() {
        return this.otelEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public Sampler sampler() {
        return this.sampler;
    }

    public SpanProcessor spanProcessor() {
        return this.spanProcessor;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public MetricReader metricReader() {
        return this.metricReader;
    }

    public ExemplarFilter exemplarFilter() {
        return this.exemplarFilter;
    }

    public LogRecordProcessor logRecordProcessor() {
        return this.logRecordProcessor;
    }
}

