/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture.model;

import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentDTM;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentType;
import com.contrastsecurity.agent.plugins.architecture.model.DatabaseSpec;
import com.contrastsecurity.agent.plugins.architecture.model.b;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.util.Objects;

public final class ArchitectureComponent {
    private final ArchitectureComponentType type;
    private final String name;
    private final String remoteHost;
    private final String remotePort;
    private final String vendor;
    private final String url;

    private ArchitectureComponent(ArchitectureComponentType architectureComponentType, String string, String string2, String string3, String string4, String string5) {
        this.type = Objects.requireNonNull(architectureComponentType);
        this.name = Objects.requireNonNull(string);
        this.remoteHost = Objects.requireNonNull(string2);
        this.remotePort = Objects.requireNonNull(string3);
        this.vendor = Objects.requireNonNull(string4);
        this.url = Objects.requireNonNull(string5);
    }

    public static ArchitectureComponent webServiceFrom(b b2) {
        String string;
        String string2;
        String string3 = b2.a();
        if (ArchitectureComponent.isInvalidInput(string3, string2 = b2.b(), string = Integer.toString(b2.c()))) {
            return null;
        }
        String string4 = string3 + "://" + string2 + ":" + string;
        return ArchitectureComponent.buildArchitectureComponent(ArchitectureComponentType.WEB_SERVICE, string4, string2, string, "", "");
    }

    public static ArchitectureComponent databaseFrom(DatabaseSpec databaseSpec, boolean bl2, String string, String string2, int n2, String string3) {
        if (databaseSpec == null || StringUtils.isAnyBlank(string, string2)) {
            return null;
        }
        return ArchitectureComponent.buildArchitectureComponent(ArchitectureComponentType.DATABASE, databaseSpec.connectionUrl(bl2, string, string2, n2, string3), string2, Integer.toString(n2), "", "");
    }

    public static ArchitectureComponent databaseFrom(String string, String string2, String string3) {
        return ArchitectureComponent.databaseFrom(string, string2, string3, "", "");
    }

    public static ArchitectureComponent databaseFrom(String string, String string2, String string3, String string4, String string5) {
        if (ArchitectureComponent.isInvalidInput(string, string2, string3)) {
            return null;
        }
        return ArchitectureComponent.buildArchitectureComponent(ArchitectureComponentType.DATABASE, string, string2, string3, string4, string5);
    }

    public static ArchitectureComponent ldapFrom(String string, String string2, String string3) {
        if (ArchitectureComponent.isInvalidInput(string, string2, string3)) {
            return null;
        }
        String string4 = string + "://" + string2 + ":" + string3;
        return ArchitectureComponent.buildArchitectureComponent(ArchitectureComponentType.LDAP, string4, string2, string3, "", "");
    }

    private static boolean isInvalidInput(String string, String string2, String string3) {
        return StringUtils.isBlank(string) || StringUtils.isBlank(string2) || StringUtils.isBlank(string3);
    }

    private static ArchitectureComponent buildArchitectureComponent(ArchitectureComponentType architectureComponentType, String string, String string2, String string3, String string4, String string5) {
        return new ArchitectureComponent(architectureComponentType, string5 == null ? "" : string5, string2.toLowerCase(), string3, string4 == null ? "" : string4, string.toLowerCase());
    }

    public ArchitectureComponentType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String remoteHost() {
        return this.remoteHost;
    }

    public String remotePort() {
        return this.remotePort;
    }

    public String vendor() {
        return this.vendor;
    }

    public String url() {
        return this.url;
    }

    public ArchitectureComponentDTM toDTM() {
        return ArchitectureComponentDTM.builder().remoteHost(this.remoteHost()).remotePort(this.remotePort()).type(this.type()).vendor(this.vendor()).url(this.url()).build();
    }

    public String toString() {
        return "ArchitectureComponent{type=" + (Object)((Object)this.type) + ", name=" + this.name + ", remoteHost=" + this.remoteHost + ", remotePort=" + this.remotePort + ", vendor=" + this.vendor + ", url=" + this.url + "}";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArchitectureComponent) {
            ArchitectureComponent architectureComponent = (ArchitectureComponent)object;
            return this.type.equals((Object)architectureComponent.type()) && this.name.equals(architectureComponent.name()) && this.remoteHost.equals(architectureComponent.remoteHost()) && this.remotePort.equals(architectureComponent.remotePort()) && this.vendor.equals(architectureComponent.vendor()) && this.url.equals(architectureComponent.url());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 1;
        n2 *= 1000003;
        n2 ^= this.type.hashCode();
        n2 *= 1000003;
        n2 ^= this.name.hashCode();
        n2 *= 1000003;
        n2 ^= this.remoteHost.hashCode();
        n2 *= 1000003;
        n2 ^= this.remotePort.hashCode();
        n2 *= 1000003;
        n2 ^= this.vendor.hashCode();
        n2 *= 1000003;
        return n2 ^= this.url.hashCode();
    }
}

