/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.d;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.g;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.q;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.t;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.reflection.ReflectionUtil;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@DontObfuscate
@m
public class ContrastJ2eeRouteDispatcherImpl
implements ContrastJ2eeRouteDispatcher {
    private final RouteObservationProcessor routeObservationProcessor;
    private final Config config;
    static final String WEB_XML_JSP_SERVLETS = "com.contrastsecurity.route.coverage.web.xml.jsp.servlet";
    private static final ExecutionContext.Key<Integer> FACELET_JSP_SCOPE = ExecutionContext.Key.create(Integer.class);
    private static final Logger logger = LoggerFactory.getLogger(ContrastJ2eeRouteDispatcherImpl.class);

    public ContrastJ2eeRouteDispatcherImpl(RouteObservationProcessor routeObservationProcessor, Config config) {
        this.routeObservationProcessor = routeObservationProcessor;
        this.config = config;
    }

    public void onEnterServletRouteObserved(Object object, Object object2, Object object3, boolean bl2, String string, String string2) {
        String string3;
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        if (com.contrastsecurity.agent.plugins.frameworks.http4k.g.a(application)) {
            return;
        }
        g g2 = g.valueOf(string2);
        String string4 = null;
        if (g2 == g.a && ContrastJ2eeRouteDispatcherImpl.shouldObserve(object2)) {
            string3 = this.reflectJspSignature(object2, object3, bl2);
            if (this.routeObservationProcessor.doesCurrentRouteHaveSignature(contrastContext, string3)) {
                httpRequest.context().put(FACELET_JSP_SCOPE, 0);
                return;
            }
            string4 = string3;
        } else if (g2 == g.b || g2 == g.d && ContrastJ2eeRouteDispatcherImpl.shouldObserve(object2)) {
            string3 = object2.getClass().getName() + string;
        } else if (g2 == g.c) {
            String string5 = object2.getClass().getName();
            if (!ContrastJ2eeRouteDispatcherImpl.shouldObserveFilter(string5)) {
                return;
            }
            string3 = string5 + string;
        } else {
            return;
        }
        if (string4 == null) {
            string4 = Reflect.reflect(object3, logger).invoke("getServletPath").asNullableString();
        }
        if (!StringUtils.isEmpty(string4)) {
            httpRequest.setTemplate(string4);
        }
        if (httpRequest.context().get(FACELET_JSP_SCOPE) != null) {
            httpRequest.context().put(FACELET_JSP_SCOPE, httpRequest.context().get(FACELET_JSP_SCOPE) + 1);
        }
        this.routeObservationProcessor.onRouteStart(contrastContext, string3, g2 == g.c ? RouteType.MIDDLEWARE : RouteType.HTTP);
    }

    private static boolean shouldObserve(Object object) {
        Object object2 = Reflect.reflect(object, logger).invoke("getServletConfig").invoke("getServletContext").asNullable(Object.class);
        return object2 != null && !q.b.a(object2);
    }

    private static boolean shouldObserveFilter(String string) {
        return !q.c.contains(string) && !q.d.contains(string);
    }

    public void onExitServletRouteObserved(Object object) {
        int n2;
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Integer n3 = httpRequest.context().get(FACELET_JSP_SCOPE);
        if (n3 != null && (n2 = httpRequest.context().put(FACELET_JSP_SCOPE, n3 - 1).intValue()) == 0) {
            return;
        }
        this.routeObservationProcessor.onRouteEnd(contrastContext);
    }

    public void onFacesServletRouteObserved(Object object, String string) {
        if (string == null) {
            logger.debug("viewId was null");
            return;
        }
        this.routeObservationProcessor.onRouteStart((ContrastContext)object, string, RouteType.HTTP);
    }

    public void onFacesInclude(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        String string = ContrastJ2eeRouteDispatcherImpl.trimFaceletPath(object2.toString());
        this.routeObservationProcessor.onRouteStart(contrastContext, string, RouteType.HTTP);
        this.routeObservationProcessor.onRouteEnd(contrastContext);
    }

    private String reflectJspSignature(Object object, Object object2, boolean bl2) {
        String string;
        String string2 = bl2 ? "jakarta.servlet.include.servlet_path" : "javax.servlet.include.servlet_path";
        Reflect reflect = Reflect.reflect(object2, logger);
        String string3 = reflect.invoke("getAttribute", string2).asNullableString();
        if (string3 == null) {
            string3 = reflect.reset(object2).invoke("getServletPath").asNullableString();
        }
        if (string3 != null && ((string = string3.toLowerCase()).endsWith(".jsp") || string.endsWith(".jspx"))) {
            try {
                return new URI(string3).normalize().getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                return string3;
            }
        }
        string = null;
        try {
            string = ContrastJ2eeRouteDispatcherImpl.extractMappedJspSignature(this.config, object);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            logger.debug("Error occurred during Route Observation reflection of the mapped JSP signature, using default signature", reflectiveOperationException2);
        }
        if (string != null) {
            return string;
        }
        return object.getClass().getName() + (bl2 ? "._jspService(jakarta.servlet.http.HttpServletRequest,jakarta.servlet.http.HttpServletResponse)" : "._jspService(javax.servlet.http.HttpServletRequest,javax.servlet.http.HttpServletResponse)");
    }

    private static String extractMappedJspSignature(Config config, Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2;
        Object object3;
        Method method = ReflectionUtil.findMethod(object.getClass(), "getServletName", new Class[0]);
        Object object4 = object;
        if (method == null) {
            object3 = ReflectionUtil.findField(object.getClass(), "_servletConfig");
            if (object3 == null) {
                return null;
            }
            object2 = ((Field)object3).get(object);
            if (object2 == null) {
                return null;
            }
            method = ReflectionUtil.findMethod(object2.getClass(), "getServletName", new Class[0]);
            if (method == null) {
                return null;
            }
            object4 = object2;
        }
        if (!((object3 = method.invoke(object4, new Object[0])) instanceof String)) {
            return null;
        }
        object2 = (String)object3;
        Method method2 = ReflectionUtil.findMethod(object4.getClass(), "getServletContext", new Class[0]);
        if (method2 == null) {
            return null;
        }
        Object object5 = method2.invoke(object4, new Object[0]);
        if (object5 == null) {
            return null;
        }
        Method method3 = ReflectionUtil.findMethod(object5.getClass(), "getAttribute", String.class);
        if (method3 == null) {
            return null;
        }
        Object object6 = ReflectionUtil.invoke(method3, object5, WEB_XML_JSP_SERVLETS);
        if (!(object6 instanceof Map)) {
            Method method4 = ReflectionUtil.findPublicMethod(object5.getClass(), "setAttribute", String.class, Object.class);
            if (method4 == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (d d2 : d.a(object5, t.a(object5), config.getBoolean(ConfigProperty.ROUTE_OBSERVATION_MIDDLEWARE_ENABLED) && config.getBoolean(ConfigProperty.ROUTE_MIDDLEWARE_REPORTING_ENABLED))) {
                if (!d2.b()) continue;
                for (String string : d2.c()) {
                    hashMap.put(string, d2.a());
                }
            }
            ReflectionUtil.invoke(method4, object5, WEB_XML_JSP_SERVLETS, Collections.unmodifiableMap(hashMap));
            return (String)hashMap.get(object2);
        }
        Object v2 = ((Map)object6).get(object2);
        if (!(v2 instanceof String)) {
            return null;
        }
        return (String)v2;
    }

    private static String trimFaceletPath(String string) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        int n4 = string.indexOf("META-INF/resources");
        if (n4 != -1) {
            return string.substring(n4 + "META-INF/resources".length());
        }
        int n5 = string.indexOf("WEB-INF/lib");
        if (n5 != -1 && (n3 = string.lastIndexOf("!")) != -1 && n3 > n5) {
            return string.substring(n3 + 1);
        }
        n3 = string.indexOf(47);
        if (n3 != 0 && (n2 = string.indexOf(58)) != -1 && n2 < n3) {
            return string.substring(n2 + 1);
        }
        return string;
    }
}

