/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.jackson;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@DontObfuscate
@m
final class ContrastJacksonDispatcherImpl
implements ContrastJacksonDispatcher {
    private final Config config;
    private static final Logger logger = LoggerFactory.getLogger(ContrastJacksonDispatcherImpl.class);

    public ContrastJacksonDispatcherImpl(Config config) {
        this.config = config;
    }

    @ScopedSensor
    public boolean isInterningAllowed() {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = !this.config.getBoolean(ConfigProperty.JACKSON_INTERN_ENABLE);
            if (bl3) {
                scopeProvider.leaveScope();
                return true;
            }
            boolean bl5 = bl2 = !this.config.getBoolean(ConfigProperty.ASSESS_ENABLED);
            if (bl2) {
                logger.debug("Allowing interning because assessment is off");
            } else {
                logger.debug("Disallowing interning because assessment is on");
            }
            scopeProvider.leaveScope();
            return bl2;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }
}

