/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.resteasy;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.agent.plugins.frameworks.jaxrs.c;
import com.contrastsecurity.agent.plugins.route.RouteCoverageUtil;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;

@DontObfuscate
@m
final class ContrastRestEasyRouteDispatcherImpl
implements ContrastRestEasyRouteDispatcher {
    private final RouteObservationProcessor routeObservationProcessor;
    private final Config config;
    private static final Collection<String> INTERCEPTOR_METHODS = Sets.of("getPreMatchInterceptors", "getGlobalResourceInterceptors", "getNameResourceInterceptors");
    private static final ExecutionContext.Key<String> PARENT_TEMPLATE = ExecutionContext.Key.create(String.class);
    private static final Logger logger = LoggerFactory.getLogger(ContrastRestEasyRouteDispatcherImpl.class);

    public ContrastRestEasyRouteDispatcherImpl(RouteObservationProcessor routeObservationProcessor, Config config) {
        this.routeObservationProcessor = routeObservationProcessor;
        this.config = config;
    }

    public void onRouteDiscovered(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.error("We discovered a route but the application is not created yet. Discarding route.");
            return;
        }
        Reflect reflect = Reflect.reflect(object2, logger);
        reflect.invokePublic("getFullpath").asOptional(String.class).ifPresent(string -> reflect.reset(object2).invokePublic("getMethod").asOptional(Method.class).ifPresent(method -> {
            HashSet<DiscoveredRoute> hashSet = new HashSet<DiscoveredRoute>();
            reflect.reset(object2).invoke("getHttpMethods").asOptional(Set.class).orElse(Collections.singleton("ALL")).forEach(object -> {
                if (object instanceof String) {
                    hashSet.add(DiscoveredRoute.builder().requestMethod(RequestMethod.of((String)object)).url(string.startsWith("/") ? string : "/" + string).signature(RouteCoverageUtil.buildRouteSignature(method, RouteCoverageUtil::stripGeneratedProxySignatures)).framework(DiscoveredRoute.Framework.RESTEASY).build());
                }
            });
            application.addDiscoveredRoutes(hashSet);
        }));
    }

    public void onProviderDiscovered(Object object, Class<?> clazz, Class<?> clazz2, Class<?> clazz3, Class<?> clazz4, Class<?> clazz5) {
        if (clazz == null) {
            logger.debug("Provider was null, nothing to discover");
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.error("We discovered a route but the application is not created yet. Discarding route.");
            return;
        }
        HashSet<DiscoveredRoute> hashSet = new HashSet<DiscoveredRoute>();
        boolean bl2 = clazz2.getName().contains("jakarta");
        if (clazz2.isAssignableFrom(clazz)) {
            hashSet.add(c.a.a(clazz.getName(), DiscoveredRoute.Framework.RESTEASY, bl2));
        }
        if (clazz3.isAssignableFrom(clazz)) {
            hashSet.add(c.b.a(clazz.getName(), DiscoveredRoute.Framework.RESTEASY, bl2));
        }
        if (clazz4.isAssignableFrom(clazz)) {
            hashSet.add(c.c.a(clazz.getName(), DiscoveredRoute.Framework.RESTEASY, bl2));
        }
        if (clazz5.isAssignableFrom(clazz)) {
            hashSet.add(c.d.a(clazz.getName(), DiscoveredRoute.Framework.RESTEASY, bl2));
        }
        application.addDiscoveredRoutes(hashSet);
    }

    public void onReactiveRouteDiscovered(Object object, Object object3, String string) {
        if (object3 == null) {
            logger.debug("DeploymentInfo was null, nothing to discover");
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.error("We discovered a route but the application is not created yet. Discarding route.");
            return;
        }
        String string2 = (string = StringUtils.trimToEmpty(string)).length() == 1 ? "" : string;
        Reflect reflect = Reflect.reflect(object3, logger);
        HashMap hashMap = new HashMap();
        reflect.invoke("getLocatableResourceClasses").asOptional(List.class).ifPresent(list -> list.forEach(object -> ContrastRestEasyRouteDispatcherImpl.resourceToDiscoveredRoute(string2, object, reflect, (string, discoveredRoute) -> hashMap.merge(string, Collections.singleton(discoveredRoute), (collection, collection2) -> {
            HashSet hashSet = new HashSet(collection);
            hashSet.addAll(collection2);
            return hashSet;
        }))));
        HashSet<DiscoveredRoute> hashSet = new HashSet<DiscoveredRoute>();
        reflect.reset(object3).invoke("getResourceClasses").asOptional(List.class).ifPresent(list -> list.forEach(object -> hashSet.addAll(ContrastRestEasyRouteDispatcherImpl.resourceToDiscoveredRoute(string2, object, reflect, (string, discoveredRoute) -> hashMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains((CharSequence)string)).forEach(entry -> ((Collection)entry.getValue()).forEach(discoveredRoute2 -> hashSet.add(DiscoveredRoute.builder().url(discoveredRoute.url() + (discoveredRoute2.url().length() <= 1 ? "" : discoveredRoute2.url())).signature(discoveredRoute2.signature()).framework(discoveredRoute2.framework()).requestMethod(discoveredRoute2.requestMethod()).build())))))));
        if (this.config.getBoolean(ConfigProperty.ROUTE_MIDDLEWARE_REPORTING_ENABLED)) {
            boolean bl2 = false;
            try {
                l.d("jakarta.ws.rs.ext.WriterInterceptor");
                bl2 = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean bl3 = bl2;
            reflect.reset(object3).invoke("getInterceptors").asOptional(Object.class).ifPresent(object2 -> {
                reflect.reset(object2).invoke("getContainerRequestFilters").asOptional(Object.class).ifPresent(object -> hashSet.addAll(ContrastRestEasyRouteDispatcherImpl.interceptorToDiscoveredRoute(object, c.c, reflect, bl3)));
                reflect.reset(object2).invoke("getContainerResponseFilters").asOptional(Object.class).ifPresent(object -> hashSet.addAll(ContrastRestEasyRouteDispatcherImpl.interceptorToDiscoveredRoute(object, c.d, reflect, bl3)));
                reflect.reset(object2).invoke("getReaderInterceptors").asOptional(Object.class).ifPresent(object -> hashSet.addAll(ContrastRestEasyRouteDispatcherImpl.interceptorToDiscoveredRoute(object, c.b, reflect, bl3)));
                reflect.reset(object2).invoke("getWriterInterceptors").asOptional(Object.class).ifPresent(object -> hashSet.addAll(ContrastRestEasyRouteDispatcherImpl.interceptorToDiscoveredRoute(object, c.a, reflect, bl3)));
            });
        }
        application.addDiscoveredRoutes(hashSet);
    }

    private static Collection<DiscoveredRoute> interceptorToDiscoveredRoute(Object object, c c2, Reflect reflect, boolean bl2) {
        HashSet<DiscoveredRoute> hashSet = new HashSet<DiscoveredRoute>();
        INTERCEPTOR_METHODS.forEach(string -> reflect.reset(object).invoke((String)string).asOptional(List.class).ifPresent(list -> list.forEach(object -> {
            String string = reflect.reset(object).invoke("getClassName").asString();
            hashSet.add(c2.a(string, DiscoveredRoute.Framework.RESTEASY, bl2));
        })));
        return hashSet;
    }

    private static Collection<DiscoveredRoute> resourceToDiscoveredRoute(String string, Object object, Reflect reflect, BiConsumer<String, DiscoveredRoute> biConsumer) {
        String string2 = reflect.reset(object).invoke("getPath").asString();
        String string3 = string2.length() <= 1 ? "" : string2;
        String string4 = reflect.reset(object).invoke("getClassName").asString();
        HashSet<DiscoveredRoute> hashSet = new HashSet<DiscoveredRoute>();
        reflect.reset(object).invoke("getMethods").asOptional(List.class).ifPresent(list -> list.forEach(object -> {
            String string4 = reflect.reset(object).invoke("getName").asNullableString();
            String string5 = reflect.reset(object).invoke("getHttpMethod").asNullableString();
            StringJoiner stringJoiner = new StringJoiner(",");
            reflect.reset(object).invoke("getParameters").asOptional(Object[].class).ifPresent(objectArray -> Arrays.stream(objectArray).forEach(object -> {
                String string = reflect.reset(object).invoke("getDeclaredType").asString();
                stringJoiner.add(string);
            }));
            String string6 = reflect.reset(object).invoke("getPath").asString();
            String string7 = string4 + "." + string4 + "(" + stringJoiner + ")";
            String string8 = string + string3 + string6;
            DiscoveredRoute discoveredRoute = DiscoveredRoute.builder().framework(DiscoveredRoute.Framework.RESTEASY).requestMethod(RequestMethod.of(string5)).signature(string7).url(string8).build();
            hashSet.add(discoveredRoute);
            biConsumer.accept(string4, discoveredRoute);
        }));
        return hashSet;
    }

    public void onEnterRouteObserved(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Reflect reflect = Reflect.reflect(object2, logger);
        reflect.field("interfaceBasedMethod").asOptional(Method.class).ifPresent(method -> {
            String string = reflect.reset(object2).field("method").field("fullpath").asNullableString();
            this.routeObservationProcessor.onRouteStart(contrastContext, RouteCoverageUtil.buildRouteSignature(method, RouteCoverageUtil::stripGeneratedProxySignatures), ContrastRestEasyRouteDispatcherImpl.processTemplate(string, httpRequest), RouteType.HTTP);
        });
    }

    public void onEnterReactiveRouteObserved(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Reflect reflect = Reflect.reflect(object2, logger);
        reflect.invoke("getResteasyReactiveResourceInfo").invoke("getMethod").asOptional(Method.class).ifPresent(method -> {
            String string = reflect.reset(object2).invoke("getTarget").invoke("getClassPath").field("template").asString();
            String string2 = reflect.reset(object2).invoke("getTarget").invoke("getPath").field("template").asString();
            this.routeObservationProcessor.onRouteStart(contrastContext, RouteCoverageUtil.buildRouteSignature(method, RouteCoverageUtil::stripGeneratedProxySignatures), ContrastRestEasyRouteDispatcherImpl.processTemplate(string + string2, httpRequest), RouteType.HTTP);
        });
    }

    private static String processTemplate(String string, HttpRequest httpRequest) {
        String string2;
        String string3 = httpRequest.context().get(PARENT_TEMPLATE);
        if (string3 == null && string != null) {
            httpRequest.context().put(PARENT_TEMPLATE, string);
            string2 = string;
        } else if (string3 != null) {
            string2 = StringUtils.trimToEmpty(httpRequest.context().get(PARENT_TEMPLATE)) + StringUtils.trimToEmpty(string);
            httpRequest.context().put(PARENT_TEMPLATE, string);
        } else {
            string2 = string;
        }
        return string2;
    }
}

