/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.model.a;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

@DontObfuscate
@m
public final class ContrastSqlDispatcherImpl
implements ContrastSqlDispatcher {
    private final PluginManager pluginManager;
    private final ArchitectureComponentReporter reporter;
    private final Config config;
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private static final Logger logger = LoggerFactory.getLogger(ContrastSqlDispatcherImpl.class);

    ContrastSqlDispatcherImpl(PluginManager pluginManager, ArchitectureComponentReporter architectureComponentReporter, Config config, SqlDatabaseInfoCache sqlDatabaseInfoCache) {
        this.reporter = architectureComponentReporter;
        this.config = config;
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
        this.pluginManager = pluginManager;
    }

    public void onSqlStatementExecuting(Object object, Object object2, Class<?> clazz, Object[] objectArray) {
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        this.reportArchitectureComponent(application, object2);
        String string = ArrayUtils.get(objectArray, 0, "");
        if (!(string instanceof String)) {
            return;
        }
        this.pluginManager.forEachEnabled((ContrastContext)object, contrastPlugin -> {
            if (contrastPlugin.getDatabaseQueryActionListener() != null) {
                contrastPlugin.getDatabaseQueryActionListener().a((ContrastContext)object, a.a(clazz), string);
            }
        });
    }

    private void reportArchitectureComponent(Application application, Object object) {
        Connection connection;
        if (!this.config.isInventoryFeatureEnabled(ConfigProperty.DBINSPECTION) || !(object instanceof Statement)) {
            return;
        }
        try {
            connection = ((Statement)object).getConnection();
        }
        catch (SQLException sQLException) {
            logger.debug("Failed to extract SQL connection from Statement", sQLException);
            return;
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            logger.debug("Failed to extract SQL connection from Statement", runtimeException2);
            return;
        }
        if (connection == null) {
            logger.debug("Obtained a null connection from java.sql.Statement of type {}", (Object)object.getClass());
            return;
        }
        DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
        if (dbInfo == null) {
            logger.debug("Found undetected DB connection of type {} in use", (Object)connection.getClass());
            return;
        }
        String string = dbInfo.host();
        string = string == null && "mem".equals(dbInfo.subtype()) ? "In Memory (alias): " + dbInfo.name() : "In Memory (alias): localhost";
        String string2 = dbInfo.port() == null ? "(unknown)" : String.valueOf(dbInfo.port());
        String string3 = dbInfo.url();
        ArchitectureComponent architectureComponent = ArchitectureComponent.databaseFrom(string3, string, string2);
        if (architectureComponent == null) {
            logger.debug("Cannot profile the database because we were unable to identify the architecture component: {}", (Object)string3);
            return;
        }
        this.reporter.report(application, architectureComponent);
    }

    public void connect(Object object, String string, Object object2) {
        if (this.config.isInventoryFeatureEnabled(ConfigProperty.DBINSPECTION) || this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            Properties properties = object2 instanceof Properties ? (Properties)object2 : null;
            this.sqlDatabaseInfoCache.computeIfAbsent((Connection)object, string, properties);
        }
    }
}

