/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.xenon;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.contrastapi_v1_0.StandardRequestMethod;
import com.contrastsecurity.agent.http.FrameworkInfo;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.j;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.reflection.ReflectionUtil;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DontObfuscate
final class XenonHttpRequestFactory
implements HttpRequestFactory {
    private final WeakReference<Object> originalRequest;
    private final String methodName;
    private final FrameworkInfo frameworkInfo;
    private final HttpManager httpManager;
    private static final Map<String, RequestMethod> METHOD_NAME_MAP = new HashMap<String, RequestMethod>();
    private static final String SERVER_VERSION_INFO = "Xenon/Unknown";
    private static final String PROBLEM_REGENERATING_BODY_INPUT = "xenonProbBodyRegen";
    private static final String PROBLEM_REFLECTING_BODY = "xenonProbRefBody";
    private static final String PROBLEM_REFLECTING_URI = "xenonProbRefUri";
    private static final String PROBLEM_REFLECTING_HEADERS = "xenonProbRefHeaders";
    private static final Logger logger;

    XenonHttpRequestFactory(Object object, String string, FrameworkInfo frameworkInfo, HttpManager httpManager) {
        this.originalRequest = new WeakReference<Object>(object);
        this.methodName = string;
        this.frameworkInfo = frameworkInfo;
        this.httpManager = httpManager;
    }

    @Override
    public HttpRequest create() {
        Object t2 = Objects.requireNonNull(this.originalRequest.get());
        Class<?> clazz = t2.getClass();
        URI uRI = XenonHttpRequestFactory.reflectUri(t2, clazz);
        Map<String, String[]> map = XenonHttpRequestFactory.reflectHeaders(t2, clazz);
        String string = uRI.getRawQuery();
        Map<String, String[]> map2 = !StringUtils.isEmpty(string) ? j.a(string) : new HashMap<String, String[]>();
        HttpRequest httpRequest = new HttpRequest(HttpRequest.HttpRequestType.XENON, this.originalRequest, "/", map, XenonHttpRequestFactory.parseMethod(this.methodName), Protocol.HTTP, HttpVersion.HTTP_1_1, uRI.getPath(), uRI.getRawQuery(), map2, null, uRI.getPort(), SERVER_VERSION_INFO, false);
        httpRequest.setFrameworkInfo(this.frameworkInfo);
        return httpRequest;
    }

    @Override
    public void postCreateProcessing(ContrastContext contrastContext) {
        HttpRequest httpRequest;
        Class<?> clazz;
        Object t2 = Objects.requireNonNull(this.originalRequest.get());
        byte[] byArray = XenonHttpRequestFactory.handleRequestBody(t2, clazz = t2.getClass(), (httpRequest = contrastContext.http().getRequest()).getContentType().getCharset());
        if (!ArrayUtils.isEmpty(byArray)) {
            contrastContext.http().setRequest(httpRequest);
            httpRequest.enableCapturing();
            httpRequest.startWriteToBuffer();
            this.httpManager.onFullBytesRead(contrastContext, byArray, byArray.length);
            httpRequest.stopWriteToBuffer();
        }
        httpRequest.resolvedParameters();
    }

    private static URI reflectUri(Object object, Class<?> clazz) {
        URI uRI = null;
        try {
            Method method = ReflectionUtil.getMethod(clazz, "getUri");
            uRI = (URI)method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            a.a(PROBLEM_REFLECTING_URI, logger, "Problem reflecting URI", throwable2);
            try {
                uRI = new URI("");
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.error("Problem creating default uri", throwable2);
            }
        }
        return uRI;
    }

    private static Map<String, String[]> reflectHeaders(Object object, Class<?> clazz) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try {
            Method method = ReflectionUtil.getMethod(clazz, "getRequestHeaders");
            Map map = (Map)method.invoke(object, new Object[0]);
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                hashMap.put(string, new String[]{string2});
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            a.a(PROBLEM_REFLECTING_HEADERS, logger, "Problem reflecting headers", throwable2);
        }
        return hashMap;
    }

    private static RequestMethod parseMethod(String string) {
        return METHOD_NAME_MAP.getOrDefault(string, StandardRequestMethod.GET);
    }

    private static byte[] handleRequestBody(Object object, Class<?> clazz, Charset charset) {
        Object object2;
        Object object3;
        block7: {
            object3 = ReflectionUtil.getMethod(clazz, "getBodyRaw");
            object2 = ((Method)object3).invoke(object, Empty.OBJ_ARRAY);
            if (object2 == null) {
                logger.debug("Body was null");
                return null;
            }
            logger.debug("Body of type {}", (Object)object2.getClass().getName());
            if (object2 instanceof String) {
                return ((String)object2).getBytes(charset);
            }
            if (!(object2 instanceof byte[])) break block7;
            return (byte[])object2;
        }
        try {
            return ObjectShare.PRETTY_GSON.toJson(object2).getBytes(charset);
        }
        catch (Throwable throwable) {
            try {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                a.a(PROBLEM_REGENERATING_BODY_INPUT, logger, "Problem regenerating body input", throwable2);
            }
            catch (Throwable throwable3) {
                Throwables.throwIfCritical(throwable3);
                object3 = throwable3;
                a.a(PROBLEM_REFLECTING_BODY, logger, "Problem reflecting body", (Throwable)object3);
            }
        }
        return null;
    }

    static {
        METHOD_NAME_MAP.put("handlePut", StandardRequestMethod.PUT);
        METHOD_NAME_MAP.put("handlePost", StandardRequestMethod.POST);
        METHOD_NAME_MAP.put("handleStart", StandardRequestMethod.POST);
        METHOD_NAME_MAP.put("handlePatch", StandardRequestMethod.PATCH);
        METHOD_NAME_MAP.put("handleDelete", StandardRequestMethod.DELETE);
        METHOD_NAME_MAP.put("handleHead", StandardRequestMethod.HEAD);
        METHOD_NAME_MAP.put("handleGet", StandardRequestMethod.GET);
        logger = LoggerFactory.getLogger(XenonHttpRequestFactory.class);
    }
}

