/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.xenon;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.http.ContrastContentType;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.HttpResponseFactory;
import com.contrastsecurity.agent.http.HttpResponseReflector;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@DontObfuscate
final class XenonHttpResponseFactory
implements HttpResponseFactory {
    private final HttpResponseReflector reflector;
    private static final Logger logger = LoggerFactory.getLogger(XenonHttpResponseFactory.class);

    XenonHttpResponseFactory(final Object object) {
        this.reflector = new HttpResponseReflector(){

            @Override
            public int status() {
                return Reflect.reflect(object, logger).fieldCached("statusCode").asInt(-1);
            }

            @Override
            public ContrastContentType frameworkContentType() {
                return ContrastContentType.parse(Reflect.reflect(object, logger).invokeCached("getContentType").asNullableString());
            }
        };
    }

    @Override
    public HttpResponse create() {
        return new HttpResponse(HttpResponse.HttpResponseType.XENON, this.reflector);
    }
}

