/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.opentelemetry.j;
import com.contrastsecurity.agent.plugins.observe.a.a;
import com.contrastsecurity.agent.plugins.observe.c;
import com.contrastsecurity.agent.plugins.observe.deadzone.e;
import com.contrastsecurity.agent.plugins.observe.semconv.SemanticAttributes;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanBuilder;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.iot.api.trace.Tracer;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.context.ContextStorage;
import com.contrastsecurity.thirdparty.iot.context.propagation.ContextPropagators;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public class RootSpan {
    private final Memoizer<Map<String, Integer>> triggeredSensors = Memoizer.memoize(ConcurrentHashMap::new);
    private final Tracer tracer;
    private final OtelGlobalConfig otelGlobalConfig;
    private final SpanBuilder rootSpanBuilder;
    private final e deadzoneManager;
    private final HttpRequest request;
    private final ContextPropagators otelPropagators;
    private final int sensorDeduplicationMax;
    private final long startTimeMs;
    private volatile ReadWriteSpan delegate;
    private final Config config;
    public static ExecutionContext.Key<a> AUTHN_CONTEXT_KEY = ExecutionContext.Key.create(a.class);
    public static ExecutionContext.Key<a> AUTHZ_CONTEXT_KEY = ExecutionContext.Key.create(a.class);
    static final Logger logger = LoggerFactory.getLogger(RootSpan.class);

    RootSpan(Tracer tracer, Clock clock, HttpRequest httpRequest, Config config, e e2, ContextPropagators contextPropagators, OtelGlobalConfig otelGlobalConfig) {
        this.tracer = Objects.requireNonNull(tracer);
        this.startTimeMs = Objects.requireNonNull(clock).now();
        this.request = httpRequest;
        this.rootSpanBuilder = this.tracer.spanBuilder(this.request.getMethod().methodName()).setSpanKind(SpanKind.SERVER).setStartTimestamp(this.startTimeMs, TimeUnit.MILLISECONDS).setAttribute(SemanticAttributes.PROPAGATED_TRACE, Boolean.valueOf(false)).setNoParent();
        this.sensorDeduplicationMax = config.getInt(ConfigProperty.OBSERVE_SENSOR_DEDUPLICATION_MAX);
        this.deadzoneManager = Objects.requireNonNull(e2);
        this.otelPropagators = Objects.requireNonNull(contextPropagators);
        this.otelGlobalConfig = Objects.requireNonNull(otelGlobalConfig);
        this.config = Objects.requireNonNull(config);
    }

    public void startRecording(ContrastContext contrastContext) {
        Object object;
        if (this.delegate != null) {
            throw new IllegalStateException("startRecording was called more than once.");
        }
        if (this.config.getBoolean(ConfigProperty.OBSERVE_DISTRIBUTED_TRACING) && (object = this.extractContext()) != null && object != Context.root()) {
            this.rootSpanBuilder.setAttribute(SemanticAttributes.PROPAGATED_TRACE, Boolean.valueOf(true));
            this.rootSpanBuilder.setParent((Context)object);
        }
        if ((object = this.rootSpanBuilder.startSpan()) instanceof ReadWriteSpan) {
            ReadWriteSpan readWriteSpan = (ReadWriteSpan)object;
            if (readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_REQUEST_METHOD) != null && readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_ROUTE) != null) {
                this.delegate = readWriteSpan;
                this.delegate.makeCurrent();
                this.delegate.updateName(readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_REQUEST_METHOD) + " " + readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_ROUTE));
                this.delegate.setAttribute(SemanticAttributes.PROTECT_EVENT, Boolean.valueOf(false));
                SpanProcessor spanProcessor = this.otelGlobalConfig.spanProcessor();
                if (spanProcessor instanceof j) {
                    ((j)spanProcessor).a(this.delegate.getSpanContext().getTraceId());
                }
            } else {
                logger.debug("http.route={} and/or http.request.method={} are not usable values for span {}", readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_ROUTE), readWriteSpan.getAttribute(ContrastSemanticAttributes.HTTP_REQUEST_METHOD), readWriteSpan.getName());
            }
        }
        this.createCachedAuthenticationSpan(contrastContext, this.request.context().get(AUTHN_CONTEXT_KEY));
        this.createCachedAuthorizationSpan(contrastContext, this.request.context().get(AUTHZ_CONTEXT_KEY));
    }

    private Context extractContext() {
        return this.otelPropagators.getTextMapPropagator().extract(Context.root(), this.request, c.a);
    }

    private void createCachedAuthenticationSpan(ContrastContext contrastContext, a a2) {
        if (a2 == null) {
            return;
        }
        Span span = this.startChildSpan(contrastContext, a2.c(), a2.b());
        if (span == null) {
            return;
        }
        if (a2.e() != null) {
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHENTICATION_MECHANISM, a2.e());
        }
        if (a2.f() != null) {
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHENTICATION_PROTOCOL, a2.f());
        }
        span.end();
        this.popContext();
        a2.d().otel().d().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, a2.c(), ContrastSemanticAttributes.HTTP_ROUTE, this.getHttpRoute(), ContrastSemanticAttributes.HTTP_REQUEST_METHOD, this.getHttpMethod()), span.storeInContext(Context.current()));
    }

    public void popContext() {
        ContextStorage contextStorage = ContextStorage.get();
        if (contextStorage instanceof com.contrastsecurity.agent.opentelemetry.context.a) {
            ((com.contrastsecurity.agent.opentelemetry.context.a)contextStorage).a();
        }
    }

    private void createCachedAuthorizationSpan(ContrastContext contrastContext, a a2) {
        String string;
        if (a2 == null) {
            return;
        }
        Span span = this.startChildSpan(contrastContext, a2.c(), a2.b());
        if (span == null) {
            return;
        }
        Collection<String> collection = a2.g();
        if (collection != null && !collection.isEmpty() && !(string = RootSpan.getRbacRoles(collection)).isEmpty()) {
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, string);
        }
        span.end();
        this.popContext();
        a2.d().otel().d().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, a2.c(), ContrastSemanticAttributes.HTTP_ROUTE, this.getHttpRoute(), ContrastSemanticAttributes.HTTP_REQUEST_METHOD, this.getHttpMethod()), span.storeInContext(Context.current()));
    }

    private static String getRbacRoles(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            if (!string.startsWith("ROLE")) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public Span startChildSpan(ContrastContext contrastContext, String string2, String string3) {
        if (!this.isRecording() || this.sensorDeduplicationMax < this.triggeredSensors.get().compute(string3, (string, n2) -> n2 == null ? 1 : n2 + 1) || this.deadzoneManager.c(contrastContext)) {
            return null;
        }
        Span span = this.tracer.spanBuilder(string2).setSpanKind(SpanKind.SERVER).setParent(Context.current()).startSpan();
        span.makeCurrent();
        return span;
    }

    public Span startChildFromRoot(ContrastContext contrastContext, String string2, String string3) {
        if (!this.isRecording() || this.sensorDeduplicationMax < this.triggeredSensors.get().compute(string3, (string, n2) -> n2 == null ? 1 : n2 + 1) || this.deadzoneManager.c(contrastContext)) {
            return null;
        }
        Span span = this.tracer.spanBuilder(string2).setSpanKind(SpanKind.SERVER).setParent(this.storeInContext(Context.root())).startSpan();
        span.makeCurrent();
        return span;
    }

    public String getHttpRoute() {
        return this.isRecording() ? this.delegate.getAttribute(ContrastSemanticAttributes.HTTP_ROUTE) : null;
    }

    public String getHttpMethod() {
        return this.isRecording() ? this.delegate.getAttribute(ContrastSemanticAttributes.HTTP_REQUEST_METHOD) : null;
    }

    long getStartTimeMs() {
        return this.startTimeMs;
    }

    public boolean isRecording() {
        return this.delegate != null;
    }

    public void end() {
        if (this.delegate == null) {
            this.popContext();
            return;
        }
        this.delegate.end();
        this.popContext();
        SpanProcessor spanProcessor = this.otelGlobalConfig.spanProcessor();
        if (spanProcessor instanceof j) {
            ((j)spanProcessor).a(this.delegate);
        }
    }

    public void attachProtectEvent() {
        this.delegate.setAttribute(SemanticAttributes.PROTECT_EVENT, Boolean.valueOf(true));
    }

    public SpanContext getRootSpanContext() {
        return this.delegate == null ? null : this.delegate.getSpanContext();
    }

    public Context storeInContext(Context context) {
        return this.delegate == null ? context : this.delegate.storeInContext(context);
    }
}

