/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.cryto;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@DontObfuscate
@m
public class CryptoUsageDispatcherImpl
implements ContrastObserveCryptoDispatcher {
    private final Config config;
    private final i stackCaptureFactory;

    public CryptoUsageDispatcherImpl(Config config, i i2) {
        this.config = config;
        this.stackCaptureFactory = i2;
    }

    public void onAlgorithmUsed(Object object, String string) {
        if (StringUtils.isEmpty(string)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE) || !this.config.getBoolean(ConfigProperty.OBSERVE_CRYPTO_USAGE_ENABLE)) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        application.otel().c().logRecordBuilder().setTimestamp(Instant.now()).setAttribute(AttributeKey.stringKey("event.name"), "crypto-usage").setAttribute(AttributeKey.stringKey("crypto.algorithm"), String.join((CharSequence)" ", string)).setAttribute(AttributeKey.stringArrayKey("code.stacktrace"), this.generateStackTrace()).setAttribute(AttributeKey.stringKey("event.id"), UUID.randomUUID().toString()).emit();
    }

    private List<String> generateStackTrace() {
        List<StackTraceElement> list = this.stackCaptureFactory.a(i.a.e).traceWithoutLeadingContrastCode();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (StackTraceElement stackTraceElement : list) {
            arrayList.add(stackTraceElement.toString());
        }
        return arrayList;
    }
}

