/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.serverside;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.f.i;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

@DontObfuscate
@m
public final class ServerSideRequestDispatcherImpl
implements ContrastObserveServerSideRequestDispatcher {
    private final Config config;
    private final i sensitiveDataMaskingManager;
    private static final Set<String> EXCLUDED_PROTOCOLS = Sets.of("file", "jar", "jrt", "war", "ear");

    ServerSideRequestDispatcherImpl(Config config, i i2) {
        this.config = config;
        this.sensitiveDataMaskingManager = i2;
    }

    public Object onTraceStart(Object object, String string, Object object2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        if (!(object2 instanceof URLConnection)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            return null;
        }
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null) {
            return null;
        }
        URL uRL = ((URLConnection)object2).getURL();
        String string2 = uRL.getHost();
        int n2 = uRL.getPort();
        String string3 = uRL.getProtocol();
        if (string3 != null && EXCLUDED_PROTOCOLS.contains(string3.toLowerCase())) {
            return null;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "outbound-service-call", string);
        if (span == null || string2 == null) {
            return span;
        }
        span.setAttribute(ContrastSemanticAttributes.SERVER_ADDRESS, string2);
        if (n2 >= 0) {
            span.setAttribute(ContrastSemanticAttributes.SERVER_PORT, n2);
        }
        span.setAttribute(ContrastSemanticAttributes.URL_FULL, this.sensitiveDataMaskingManager.a().a(uRL.toString()).a());
        return span;
    }

    public void onActionEnd(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        d.a(this.config, object2, contrastContext.observe(), contrastContext.application().current(), "outbound-service-call");
    }
}

