/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.commons.f;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.k.g;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.protect.C;
import com.contrastsecurity.agent.plugins.protect.L;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.b.b;
import com.contrastsecurity.agent.plugins.protect.b.c;
import com.contrastsecurity.agent.plugins.protect.rules.h;
import com.contrastsecurity.agent.plugins.protect.v;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@DontObfuscate
public class ProtectContext
implements com.contrastsecurity.agent.commons.b<ProtectContext> {
    private final c canonicalizer;
    private final Memoizer<ConcurrentHashMap<String, Object>> map;
    private final Memoizer<ConcurrentHashMap<ProtectRuleId, List<L>>> inputs;
    private final Memoizer<ConcurrentHashMap<String, b>> canonicalizationResultsMap;
    private final Clock clock;
    private final boolean telemetryEnabled;
    private final d.b<C, i> requestTimeMetrics;
    private final com.contrastsecurity.agent.telemetry.metrics.b.b timingAnomalyEventFactory;
    private final Memoizer<Set<ProtectRuleId>> disabledRules;
    private final AtomicBoolean allowlisted;
    private final AtomicBoolean throwExceptionOnParameterAccess;
    private final AtomicBoolean allRulesDisabled;
    private static final Logger logger = LoggerFactory.getLogger(ProtectContext.class);
    private static final c DEFAULT_CANONICALIZER = new c(TelemetryMetrics.NO_OP, (Clock)new SystemClock());
    private static final long ONE_MINUTE_IN_NS = TimeUnit.MINUTES.toNanos(1L);

    public ProtectContext() {
        this(DEFAULT_CANONICALIZER, new SystemClock(), TelemetryMetrics.NO_OP, ProtectManager.buildRequestTimeMetrics(TelemetryMetrics.NO_OP), com.contrastsecurity.agent.telemetry.metrics.b.b.a);
    }

    public ProtectContext(ProtectContext protectContext) {
        this.canonicalizer = protectContext.canonicalizer;
        this.clock = protectContext.clock;
        this.telemetryEnabled = protectContext.telemetryEnabled;
        this.requestTimeMetrics = protectContext.requestTimeMetrics;
        this.timingAnomalyEventFactory = protectContext.timingAnomalyEventFactory;
        this.inputs = protectContext.inputs;
        this.canonicalizationResultsMap = protectContext.canonicalizationResultsMap;
        this.map = protectContext.map;
        this.disabledRules = protectContext.disabledRules;
        this.allowlisted = protectContext.allowlisted;
        this.throwExceptionOnParameterAccess = protectContext.throwExceptionOnParameterAccess;
        this.allRulesDisabled = protectContext.allRulesDisabled;
    }

    public ProtectContext(c c2, Clock clock, TelemetryMetrics telemetryMetrics, d.b<C, i> b2, com.contrastsecurity.agent.telemetry.metrics.b.b b3) {
        this.canonicalizer = c2;
        this.clock = clock;
        this.requestTimeMetrics = b2;
        this.telemetryEnabled = telemetryMetrics.isEnabled();
        this.timingAnomalyEventFactory = b3;
        this.inputs = Suppliers.memoize(ConcurrentHashMap::new);
        this.canonicalizationResultsMap = Suppliers.memoize(ConcurrentHashMap::new);
        this.map = Suppliers.memoize(ConcurrentHashMap::new);
        this.disabledRules = Suppliers.memoize(() -> Collections.newSetFromMap(new ConcurrentHashMap()));
        this.allowlisted = new AtomicBoolean();
        this.throwExceptionOnParameterAccess = new AtomicBoolean();
        this.allRulesDisabled = new AtomicBoolean();
    }

    public void recordRequestTimes(ContrastContext contrastContext) {
        if (!this.telemetryEnabled) {
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        this.requestTimeMetrics.get(C.d).a(this.clock.nanoTime() - httpRequest.startTimeNs(), TimeUnit.NANOSECONDS);
        g g2 = httpRequest.getJfrEvent();
        long l2 = 0L;
        for (v v2 : contrastContext.threadLocals().c().a()) {
            long l3 = v2.b().getAndSet(0L);
            C c2 = v2.c();
            g2.a(c2, l2);
            if (l3 < 0L) {
                l2 = -1L;
                continue;
            }
            this.requestTimeMetrics.get(c2).a(l3, TimeUnit.NANOSECONDS);
            if (l2 < 0L) continue;
            l2 += l3;
        }
        if (l2 >= 0L) {
            this.requestTimeMetrics.get(C.c).a(l2, TimeUnit.NANOSECONDS);
            if (l2 > ONE_MINUTE_IN_NS) {
                this.timingAnomalyEventFactory.a(contrastContext).a();
            }
        }
        g2.a(C.c, l2);
    }

    public void markRuleDisabled(ProtectRuleId protectRuleId) {
        this.disabledRules.get().add(protectRuleId);
    }

    public void markAllRulesDisabled() {
        this.allRulesDisabled.getAndSet(true);
    }

    @o
    boolean areAllRulesDisabled() {
        return this.allRulesDisabled.get();
    }

    public boolean isRuleDisabled(ProtectRuleId protectRuleId) {
        return this.allowlisted.get() || this.allRulesDisabled.get() || this.disabledRules != null && this.disabledRules.get().contains((Object)protectRuleId);
    }

    public boolean isRuleEnabled(ProtectRuleId protectRuleId) {
        return !this.isRuleDisabled(protectRuleId);
    }

    public Collection<L> getInputs(ProtectRuleId protectRuleId) {
        List<L> list = this.inputs.get().get((Object)protectRuleId);
        return list != null ? list : Collections.emptyList();
    }

    public L getFirstInput(ProtectRuleId protectRuleId) {
        List<L> list = this.inputs.get().get((Object)protectRuleId);
        return list == null || list.isEmpty() ? null : list.iterator().next();
    }

    public void clear() {
        this.canonicalizationResultsMap.ifPresent(Map::clear);
        this.inputs.ifPresent(Map::clear);
        this.map.ifPresent(Map::clear);
        this.disabledRules.ifPresent(Set::clear);
        this.allowlisted.getAndSet(false);
        this.allRulesDisabled.getAndSet(false);
        this.throwExceptionOnParameterAccess.getAndSet(false);
    }

    public void put(String string, Object object) {
        this.map.get().put(string, object);
    }

    public Object get(String string) {
        return this.map.get().get(string);
    }

    public Object remove(String string) {
        return this.map.get().remove(string);
    }

    public void markAllowlisted() {
        this.allowlisted.getAndSet(true);
    }

    public boolean isAllowlisted() {
        return this.allowlisted.get();
    }

    public void saveInput(ContrastContext contrastContext, Config config, h h2, L l2) {
        Objects.requireNonNull(l2);
        if (logger.isDebugEnabled()) {
            logger.debug("Saving tracked input {} to context {} with input {} for {}", l2.a().getValue(), JVMUtils.getSafeToString(this, true), JVMUtils.getSafeToString(l2.a(), true), h2.getRuleId().id());
        }
        Application application = contrastContext.application().current();
        boolean bl2 = !this.appliesToApplicationCheckEnabled(config) || h2.appliesToApplication(application);
        l2.a(bl2);
        this.inputs.get().computeIfAbsent(h2.getRuleId(), protectRuleId -> new f()).add(l2);
    }

    public b canonicalize(String string) {
        b b2 = this.canonicalizationResultsMap.get().get(string);
        if (b2 == null) {
            b2 = this.canonicalizer.a(string);
            this.canonicalizationResultsMap.get().put(string, b2);
        }
        return b2;
    }

    @o
    b getCachedCanonicalizationResults(String string) {
        return this.canonicalizationResultsMap.get().get(string);
    }

    public void throwExceptionOnParameterAccess(boolean bl2) {
        this.throwExceptionOnParameterAccess.getAndSet(bl2);
    }

    boolean shouldThrowExceptionOnParameterAccess() {
        return this.throwExceptionOnParameterAccess.get();
    }

    private boolean appliesToApplicationCheckEnabled(Config config) {
        return config.getBoolean(ConfigProperty.PROTECT_APPCHECK_ENABLED);
    }

    @Override
    public ProtectContext copy() {
        return new ProtectContext(this);
    }
}

