/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.G;
import com.contrastsecurity.agent.plugins.protect.d.c;
import com.contrastsecurity.agent.plugins.protect.d.d;
import com.contrastsecurity.agent.plugins.protect.d.l;
import com.contrastsecurity.agent.plugins.protect.e.b;
import com.contrastsecurity.agent.plugins.protect.g;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.nio.charset.Charset;

@DontObfuscate
final class ProtectRequestBodyListener
implements k {
    private final G requestScanner;
    private final d deserializationContextService;
    private final TelemetryMetrics telemetryMetrics;
    private final boolean shouldCaptureNonDocumentRequestBodies;
    private static final Logger logger = LoggerFactory.getLogger(ProtectRequestBodyListener.class);

    ProtectRequestBodyListener(G g2, d d2, TelemetryMetrics telemetryMetrics, boolean bl2) {
        this.requestScanner = g2;
        this.deserializationContextService = d2;
        this.telemetryMetrics = telemetryMetrics;
        this.shouldCaptureNonDocumentRequestBodies = bl2;
    }

    @Override
    public void onBodyChunkRead(ContrastContext contrastContext) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        c c2 = contrastContext.http().deserializationContext();
        if (!httpRequest.isCheckedForDeserializer()) {
            this.deserializationContextService.a(c2);
            httpRequest.setCheckedForDeserializer(true);
        }
        if (this.shouldCaptureNonDocumentRequestBodies && b.a(httpRequest)) {
            Charset charset = httpRequest.getCharset();
            if (b.a(httpRequest.getBufferAsStream(), charset)) {
                httpRequest.setCheckedForDocumentBodyContent(true);
                httpRequest.context().put(G.a, UserInputDTM.InputDocumentType.JSON);
            } else if (b.b(httpRequest.getBufferAsStream(), charset)) {
                httpRequest.setCheckedForDocumentBodyContent(true);
                httpRequest.context().put(G.a, UserInputDTM.InputDocumentType.XML);
            } else {
                httpRequest.disableCapturing();
                httpRequest.closeBuffer();
                return;
            }
        }
        if (c2 == null && httpRequest.getBufferSize() == httpRequest.getContentLength() && !G.a(httpRequest)) {
            this.doBodyScan(contrastContext, httpRequest);
        }
    }

    @Override
    public void onBodyReadEnd(ContrastContext contrastContext) {
        HttpContext httpContext = contrastContext.http();
        if (httpContext.deserializationContext() == null) {
            this.doBodyScan(contrastContext, httpContext.getRequest());
        }
    }

    private void doBodyScan(ContrastContext contrastContext, HttpRequest httpRequest) {
        if (httpRequest.bodyScanned()) {
            return;
        }
        if (httpRequest.isBufferEmpty()) {
            logger.debug("No request body found, nothing to read");
            return;
        }
        try {
            g g2 = contrastContext.threadLocals().c().a(this.telemetryMetrics.isEnabled());
            try {
                if (this.requestScanner.a(contrastContext) != l.a.c) {
                    httpRequest.bodyScanned(true);
                }
                if (g2 != null) {
                    g2.close();
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (g2 != null) {
                    try {
                        g2.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                }
                throw throwable2;
            }
        }
        catch (AttackBlockedException attackBlockedException) {
            httpRequest.bodyScanned(true);
            throw attackBlockedException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable5 = throwable;
            logger.error("Problem reading body", throwable5);
        }
    }
}

