/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.b;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.i;
import com.contrastsecurity.agent.commons.NVP;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.plugins.protect.CookieScanner;
import com.contrastsecurity.agent.plugins.protect.F;
import com.contrastsecurity.agent.plugins.protect.HeaderScanner;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.QueryStringUriScanner;
import com.contrastsecurity.agent.plugins.protect.k.a;
import com.contrastsecurity.agent.plugins.protect.rules.f;
import com.contrastsecurity.agent.plugins.protect.rules.h;
import com.contrastsecurity.agent.plugins.protect.rules.m;
import com.contrastsecurity.agent.plugins.protect.y;
import com.contrastsecurity.agent.s.c;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@DontObfuscate
final class ProtectRequestStartHandler {
    private final ContrastContext contrastContext;
    private final List<h> inputAwareRules;
    private final i exclusionProcessor;
    private final b exclusionCache;
    private final HttpRequest request;
    private final boolean metricsEnabled;
    private final ProtectManager manager;
    private final c serverExclusionProcessor;
    private final CookieScanner cookieAnalyzer;
    private final HeaderScanner headerAnalyzer;
    private final QueryStringUriScanner queryStringAnalyzer;
    private boolean queryAndURICached;
    private boolean hasQueryStringExceptions;
    private String queryString;
    private Supplier<String> queryStringSupplier;
    private Supplier<String> uriSupplier;
    private static final Logger logger = LoggerFactory.getLogger(ProtectRequestStartHandler.class);

    ProtectRequestStartHandler(ContrastContext contrastContext, ProtectManager protectManager, c c2, boolean bl2, y y2) {
        this.contrastContext = contrastContext;
        this.manager = protectManager;
        this.serverExclusionProcessor = c2;
        this.inputAwareRules = protectManager.getEnabledInputRulesCalculated(contrastContext);
        Application application = contrastContext.application().current();
        this.exclusionProcessor = application.getExclusionProcessor();
        this.request = contrastContext.http().getRequest();
        this.exclusionCache = com.contrastsecurity.agent.apps.exclusions.c.a(application, this.request);
        this.metricsEnabled = bl2;
        this.cookieAnalyzer = y2.a;
        this.headerAnalyzer = y2.b;
        this.queryStringAnalyzer = y2.c;
    }

    void doRequestStart() {
        if (!this.metricsEnabled) {
            this.contrastContext.protect().markRuleDisabled(ProtectRuleId.METRIC_GATHERING);
        }
        for (m m2 : this.manager.getEnabledRules(this.contrastContext)) {
            this.onStartForRule(m2);
        }
        this.onInputAwareRules();
    }

    private void onStartForRule(m m2) {
        String string = m2.getRuleId().id();
        ProtectContext protectContext = this.contrastContext.protect();
        if (this.exclusionCache.a(d.a.b, string)) {
            logger.debug("Not inspecting {} rule for {} due to exclusion", (Object)string, (Object)this.request.getUri());
            protectContext.markRuleDisabled(m2.getRuleId());
            return;
        }
        if (m2 instanceof h) {
            this.cacheForQueryAndURI();
            h h2 = (h)m2;
            this.onQueryString(h2);
            this.onURI(h2);
        }
        if (m2 instanceof f) {
            ((f)m2).a(this.contrastContext);
        }
    }

    private void onInputAwareRules() {
        if (this.inputAwareRules.isEmpty()) {
            return;
        }
        this.onCookies();
        this.onHeaders();
    }

    private void onCookies() {
        NVP[] nVPArray = this.getCookies(this.request);
        boolean bl2 = this.exclusionProcessor.hasCookieExclusions(d.a.b);
        for (NVP nVP : nVPArray) {
            this.onCookie(bl2, nVP);
        }
    }

    private NVP[] getCookies(HttpRequest httpRequest) {
        String string = httpRequest.getCookie();
        if (string == null || string.isEmpty()) {
            return d.a;
        }
        return d.a(string);
    }

    private void onCookie(boolean bl2, NVP nVP) {
        if (this.serverExclusionProcessor.a(nVP.getName())) {
            return;
        }
        Supplier<String> supplier = a.b(nVP.getName(), UserInputDTM.InputType.COOKIE_NAME);
        Supplier<String> supplier2 = a.b(nVP.getValue(), UserInputDTM.InputType.COOKIE_VALUE);
        String string = nVP.getName();
        String string2 = this.request.getUri();
        for (h h2 : this.inputAwareRules) {
            String string3 = h2.getRuleId().id();
            if (this.isCookieExcluded(bl2, h2, string)) {
                logger.debug("Ignoring cookie names and values for {} on {} due to exception", (Object)string3, (Object)string2);
                continue;
            }
            if (this.isRuleRequiredForInput(h2, UserInputDTM.InputType.COOKIE_NAME, string)) {
                this.cookieAnalyzer.scanCookie(this.contrastContext, h2, supplier.get(), supplier2.get(), UserInputDTM.InputType.COOKIE_NAME);
            }
            if (!this.isRuleRequiredForInput(h2, UserInputDTM.InputType.COOKIE_VALUE, nVP.getValue())) continue;
            this.cookieAnalyzer.scanCookie(this.contrastContext, h2, supplier.get(), supplier2.get(), UserInputDTM.InputType.COOKIE_VALUE);
        }
    }

    private void onHeaders() {
        Map<String, String[]> map = this.request.getHeaders();
        if (map == null) {
            return;
        }
        boolean bl2 = this.exclusionProcessor.hasHeaderExclusions(d.a.b);
        for (String string : map.keySet()) {
            this.onHeader(string, map.get(string), bl2);
        }
    }

    private void onHeader(String string, String[] stringArray, boolean bl2) {
        if ("Cookie".equalsIgnoreCase(string) || this.serverExclusionProcessor.b(string)) {
            return;
        }
        for (String string2 : stringArray) {
            if (F.a(string, string2)) continue;
            this.onHeaderValue(string, string2, bl2);
        }
    }

    private void onHeaderValue(String string, String string2, boolean bl2) {
        Supplier<String> supplier = a.b(string2, UserInputDTM.InputType.HEADER);
        for (h h2 : this.inputAwareRules) {
            if (!this.isRuleRequiredForInput(h2, UserInputDTM.InputType.HEADER, string2) || bl2 && this.exclusionCache.a(d.a.b, h2.getRuleId().id(), ExceptionInputTypeDTM.HEADER, string)) continue;
            this.headerAnalyzer.scanHeader(this.contrastContext, h2, string, supplier.get());
        }
    }

    private boolean isCookieExcluded(boolean bl2, h h2, String string) {
        return bl2 && this.exclusionCache.a(d.a.b, h2.getRuleId().id(), ExceptionInputTypeDTM.COOKIE, string);
    }

    private boolean isRuleRequiredForInput(h h2, UserInputDTM.InputType inputType, String string) {
        return h2.appliesToInputType(inputType) && StringUtils.isNotEmpty(string) && this.contrastContext.protect().isRuleEnabled(h2.getRuleId());
    }

    private void cacheForQueryAndURI() {
        if (this.queryAndURICached) {
            return;
        }
        this.hasQueryStringExceptions = this.exclusionProcessor.hasQuerystringExclusions(d.a.b);
        this.queryString = this.request.getQueryString();
        this.queryStringSupplier = Suppliers.memoize(() -> this.queryString == null ? null : a.a(this.queryString.trim(), UserInputDTM.InputType.QUERYSTRING));
        this.uriSupplier = Suppliers.memoize(() -> this.request.getUri() == null ? null : a.a(this.request.getUri().trim(), UserInputDTM.InputType.URI));
        this.queryAndURICached = true;
    }

    private void onQueryString(h h2) {
        String string = h2.getRuleId().id();
        if (!this.allowedToScanQuerystring(h2, this.queryString)) {
            return;
        }
        String string2 = this.request.getUri();
        if (this.hasQueryStringExceptions && this.exclusionCache.a(d.a.b, string, ExceptionInputTypeDTM.QUERYSTRING)) {
            logger.debug("Ignoring querystring for {} on {} due to exception", (Object)string, (Object)string2);
            return;
        }
        this.queryStringAnalyzer.scanQueryString(this.contrastContext, h2, this.queryStringSupplier.get());
    }

    private boolean allowedToScanQuerystring(h h2, String string) {
        return !StringUtils.isEmpty(string) && h2.appliesToInputType(UserInputDTM.InputType.QUERYSTRING) && !this.manager.isScanParameterAsAnything();
    }

    private void onURI(h h2) {
        if (h2.appliesToInputType(UserInputDTM.InputType.URI)) {
            this.queryStringAnalyzer.scanUriValue(this.contrastContext, h2, this.uriSupplier.get());
        }
    }
}

