/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.b;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.i;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.controller.e;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.p;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements com.contrastsecurity.agent.plugins.security.controller.trigger.o {
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    @Override
    public boolean onTraceTriggered(ContrastContext contrastContext, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, e e2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl2 = true;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Skipping exclusion processing: app is null");
            return false;
        }
        if (application.getExclusionProcessor() == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        for (int i2 = 0; i2 < list.size() && bl2; ++i2) {
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl2 = !this.isSourceExclusion(trace, rule, (SourceEvent)codeEvent, httpRequest, application);
        }
        return bl2;
    }

    @o
    boolean isSourceExclusion(Trace trace, Rule rule, SourceEvent sourceEvent, HttpRequest httpRequest, Application application) {
        i i2 = application.getExclusionProcessor();
        String string = rule.getId();
        SourceNode sourceNode = sourceEvent.getSource();
        if (!sourceNode.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)sourceNode.getId());
            return false;
        }
        if (sourceEvent.getQueue() != null && (sourceNode.isSourceType(p.u) || sourceNode.isSourceType(p.v) || sourceNode.isSourceType(p.w) || sourceNode.isSourceType(p.x))) {
            return i2.isQueueExclusion(d.a.a, string, sourceEvent.getQueue());
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        b b2 = c.a(application, httpRequest);
        if (sourceNode.isSourceType(p.g)) {
            String string2 = this.extractInputName(trace, sourceEvent, sourceNode);
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.PARAMETER, string2);
        }
        if (sourceNode.isSourceType(p.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, sourceNode);
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.HEADER, string3);
        }
        if (sourceNode.isSourceType(p.h)) {
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.QUERYSTRING);
        }
        if (sourceNode.isSourceType(p.c)) {
            String string4 = sourceEvent.getFieldName();
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.COOKIE, string4);
        }
        if (sourceNode.isSourceType(p.a) || sourceNode.isSourceType(p.f)) {
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.BODY);
        }
        if (sourceNode.isSourceType(p.t)) {
            return b2.a(d.a.a, string, ExceptionInputTypeDTM.HEADER, "authorization");
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, SourceNode sourceNode) {
        String string = sourceEvent.getFieldName();
        if (string != null) {
            return string;
        }
        if (sourceNode.isSourceType(p.q)) {
            if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                string = sourceEvent.getParameters()[0].string();
            }
        } else if (sourceNode.isSourceType(p.p)) {
            String string2;
            if (trace == null || trace.getEvents() == null || trace.getEvents().isEmpty()) {
                return null;
            }
            int n2 = trace.getEvents().indexOf(sourceEvent);
            if (n2 >= 0 && trace.getEvents().size() > n2 && (string2 = trace.getEvents().get(n2 + 1).getRet()) != null && !string2.isEmpty()) {
                string = string2;
            }
        }
        return string;
    }
}

