/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.propagate;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.agent.plugins.security.controller.propagate.c;
import com.contrastsecurity.agent.plugins.security.model.g;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.AdaptiveOptimizationManager;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.d;
import com.contrastsecurity.agent.plugins.security.policy.j;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Map;

@DontObfuscate
@m
public final class PropagationHandler
implements j {
    private Map<Integer, Propagator> customSanitizers;
    private final c propagationMachine;
    private final EventContext eventContext;
    private final TraceController traceController;
    private final i stackCaptureFactory;
    private final a methodDescriptionCache;
    private final com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.c propagatorAdaptiveOptimizer;
    private final ContrastPolicyManager policyManager;
    private final Collection<com.contrastsecurity.agent.plugins.security.e.a> propagationListeners;
    private ContrastPolicy.c propagators;
    private static final Logger logger = LoggerFactory.getLogger(PropagationHandler.class);

    public PropagationHandler(c c2, EventContext eventContext, TraceController traceController, i i2, a a2, ContrastPolicyManager contrastPolicyManager, AdaptiveOptimizationManager adaptiveOptimizationManager, Instrumentation instrumentation, TelemetryErrorEmitter telemetryErrorEmitter, Collection<com.contrastsecurity.agent.plugins.security.e.a> collection) {
        this.propagationMachine = c2;
        this.eventContext = eventContext;
        this.traceController = traceController;
        this.stackCaptureFactory = i2;
        this.methodDescriptionCache = a2;
        this.propagatorAdaptiveOptimizer = new d(adaptiveOptimizationManager, instrumentation, telemetryErrorEmitter);
        this.policyManager = contrastPolicyManager;
        this.propagationListeners = collection;
    }

    @Override
    public void onPolicyChanged(ContrastPolicy contrastPolicy) {
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onPropagation(ContrastContext var1_1, String var2_2, String var3_3, int var4_4, Object var5_5, Class<?> var6_6, Object[] var7_7, Object var8_8, Class<?> var9_9, int var10_10, boolean var11_11, boolean var12_12) {
        try {
            var14_13 = var1_1.scope().enterAutoScope(ScopeType.ASSESS);
            try {
                var15_15 = this.getPropagator(var10_10, var11_11);
                var16_16 = var1_1.assessment();
                var17_17 = this.eventContext.getTraceMap((AssessmentContext)var16_16);
                if (var17_17.hasReachedMaximumPropagationEvents()) {
                    var15_15.logExceededMaximumEvents();
                    if (var14_13 == null) return;
                    var14_13.close();
                    return;
                }
            }
            catch (Throwable v0) {
                Throwables.throwIfCritical(v0);
                var15_15 = v0;
                if (var14_13 == null) throw var15_15;
                try {
                    var14_13.close();
                    throw var15_15;
                }
                catch (Throwable v1) {
                    Throwables.throwIfCritical(v1);
                    var16_16 = v1;
                    var15_15.addSuppressed((Throwable)var16_16);
                }
                throw var15_15;
            }
            {
                if (this.shouldPropagate((AssessmentContext)var16_16, (Propagator)var15_15, var6_6, var5_5, var7_7, var9_9, var8_8)) ** GOTO lbl-1000
                if (var14_13 == null) return;
                var14_13.close();
                return;
            }
lbl-1000:
            // 1 sources

            {
                var18_18 = MethodDescription.getMethod(this.methodDescriptionCache, var6_6.getName(), var2_2, var3_3, var4_4);
                var19_19 = new g((AssessmentContext)var16_16);
                var19_19.a(var5_5);
                var19_19.a(var7_7);
                var19_19.b(var8_8);
                var19_19.a(var18_18);
                var19_19.a((Propagator)var15_15);
                var19_19.a(var6_6);
                var19_19.b(var9_9);
                var19_19.a(var12_12);
                var19_19.a(var17_17);
                var19_19.b(System.currentTimeMillis());
                var19_19.a(this.stackCaptureFactory.a(i.a.b));
                for (com.contrastsecurity.agent.plugins.security.e.a var21_21 : this.propagationListeners) {
                    if (var21_21.a(var1_1, var19_19)) continue;
                    if (var14_13 == null) return;
                    var14_13.close();
                    return;
                }
            }
            {
                this.doPropagation(var1_1, var19_19);
                this.propagatorAdaptiveOptimizer.a(this.policyManager, var19_19);
                var17_17.incrementPropagationEventCount();
                var20_20 = this.propagationListeners.iterator();
                while (true) {
                    if (!var20_20.hasNext()) {
                        if (var14_13 == null) return;
                        var14_13.close();
                        return;
                    }
                    var21_21 = var20_20.next();
                    var21_21.b(var1_1, var19_19);
                }
            }
        }
        catch (InvalidTagRangeException var14_14) {
            PropagationHandler.logger.debug("Invalid tag range exception", var14_14);
        }
    }

    private Propagator getPropagator(int n2, boolean bl2) {
        Propagator propagator;
        if (bl2 && logger.isDebugEnabled()) {
            logger.debug("custom sanitizer propagator index detected {} ({} total standard propagators)", (Object)n2, (Object)this.propagators.b());
        }
        Propagator propagator2 = propagator = bl2 ? this.customSanitizers.get(n2) : this.propagators.a(n2);
        if (propagator == null) {
            throw new IllegalStateException("Unable to find valid propagator at index " + n2);
        }
        return propagator;
    }

    private boolean shouldPropagate(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Object[] objectArray, Class<?> clazz2, Object object2) {
        return this.verifySourcePropagation(assessmentContext, propagator, clazz, object, objectArray) && this.verifyTargetPropagation(assessmentContext, propagator, clazz, object, clazz2, object2);
    }

    private boolean verifySourcePropagation(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Object[] objectArray) {
        Location[] locationArray = propagator.getSources();
        Location[] locationArray2 = propagator.getTargets();
        boolean bl2 = false;
        if (locationArray != null && locationArray2 != null) {
            if (locationArray.length == 1 && locationArray2.length == 1) {
                Location location = locationArray[0];
                Location location2 = locationArray2[0];
                bl2 = location.isObject() && location2.isObject() ? clazz != String.class && this.traceController.isTracked(assessmentContext, object) : true;
            } else {
                for (int i2 = 0; i2 < locationArray.length && !bl2; ++i2) {
                    Location location = locationArray[i2];
                    if (location.isObject()) {
                        bl2 = this.traceController.isTracked(assessmentContext, object);
                        continue;
                    }
                    if (objectArray == null) continue;
                    if (location.isNumberedParameter()) {
                        int n2 = location.getActualParameterIndex();
                        if (n2 >= objectArray.length) continue;
                        bl2 = this.traceController.isTracked(assessmentContext, objectArray[n2]);
                        continue;
                    }
                    if (!location.isParameter()) continue;
                    String string = location.getDescriptor();
                    for (int i3 = 0; !bl2 && i3 < objectArray.length; ++i3) {
                        if (objectArray[i3] == null || !JVMUtils.isInstanceOf(objectArray[i3], string)) continue;
                        bl2 = this.traceController.isTracked(assessmentContext, objectArray[i3]);
                    }
                }
            }
        }
        return bl2;
    }

    private boolean verifyTargetPropagation(AssessmentContext assessmentContext, Propagator propagator, Class<?> clazz, Object object, Class<?> clazz2, Object object2) {
        Location[] locationArray = propagator.getTargets();
        boolean bl2 = false;
        Object object3 = null;
        Class<?> clazz3 = null;
        if (locationArray != null) {
            for (int i2 = 0; i2 < locationArray.length && !bl2; ++i2) {
                Location location = locationArray[i2];
                if (location.isObject()) {
                    object3 = object;
                    clazz3 = clazz;
                } else if (location.isReturn()) {
                    object3 = object2;
                    clazz3 = clazz2;
                } else {
                    bl2 = true;
                }
                if (bl2) continue;
                bl2 = object3 != null;
                bl2 = bl2 && (clazz3 != String.class || !this.traceController.isTracked(assessmentContext, object3));
            }
        }
        return bl2;
    }

    private void doPropagation(ContrastContext contrastContext, g g2) throws InvalidTagRangeException {
        Propagator propagator = g2.f();
        boolean bl2 = g2.j();
        TraceMap traceMap = g2.l();
        Location[] locationArray = propagator.getSources();
        Location[] locationArray2 = propagator.getTargets();
        if (locationArray != null && locationArray2 != null) {
            boolean bl3;
            Location location;
            int n2;
            int n3 = -1;
            AssessmentContext assessmentContext = contrastContext.assessment();
            for (n2 = 0; n2 < locationArray.length; ++n2) {
                location = locationArray[n2];
                if (location.isObject() && this.traceController.isTracked(assessmentContext, g2.c())) {
                    n3 = n2;
                    continue;
                }
                if (!location.isParameter() || (bl3 = location.getActualParameterIndex()) || !this.traceController.isTracked(assessmentContext, g2.d()[bl3])) continue;
                n3 = n2;
            }
            for (n2 = 0; n2 < locationArray.length; ++n2) {
                location = locationArray[n2];
                bl3 = n2 == locationArray.length - 1;
                bl3 = bl3 || n2 == n3;
                bl3 = bl3 || location.isParameter() && propagator.getCountOfArgSources() > 1;
                Object object = this.getObjectFromContextAtLocation(g2, location);
                for (Location location2 : locationArray2) {
                    Object object2 = this.getObjectFromContextAtLocation(g2, location2);
                    if (object == null || object2 == null) continue;
                    if (location.isObject() && location2.isObject()) {
                        this.propagationMachine.a(assessmentContext, object, g2);
                        continue;
                    }
                    this.propagationMachine.a(contrastContext, object, object2, g2, bl2, traceMap, bl3);
                }
            }
        }
    }

    private Object getObjectFromContextAtLocation(g g2, Location location) {
        Object object = g2.c();
        Object object2 = g2.e();
        Object[] objectArray = g2.d();
        Object object3 = null;
        if (location.isObject()) {
            object3 = object;
        } else if (location.isNumberedParameter()) {
            int n2 = location.getActualParameterIndex();
            object3 = n2 < objectArray.length ? objectArray[n2] : null;
        } else if (location.isTypedParameter()) {
            for (int i2 = 0; object3 == null && i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || !JVMUtils.isInstanceOf(objectArray[i2], location.getParameterType())) continue;
                object3 = objectArray[i2];
            }
        } else if (location.isReturn()) {
            object3 = object2;
        }
        return object3;
    }
}

