/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.instr.InstrumentationContext;
import com.contrastsecurity.agent.j;
import com.contrastsecurity.agent.messages.server.features.assessment.CustomRuleAPI;
import com.contrastsecurity.agent.messages.server.features.assessment.InputValidatorDTM;
import com.contrastsecurity.agent.messages.server.features.assessment.SanitizerDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.PolicyNode;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.TagList;
import com.contrastsecurity.agent.plugins.security.policy.Tagger;
import com.contrastsecurity.agent.plugins.security.policy.ValidatorScope;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.e;
import com.contrastsecurity.agent.plugins.security.policy.g;
import com.contrastsecurity.agent.plugins.security.policy.h;
import com.contrastsecurity.agent.plugins.security.policy.i;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.plugins.security.policy.q;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.EventPattern;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.sources.AbstractClassMatcher;
import com.contrastsecurity.agent.plugins.security.policy.sources.DynamicSource;
import com.contrastsecurity.agent.util.E;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;

@DontObfuscate
public final class ContrastPolicy {
    private final int id;
    private final String location;
    private final Map<String, SourceNode> sources;
    private final Map<String, List<SourceNode>> sourceClassAnnotationMap;
    private final Map<String, List<SourceNode>> sourceClassNameMap;
    private final Map<String, List<SourceNode>> parameterAnnotationSources;
    private final Map<String, TagList> customRulesTagLists;
    private final List<Tagger> allCustomSanitizers;
    private final List<Tagger> allCustomValidators;
    private final Map<Integer, Propagator> indexedSanitizersMap;
    private final Map<String, Propagator> customSanitizers;
    private final Map<String, Propagator> propagators;
    private final Map<String, List<Propagator>> propagatorClassAnnotationMap;
    private final Map<String, List<Propagator>> propagatorClassNameMap;
    private final c fastPropagatorLookup;
    private final Map<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> frameworkAnnotations;
    private final Map<String, Set<String>> parameterAnnotations;
    private final Map<String, TagList> tagLists;
    private final Map<String, Set<PolicyNode>> globalChanges;
    private final Set<String> globalClasses;
    private final Map<String, Rule> rules;
    private final q tagListIndices;
    private final Map<String, DynamicSource> dynamicSources;
    private final Map<String, Set<String>> acceptedRegex;
    private final Map<String, Set<String>> rejectedRegex;
    private static final Logger logger = LoggerFactory.getLogger(ContrastPolicy.class);

    private ContrastPolicy(Builder builder) {
        this.id = builder.id;
        this.location = builder.location;
        b b2 = b.a("untrusted source", builder.sources);
        this.sources = b2.a;
        this.sourceClassAnnotationMap = b2.b;
        this.sourceClassNameMap = b2.c;
        this.parameterAnnotationSources = Maps.deepCopyList(builder.parameterAnnotationSources);
        this.customRulesTagLists = Maps.copy(builder.customRulesCollection.i);
        this.allCustomSanitizers = Lists.copy(builder.customRulesCollection.d);
        this.allCustomValidators = Lists.copy(builder.customRulesCollection.e);
        this.indexedSanitizersMap = Maps.copy(builder.customRulesCollection.g);
        this.customSanitizers = Maps.copy(builder.customRulesCollection.c);
        ArrayList<TagList> arrayList = new ArrayList<TagList>(builder.tagLists.values());
        arrayList.addAll(builder.customRulesCollection.i.values());
        this.tagListIndices = q.a(arrayList);
        b b3 = b.a("propagator", builder.propagators);
        this.propagators = b3.a;
        this.propagatorClassAnnotationMap = b3.b;
        this.propagatorClassNameMap = b3.c;
        this.fastPropagatorLookup = c.a(builder.propagators);
        this.frameworkAnnotations = Maps.deepCopyList(builder.frameworkAnnotations);
        this.parameterAnnotations = Maps.deepCopySet(builder.parameterAnnotations);
        this.tagLists = Maps.newTreeMap(builder.tagLists);
        this.globalChanges = Maps.deepCopySet(builder.globalChanges);
        this.rules = Maps.copy(builder.rules);
        HashSet<String> hashSet = new HashSet<String>(builder.globalClasses);
        hashSet.addAll(b2.d);
        hashSet.addAll(b3.d);
        hashSet.addAll(builder.customRulesCollection.f);
        this.globalClasses = Collections.unmodifiableSet(hashSet);
        this.dynamicSources = Maps.copy(builder.dynamicSources);
        this.acceptedRegex = Maps.deepCopySet(builder.acceptedRegex);
        this.rejectedRegex = Maps.deepCopySet(builder.rejectedRegex);
    }

    public ContrastPolicy(ContrastPolicy contrastPolicy, SourceNode sourceNode) {
        ArrayList<SourceNode> arrayList = new ArrayList<SourceNode>(contrastPolicy.sources.values());
        arrayList.add(sourceNode);
        b<SourceNode> b2 = b.a("source", arrayList);
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        if (sourceNode.isSignatureBased()) {
            hashSet.addAll(ContrastPolicy.getGlobalNameFromSignature(sourceNode));
        }
        this.globalClasses = Collections.unmodifiableSet(hashSet);
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNode(contrastPolicy.globalChanges, sourceNode);
        this.sources = b2.a;
        this.sourceClassAnnotationMap = b2.b;
        this.sourceClassNameMap = b2.c;
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.customRulesTagLists = contrastPolicy.customRulesTagLists;
        this.allCustomSanitizers = contrastPolicy.allCustomSanitizers;
        this.allCustomValidators = contrastPolicy.allCustomValidators;
        this.indexedSanitizersMap = contrastPolicy.indexedSanitizersMap;
        this.customSanitizers = contrastPolicy.customSanitizers;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.tagListIndices = contrastPolicy.tagListIndices;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
    }

    public ContrastPolicy(ContrastPolicy contrastPolicy, a a2) {
        this.customRulesTagLists = a2.i;
        this.customSanitizers = a2.c;
        this.allCustomSanitizers = a2.d;
        this.allCustomValidators = a2.e;
        this.indexedSanitizersMap = a2.g;
        ArrayList<TagList> arrayList = new ArrayList<TagList>(contrastPolicy.getTagLists().values());
        arrayList.addAll(a2.i.values());
        this.tagListIndices = q.a(arrayList);
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        hashSet.addAll(this.getGlobalClassFromTaggers(a2.i));
        this.globalClasses = hashSet;
        ArrayList<Tagger> arrayList2 = new ArrayList<Tagger>();
        for (TagList tagList : a2.i.values()) {
            arrayList2.addAll(tagList.getTaggers());
        }
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNodes(contrastPolicy.globalChanges, arrayList2);
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
        this.sources = contrastPolicy.sources;
        this.sourceClassAnnotationMap = contrastPolicy.sourceClassAnnotationMap;
        this.sourceClassNameMap = contrastPolicy.sourceClassNameMap;
    }

    private ContrastPolicy(ContrastPolicy contrastPolicy, Collection<e> collection) {
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        for (e e2 : collection) {
            hashSet.addAll(ContrastPolicy.getGlobalNameFromSignature(e2));
        }
        this.globalClasses = hashSet;
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNodes(contrastPolicy.globalChanges, collection);
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.customRulesTagLists = contrastPolicy.customRulesTagLists;
        this.allCustomSanitizers = contrastPolicy.allCustomSanitizers;
        this.allCustomValidators = contrastPolicy.allCustomValidators;
        this.indexedSanitizersMap = contrastPolicy.indexedSanitizersMap;
        this.customSanitizers = contrastPolicy.customSanitizers;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.tagListIndices = contrastPolicy.tagListIndices;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
        this.sources = contrastPolicy.sources;
        this.sourceClassAnnotationMap = contrastPolicy.sourceClassAnnotationMap;
        this.sourceClassNameMap = contrastPolicy.sourceClassNameMap;
    }

    static Set<String> getGlobalNameFromSignature(PolicyNode policyNode) throws InvalidParameterException {
        h h2 = policyNode.getMethodMatcher();
        if (h2 instanceof n) {
            m m2 = ((n)h2).a();
            Set<String> set = m2.a();
            HashSet<String> hashSet = new HashSet<String>(set.size());
            for (String string : set) {
                hashSet.add(E.g(string));
            }
            return hashSet;
        }
        throw new InvalidParameterException("Node does not have a signature, so we cannot get the global name from it");
    }

    private static boolean matchesDynamicSources(InstrumentationContext instrumentationContext, Collection<DynamicSource> collection) {
        if (instrumentationContext == null) {
            return false;
        }
        for (DynamicSource dynamicSource : collection) {
            AbstractClassMatcher[] abstractClassMatcherArray;
            for (AbstractClassMatcher abstractClassMatcher : abstractClassMatcherArray = dynamicSource.getMatchers()) {
                if (!abstractClassMatcher.matches(instrumentationContext)) continue;
                return true;
            }
        }
        return false;
    }

    public static Builder builder(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
        return new Builder(n2, string, a2);
    }

    private static <T extends PolicyNode> Map<String, Set<PolicyNode>> newGlobalChangesWithNodes(Map<String, Set<PolicyNode>> map, Collection<T> collection) {
        Map<String, Set<PolicyNode>> map2 = Maps.newHashMap(map);
        for (PolicyNode policyNode : collection) {
            String string = policyNode.getMethodMatcher().toString();
            Set<PolicyNode> set = map2.get(string);
            Set<PolicyNode> set2 = ContrastPolicy.newUnmodifiableSetWithNode(policyNode, set);
            map2.put(string, set2);
        }
        return Collections.unmodifiableMap(map2);
    }

    private static <T extends PolicyNode> Map<String, Set<PolicyNode>> newGlobalChangesWithNode(Map<String, Set<PolicyNode>> map, T t2) {
        return ContrastPolicy.newGlobalChangesWithNodes(map, Collections.singleton(t2));
    }

    private static <T> Set<T> newUnmodifiableSetWithNode(T t2, Set<T> set) {
        if (set == null) {
            return Collections.singleton(t2);
        }
        HashSet<T> hashSet = new HashSet<T>(set);
        hashSet.add(t2);
        return Collections.unmodifiableSet(hashSet);
    }

    public ContrastPolicy withNewSourceNode(SourceNode sourceNode) {
        return new ContrastPolicy(this, sourceNode);
    }

    public ContrastPolicy withNewCustomRulesCollection(a a2) {
        return new ContrastPolicy(this, a2);
    }

    public ContrastPolicy withNewDeadzones(Collection<e> collection) {
        return new ContrastPolicy(this, collection);
    }

    private Set<String> getGlobalClassFromTaggers(Map<String, TagList> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (TagList tagList : map.values()) {
            for (Tagger tagger : tagList.getTaggers()) {
                if (!tagger.isSignatureBased()) continue;
                hashSet.addAll(ContrastPolicy.getGlobalNameFromSignature(tagger));
            }
        }
        return hashSet;
    }

    public int getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, List<SourceNode>> getAnnotatedSources() {
        return this.sourceClassAnnotationMap;
    }

    public Collection<SourceNode> getSources() {
        return this.sources.values();
    }

    @j
    Collection<g> getInternPreventionScopes() {
        return this.globalChanges.values().stream().flatMap(Collection::stream).filter(policyNode -> policyNode instanceof g).map(policyNode -> (g)policyNode).collect(Collectors.toSet());
    }

    @j
    Collection<ValidatorScope> getValidatorScopes() {
        return this.globalChanges.values().stream().flatMap(Collection::stream).filter(policyNode -> policyNode instanceof ValidatorScope).map(policyNode -> (ValidatorScope)policyNode).collect(Collectors.toSet());
    }

    public Map<Integer, Propagator> getIndexedSanitizers() {
        return this.indexedSanitizersMap;
    }

    public Map<String, Propagator> getSanitizers() {
        return this.customSanitizers;
    }

    public c getFastPropagatorLookup() {
        return this.fastPropagatorLookup;
    }

    public Map<String, TagList> getCustomRulesTagLists() {
        return this.customRulesTagLists;
    }

    public Map<String, TagList> getTagLists() {
        return this.tagLists;
    }

    public DynamicSource getDynamicSource(String string) {
        for (DynamicSource dynamicSource : this.dynamicSources.values()) {
            if (!dynamicSource.getId().equals(string)) continue;
            return dynamicSource;
        }
        return null;
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public List<com.contrastsecurity.agent.plugins.security.policy.a.a> getFrameworkAnnotationsWithoutClassAnnotation() {
        return this.frameworkAnnotations.get("noClassAnnotation");
    }

    public Map<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> getFrameworkAnnotations() {
        return this.frameworkAnnotations;
    }

    public Set<String> getParameterAnnotations(String string) {
        return this.parameterAnnotations.get(string);
    }

    public List<Tagger> getAllCustomSanitizerTagMethods() {
        return this.allCustomSanitizers;
    }

    public List<Tagger> getAllCustomInputValidatorTagMethods() {
        return this.allCustomValidators;
    }

    public Rule getRuleById(String string) {
        return this.rules.get(string);
    }

    public List<Propagator> getPropagatorsByClassAnnotation(String string) {
        return this.propagatorClassAnnotationMap.get(string);
    }

    public List<Propagator> getPropagatorsByClassName(String string) {
        return this.propagatorClassNameMap.get(string);
    }

    @o
    public Propagator getPropagatorById(String string) {
        return this.propagators.get(string);
    }

    public SourceNode getSourceById(String string) {
        return this.sources.get(string);
    }

    public List<SourceNode> getSourceParameterAnnotationsFor(String string) {
        return this.parameterAnnotationSources.get(string);
    }

    public List<SourceNode> getSourcesByClassName(String string) {
        return this.sourceClassNameMap.get(string);
    }

    public TagList getTagListById(String string) {
        return this.tagLists.getOrDefault(string, this.customRulesTagLists.get(string));
    }

    public Set<PolicyNode> lookupGlobalSensors(String string) {
        return this.globalChanges.getOrDefault(string, Collections.emptySet());
    }

    public Map<String, Set<String>> getAcceptedRegex() {
        return this.acceptedRegex;
    }

    public Map<String, Set<String>> getRejectedRegex() {
        return this.rejectedRegex;
    }

    @j
    public Collection<e> getDeadzones() {
        return this.globalChanges.values().stream().flatMap(Collection::stream).filter(policyNode -> policyNode instanceof e).map(policyNode -> (e)policyNode).collect(Collectors.toSet());
    }

    public boolean hasChangesFor(String string, InstrumentationContext instrumentationContext) {
        return string != null && this.globalClasses.contains(string) || ContrastPolicy.matchesDynamicSources(instrumentationContext, this.dynamicSources.values());
    }

    public boolean hasChangesFor(InstrumentationContext instrumentationContext) {
        if (instrumentationContext == null) {
            return false;
        }
        Set<String> set = instrumentationContext.getAncestors();
        for (String string : set) {
            if (!this.hasChangesFor(string, instrumentationContext)) continue;
            return true;
        }
        return this.hasChangesFor(instrumentationContext.getInternalClassName(), instrumentationContext);
    }

    public q getTagListIndices() {
        return this.tagListIndices;
    }

    public Collection<DynamicSource> getDynamicSources() {
        return this.dynamicSources.values();
    }

    @DontObfuscate
    public static class Builder {
        private final int id;
        private final String location;
        private final a customRulesCollection;
        private final List<SourceNode> sources;
        private final Map<String, List<SourceNode>> parameterAnnotationSources;
        private final Set<g> internPreventionScopes;
        private final Set<ValidatorScope> validatorScopes;
        private final List<Propagator> propagators;
        private final Map<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> frameworkAnnotations;
        private final Map<String, Set<String>> parameterAnnotations;
        private final Map<String, TagList> tagLists;
        private final Map<String, Set<PolicyNode>> globalChanges;
        private final Map<String, Rule> rules;
        private final Set<e> deadzones;
        private final Set<String> globalClasses;
        private final Map<String, DynamicSource> dynamicSources;
        private final Map<String, Set<String>> acceptedRegex;
        private final Map<String, Set<String>> rejectedRegex;

        public Builder(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            Objects.requireNonNull(string);
            this.location = string;
            this.id = n2;
            this.customRulesCollection = new a(this.id, string, a2);
            this.deadzones = new CopyOnWriteArraySet<e>();
            this.tagLists = new TreeMap<String, TagList>();
            this.sources = new ArrayList<SourceNode>();
            this.parameterAnnotationSources = new HashMap<String, List<SourceNode>>();
            this.rules = new HashMap<String, Rule>();
            this.propagators = new ArrayList<Propagator>();
            this.frameworkAnnotations = new HashMap<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>>();
            this.parameterAnnotations = new HashMap<String, Set<String>>();
            this.dynamicSources = new HashMap<String, DynamicSource>();
            this.globalChanges = new HashMap<String, Set<PolicyNode>>();
            this.acceptedRegex = new HashMap<String, Set<String>>();
            this.rejectedRegex = new HashMap<String, Set<String>>();
            this.internPreventionScopes = new HashSet<g>();
            this.validatorScopes = new HashSet<ValidatorScope>();
            this.globalClasses = new HashSet<String>(250);
        }

        @j
        DynamicSource getDynamicSource(String string) {
            for (DynamicSource dynamicSource : this.dynamicSources.values()) {
                if (!dynamicSource.getId().equals(string)) continue;
                return dynamicSource;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        private void addGlobalClass(String string) {
            this.globalClasses.add(E.g(string));
        }

        private void addGlobalClass(PolicyNode policyNode) throws InvalidParameterException {
            for (String string : ContrastPolicy.getGlobalNameFromSignature(policyNode)) {
                if (StringUtils.isEmpty(string)) continue;
                this.addGlobalClass(string);
            }
        }

        private <T extends PolicyNode> void addGlobalChanges(Collection<T> collection) {
            for (PolicyNode policyNode : collection) {
                this.addGlobalChange(policyNode);
            }
        }

        private <T extends PolicyNode> void addGlobalChange(T t2) {
            if (!t2.isSignatureBased()) {
                return;
            }
            n n2 = (n)t2.getMethodMatcher();
            m m2 = n2.a();
            if (m2.a().size() > 1) {
                String string = m2.a(new StringBuilder()).toString();
                for (String string2 : m2.a()) {
                    String string3 = string2 + '.' + string;
                    this.addGlobalChange(string3, t2);
                }
            } else {
                this.addGlobalChange(m2.toString(), t2);
            }
        }

        private void addGlobalChange(String string2, PolicyNode policyNode) {
            this.globalChanges.computeIfAbsent(string2, string -> new HashSet()).add(policyNode);
        }

        private void addTagLists(Map<String, TagList> map) {
            logger.debug("Adding tag-lists...");
            for (TagList tagList : map.values()) {
                this.addTagList(tagList);
            }
        }

        public void addTagList(TagList tagList) {
            String string = tagList.getId();
            if (this.tagLists.put(string, tagList) != null) {
                logger.warn("Duplicate tag-list '{}' was overwritten", (Object)string);
            }
            List<Tagger> list = tagList.getTaggers();
            for (Tagger tagger : list) {
                this.addGlobalChange(tagger);
                if (!tagger.isSignatureBased()) continue;
                this.addGlobalClass(tagger);
            }
        }

        private void addAcceptedValidators(Map<String, Set<String>> map) {
            this.addValidators(map, this.acceptedRegex);
        }

        private void addRejectedValidators(Map<String, Set<String>> map) {
            this.addValidators(map, this.rejectedRegex);
        }

        private void addValidators(Map<String, Set<String>> map, Map<String, Set<String>> map2) {
            if (map == null || map2 == null) {
                return;
            }
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                map2.computeIfAbsent(entry.getKey(), string -> new HashSet()).addAll((Collection)entry.getValue());
            }
        }

        private void addInternPreventionScopes(Collection<g> collection) {
            if (collection == null) {
                return;
            }
            for (g g2 : collection) {
                this.addInternPreventionScope(g2);
            }
        }

        public void addInternPreventionScope(g g2) {
            this.internPreventionScopes.add(g2);
            this.addGlobalClass(g2);
            this.addGlobalChange(g2);
        }

        private void addValidatorScopes(Set<ValidatorScope> set) {
            if (set == null) {
                return;
            }
            for (ValidatorScope validatorScope : set) {
                this.addValidatorScope(validatorScope);
            }
        }

        public void addValidatorScope(ValidatorScope validatorScope) {
            this.validatorScopes.add(validatorScope);
            this.addGlobalClass(validatorScope);
            this.addGlobalChange(validatorScope);
        }

        private void addRules(Map<String, Rule> map) {
            if (map == null) {
                return;
            }
            for (Rule rule : map.values()) {
                this.addRule(rule);
            }
        }

        public void addRule(Rule rule) {
            Event[] eventArray;
            EventPattern eventPattern;
            if (this.rules.put(rule.getId(), rule) != null) {
                logger.error("Duplicate rule '{}' detected. Overwriting.", (Object)rule.getId());
            }
            if ((eventPattern = rule.getEventPattern()) == null) {
                return;
            }
            m m2 = eventPattern.getScope();
            if (m2 != null) {
                this.addGlobalChange(m2.toString(), rule);
            }
            if ((eventArray = eventPattern.getEvents()) == null) {
                return;
            }
            for (Event event : eventArray) {
                Set<String> set;
                m m3 = event.getSignature();
                if (m3 == null || (set = m3.a()) == null || set.isEmpty()) continue;
                for (String string : set) {
                    this.addGlobalClass(string);
                }
                this.addGlobalChange(event.getSignature().toString(), event);
            }
        }

        private void addFrameworkAnnotations(Map<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> map) {
            for (Map.Entry<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> entry : map.entrySet()) {
                this.frameworkAnnotations.computeIfAbsent(entry.getKey(), string -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }

        public void addFrameworkAnnotation(com.contrastsecurity.agent.plugins.security.policy.a.a a2) {
            String string2 = StringUtils.isEmpty(a2.b()) ? "noClassAnnotation" : a2.b();
            this.frameworkAnnotations.computeIfAbsent(string2, string -> new ArrayList()).add(a2);
        }

        @j
        Map<String, List<com.contrastsecurity.agent.plugins.security.policy.a.a>> getFrameworkAnnotations() {
            return this.frameworkAnnotations;
        }

        private void addParameterAnnotations(Map<String, Set<String>> map) {
            if (map == null) {
                return;
            }
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                this.parameterAnnotations.computeIfAbsent(entry.getKey(), string -> new HashSet()).addAll((Collection)entry.getValue());
            }
        }

        public void addParameterAnnotation(String string2, String string3) {
            this.parameterAnnotations.computeIfAbsent(string2, string -> new HashSet()).add(string3);
        }

        private void addDynamicSources(Map<String, DynamicSource> map) {
            if (map == null) {
                return;
            }
            for (DynamicSource dynamicSource : map.values()) {
                this.addDynamicSource(dynamicSource);
            }
        }

        public void addDynamicSource(DynamicSource dynamicSource) {
            String string = dynamicSource.getId();
            if (this.dynamicSources.put(string, dynamicSource) != null) {
                logger.error("Duplicate dynamic-source '{}' detected. Overwriting.", (Object)string);
            }
        }

        public void addAcceptedRegex(String string2, Collection<String> collection) {
            this.acceptedRegex.computeIfAbsent(string2, string -> new HashSet()).addAll(collection);
        }

        public void addRejectedRegex(String string2, Collection<String> collection) {
            this.rejectedRegex.computeIfAbsent(string2, string -> new HashSet()).addAll(collection);
        }

        private void addDeadZones(Set<e> set) {
            if (set == null) {
                return;
            }
            for (e e2 : set) {
                this.addDeadzone(e2);
            }
        }

        public void addDeadzone(e e2) {
            this.deadzones.add(e2);
            this.addGlobalClass(e2);
            this.addGlobalChange(e2);
        }

        public void addPropagator(Propagator propagator) {
            this.propagators.add(propagator);
            this.addGlobalChange(propagator);
        }

        public void addPropagators(Collection<Propagator> collection) {
            this.propagators.addAll(collection);
            this.addGlobalChanges(collection);
        }

        public void addSources(Collection<SourceNode> collection) {
            if (collection == null) {
                return;
            }
            for (SourceNode sourceNode : collection) {
                this.addSource(sourceNode);
            }
        }

        public void addSource(SourceNode sourceNode) {
            if (sourceNode == null) {
                return;
            }
            this.sources.add(sourceNode);
            this.addGlobalChange(sourceNode);
            if (!sourceNode.isSignatureBased() && sourceNode.isParameterAnnotationAlone()) {
                Location location = sourceNode.getTargets()[0];
                String string2 = location.getParameterType();
                logger.debug("Saving {} for parameter annotation based sources", (Object)string2);
                this.parameterAnnotationSources.computeIfAbsent(string2, string -> new ArrayList()).add(sourceNode);
            }
        }

        public void applyFeatures(ServerSettingsAssessDTM serverSettingsAssessDTM) {
            if (serverSettingsAssessDTM == null) {
                return;
            }
            logger.info("Applying rule customizations...");
            this.customRulesCollection.a(serverSettingsAssessDTM);
            logger.info("Done applying rule customizations...");
        }

        public void merge(Builder builder) {
            this.addPropagators(builder.propagators);
            this.addRules(builder.rules);
            this.addSources(builder.sources);
            this.addDynamicSources(builder.dynamicSources);
            this.addTagLists(builder.tagLists);
            this.addDeadZones(builder.deadzones);
            this.addAcceptedValidators(builder.acceptedRegex);
            this.addRejectedValidators(builder.rejectedRegex);
            this.addValidatorScopes(builder.validatorScopes);
            this.addInternPreventionScopes(builder.internPreventionScopes);
            this.addFrameworkAnnotations(builder.frameworkAnnotations);
            this.addParameterAnnotations(builder.parameterAnnotations);
        }

        public ContrastPolicy build() {
            return new ContrastPolicy(this);
        }
    }

    private static class b<T extends d> {
        final Map<String, T> a;
        final Map<String, List<T>> b;
        final Map<String, List<T>> c;
        final Set<String> d;

        private b(Map<String, T> map, Map<String, List<T>> map2, Map<String, List<T>> map3, Set<String> set) {
            this.a = map;
            this.b = map2;
            this.c = map3;
            this.d = set;
        }

        public static <T extends d> b<T> a(String string2, List<T> list) {
            HashMap<String, d> hashMap = new HashMap<String, d>();
            HashMap<String, List<T>> hashMap2 = new HashMap<String, List<T>>();
            HashMap<String, List<T>> hashMap3 = new HashMap<String, List<T>>();
            HashSet<String> hashSet = new HashSet<String>();
            for (d d2 : list) {
                String string3;
                i i2;
                String string4 = d2.getId();
                if (hashMap.containsKey(string4)) {
                    logger.warn("Duplicate {} '{}' detected. Overwriting.", (Object)string2, (Object)string4);
                }
                hashMap.put(string4, d2);
                h h2 = d2.getMethodMatcher();
                if (d2.isSignatureBased()) {
                    hashSet.addAll(ContrastPolicy.getGlobalNameFromSignature(d2));
                    continue;
                }
                if (h2 instanceof com.contrastsecurity.agent.plugins.security.policy.a) {
                    i2 = (com.contrastsecurity.agent.plugins.security.policy.a)h2;
                    string3 = ((com.contrastsecurity.agent.plugins.security.policy.a)i2).a();
                    hashMap2.computeIfAbsent(string3, string -> Collections.synchronizedList(new ArrayList())).add(d2);
                    continue;
                }
                if (!(h2 instanceof com.contrastsecurity.agent.plugins.security.policy.b)) continue;
                i2 = (com.contrastsecurity.agent.plugins.security.policy.b)h2;
                string3 = ((com.contrastsecurity.agent.plugins.security.policy.b)i2).b();
                hashMap3.computeIfAbsent(string3, string -> Collections.synchronizedList(new ArrayList())).add(d2);
            }
            return new b(hashMap, hashMap2, hashMap3, hashSet);
        }
    }

    public static class a {
        private final int a;
        private final String b;
        private final Map<String, Propagator> c;
        private final List<Tagger> d;
        private final List<Tagger> e;
        private final Set<String> f;
        private final Map<Integer, Propagator> g;
        private final com.contrastsecurity.agent.plugins.security.policy.propagators.a h;
        private Map<String, TagList> i;
        private int j;
        private static int k;
        private static int l;
        private static final Logger m;

        public a(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            this.a = n2;
            this.b = string;
            this.h = a2;
            this.g = new HashMap<Integer, Propagator>();
            this.c = new HashMap<String, Propagator>();
            this.d = new ArrayList<Tagger>();
            this.e = new ArrayList<Tagger>();
            this.f = new HashSet<String>();
            this.i = new TreeMap<String, TagList>();
        }

        public a(ContrastPolicy contrastPolicy, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            this.a = contrastPolicy.id;
            this.b = contrastPolicy.location;
            this.h = a2;
            this.g = Maps.newHashMap(contrastPolicy.indexedSanitizersMap);
            this.c = new HashMap<String, Propagator>(contrastPolicy.customSanitizers);
            this.d = new ArrayList<Tagger>(contrastPolicy.allCustomSanitizers);
            this.e = new ArrayList<Tagger>(contrastPolicy.allCustomValidators);
            this.f = Sets.newHashSet(contrastPolicy.globalClasses);
            this.i = Maps.newTreeMap(contrastPolicy.customRulesTagLists);
        }

        @j
        public void a(Map<String, TagList> map) {
            this.i = map;
        }

        @o
        public Map<String, TagList> a() {
            return Collections.unmodifiableMap(this.i);
        }

        private Optional<TagList> a(boolean bl2, List<String> list) {
            return com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy$a.a(bl2, list, this.i);
        }

        private static Optional<TagList> a(boolean bl2, List<String> list, Map<String, TagList> map) {
            String string = bl2 ? "custom-encoders-" : "custom-validators-";
            for (Map.Entry<String, TagList> entry : map.entrySet()) {
                TagList tagList;
                if (!entry.getKey().startsWith(string) || (tagList = com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy$a.a(entry.getValue(), bl2, list)) == null) continue;
                return Optional.of(tagList);
            }
            return Optional.empty();
        }

        private static TagList a(TagList tagList, boolean bl2, List<String> list) {
            TagList tagList2 = null;
            Set<Tag> set = tagList.getTagListTags();
            int n2 = set.size();
            if (list == null || list.isEmpty()) {
                if (n2 == 1) {
                    Tag tag;
                    Tag tag2 = tag = bl2 ? com.contrastsecurity.agent.plugins.security.policy.c.l : com.contrastsecurity.agent.plugins.security.policy.c.k;
                    if (tag.equals((Object)set.iterator().next())) {
                        tagList2 = tagList;
                    }
                }
            } else if (n2 == list.size()) {
                boolean bl3 = true;
                for (String string : list) {
                    Tag tag = Tag.fromString((bl2 ? "custom-encoded-" : "custom-validated-") + string);
                    if (set.contains((Object)tag)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    tagList2 = tagList;
                }
            }
            return tagList2;
        }

        public void a(com.contrastsecurity.agent.plugins.security.policy.rules.a.c c2, List<PolicyNode> list) {
            switch (c2.a()) {
                case a: {
                    this.a((com.contrastsecurity.agent.plugins.security.policy.rules.a.g)c2, list);
                    break;
                }
                case b: {
                    this.a((com.contrastsecurity.agent.plugins.security.policy.rules.a.h)c2, list);
                }
            }
        }

        private void a(com.contrastsecurity.agent.plugins.security.policy.rules.a.g g2, List<PolicyNode> list) {
            switch (g2.b()) {
                case b: {
                    this.a(g2.f());
                    break;
                }
                case a: {
                    this.a(list);
                }
            }
        }

        private void a(com.contrastsecurity.agent.plugins.security.policy.rules.a.h h2, List<PolicyNode> list) {
            switch (h2.b()) {
                case b: {
                    this.a(h2.f());
                    break;
                }
                case a: {
                    PolicyNode.disableAll(list);
                }
            }
        }

        public void a(ServerSettingsAssessDTM serverSettingsAssessDTM) {
            this.a(serverSettingsAssessDTM.getSanitizers());
            this.b(serverSettingsAssessDTM.getValidators());
        }

        public void a(Set<SanitizerDTM> set) {
            if (set == null) {
                return;
            }
            for (SanitizerDTM sanitizerDTM : set) {
                this.a(sanitizerDTM);
            }
        }

        public void b(Set<InputValidatorDTM> set) {
            if (set == null) {
                return;
            }
            for (InputValidatorDTM inputValidatorDTM : set) {
                this.a(inputValidatorDTM);
            }
        }

        void a(SanitizerDTM sanitizerDTM) {
            TagList tagList = this.b(sanitizerDTM);
            String string = sanitizerDTM.getApi();
            m.debug("Adding sanitizer {}", (Object)string);
            try {
                Tagger tagger = this.h.b(this.a, this.b, tagList, sanitizerDTM.getApi());
                tagList.addTagger(tagger, true);
                TagList tagList2 = tagger.getMethodGroup();
                Propagator propagator = this.h.a(this.a, this.b, sanitizerDTM.getApi(), this.j, tagList2.getTagListTags(), tagList2.getTagListUntags());
                this.f.addAll(ContrastPolicy.getGlobalNameFromSignature(propagator));
                this.d.add(tagger);
                this.c.put(propagator.getId(), propagator);
                this.g.put(this.j, propagator);
                ++this.j;
                m.debug("Added sanitizer! {}", (Object)propagator);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                m.error("Couldn't add Sanitizer", exception2);
            }
        }

        public void a(InputValidatorDTM inputValidatorDTM) {
            TagList tagList = this.b(inputValidatorDTM);
            String string = inputValidatorDTM.getApi();
            m.debug("Adding validator: {}", (Object)string);
            try {
                Tagger tagger = this.h.a(this.a, this.b, tagList, inputValidatorDTM.getApi());
                tagger.setMethodGroup(tagList);
                tagList.addTagger(tagger, true);
                this.f.addAll(ContrastPolicy.getGlobalNameFromSignature(tagger));
                this.e.add(tagger);
                m.debug("Added validator!");
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                m.error("Couldn't add InputValidator", exception2);
            }
        }

        void a(List<PolicyNode> list) {
            for (PolicyNode policyNode : list) {
                policyNode.setEnabled(false);
                if (!m.isDebugEnabled()) continue;
                m.debug("Disabled custom sanitizer tagger {}", (Object)policyNode);
            }
        }

        Optional<TagList> a(CustomRuleAPI customRuleAPI) {
            return this.a(customRuleAPI instanceof SanitizerDTM, customRuleAPI.getRules());
        }

        public List<Tagger> b(List<String> list) {
            return this.a(true, list).map(TagList::getTaggers).orElse(Collections.emptyList());
        }

        public List<Tagger> c(List<String> list) {
            return this.a(false, list).map(TagList::getTaggers).orElse(Collections.emptyList());
        }

        private TagList b(CustomRuleAPI customRuleAPI) {
            String string;
            Set<Tag> set;
            TagList tagList = this.a(customRuleAPI).orElse(null);
            if (tagList != null) {
                return tagList;
            }
            boolean bl2 = customRuleAPI instanceof SanitizerDTM;
            List<String> list = customRuleAPI.getRules();
            if (list == null || list.isEmpty()) {
                set = Collections.singleton(bl2 ? com.contrastsecurity.agent.plugins.security.policy.c.l : com.contrastsecurity.agent.plugins.security.policy.c.k);
            } else {
                set = new HashSet<Tag>(list.size());
                string = customRuleAPI instanceof SanitizerDTM ? "custom-encoded-" : "custom-validated-";
                for (String string2 : list) {
                    set.add(Tag.fromString(string + string2));
                }
            }
            if (bl2) {
                string = "custom-encoders-" + k;
                ++k;
            } else {
                string = "custom-validators-" + l;
                ++l;
            }
            TagList tagList2 = new TagList();
            tagList2.setId(string);
            tagList2.setName(string);
            tagList2.setTagListTags(set);
            tagList2.setTaggers(new ArrayList<Tagger>());
            this.i.put(string, tagList2);
            return tagList2;
        }

        public Collection<Propagator> b() {
            return this.c.values();
        }

        static {
            m = LoggerFactory.getLogger(a.class);
        }
    }

    public static class c {
        private final Propagator[] a;

        private c(Propagator[] propagatorArray) {
            this.a = propagatorArray;
            if (logger.isTraceEnabled()) {
                for (int i2 = 0; i2 < propagatorArray.length; ++i2) {
                    logger.trace("Caching propagator {} at array index {}", (Object)propagatorArray[i2].getId(), (Object)i2);
                }
            }
        }

        public static c a(List<Propagator> list) {
            return new c(list.toArray(new Propagator[0]));
        }

        public Propagator a(int n2) {
            return this.a[n2];
        }

        public Propagator[] a() {
            return this.a;
        }

        public int a(String string) {
            if (string.startsWith("custom-encoders-")) {
                try {
                    return Integer.parseInt(string.substring("custom-encoders-".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Custom sanitizer IDs must end with an integer", numberFormatException);
                }
            }
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                Propagator propagator = this.a[i2];
                if (!propagator.getId().equals(string)) continue;
                return i2;
            }
            throw new IllegalArgumentException("Unknown propagator ID " + string);
        }

        public int b() {
            return this.a.length;
        }
    }
}

