/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.math.NumberUtils;

@DontObfuscate
public class Location {
    private final boolean isAnnotationType;
    private final String descriptor;
    private final String zeroIndexedName;
    private final int actualArgumentIndex;
    private final String argumentType;
    public static final Location O = new Location("O");
    public static final Location R = new Location("R");
    public static final Location P1 = new Location("P1");
    public static final Location P2 = new Location("P2");
    public static final Location P3 = new Location("P3");
    public static final Location P4 = new Location("P4");
    public static final Location P5 = new Location("P5");
    public static final Location P6 = new Location("P6");
    public static final Location P7 = new Location("P7");
    public static final Location P8 = new Location("P8");
    public static final Location P9 = new Location("P9");
    public static final Location P10 = new Location("P10");
    public static final Location[] ALL = new Location[]{O, R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10};
    public static final Location[] COMMON_R = new Location[]{R};
    public static final Location[] COMMON_P3 = new Location[]{P3};
    public static final Location[] COMMON_P2 = new Location[]{P2};
    public static final Location[] COMMON_P1 = new Location[]{P1};
    public static final Location[] COMMON_ALL = new Location[]{O, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10};
    public static final Location[] COMMON_P_ALL = new Location[]{P1, P2, P3, P4, P5, P6, P7, P8, P9, P10};
    public static final Location[] COMMON_O = new Location[]{O};
    public static final Location[] EMPTY = new Location[0];

    public Location(String string) {
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        boolean bl3 = string.startsWith("P");
        if (bl3) {
            String string4 = string.substring(1).trim();
            if (NumberUtils.isNumber(string4)) {
                n2 = Integer.parseInt(string4) - 1;
                string3 = "P" + n2;
            } else if (string4.startsWith("{") && string4.endsWith("}") && (string2 = string4.substring(1, string4.length() - 1)).startsWith("@")) {
                bl2 = true;
                string2 = string2.substring(1);
            }
        }
        if (bl3 && n2 == -1 && string2 == null) {
            throw new IllegalArgumentException("need a parameter index or parameter type for descriptor " + string);
        }
        this.argumentType = string2;
        this.zeroIndexedName = string3;
        this.actualArgumentIndex = n2;
        this.isAnnotationType = bl2;
        this.descriptor = string;
    }

    public boolean isObject() {
        return this == O;
    }

    public boolean isReturn() {
        return this == R;
    }

    public boolean isParameter() {
        return this.actualArgumentIndex >= 0 || this.argumentType != null;
    }

    public boolean isNumberedParameter() {
        return this.actualArgumentIndex >= 0;
    }

    public boolean isAnnotatedParameter() {
        return this.isAnnotationType;
    }

    public boolean isTypedParameter() {
        return this.isParameter() && !this.isNumberedParameter();
    }

    public int getActualParameterIndex() {
        return this.actualArgumentIndex;
    }

    public String getZeroIndexedName() {
        if (this.zeroIndexedName == null) {
            return this.descriptor;
        }
        return this.zeroIndexedName;
    }

    public String getParameterType() {
        return this.argumentType;
    }

    public static Location typeFor(String string) {
        Location location = null;
        if (string != null) {
            for (Location location2 : ALL) {
                if (!location2.descriptor.equals(string)) continue;
                location = location2;
                break;
            }
            if (string.startsWith("P{")) {
                location = new Location(string);
            }
        }
        return location;
    }

    public static Location pForArgIndex(int n2) {
        for (Location location : COMMON_P_ALL) {
            if (!location.isParameter() || location.getActualParameterIndex() != n2) continue;
            return location;
        }
        return null;
    }

    public static Location[] computeLocations(String string) {
        Location[] locationArray = null;
        if (string != null) {
            String[] stringArray = string.split(",");
            locationArray = Location.computeLocations(stringArray);
        }
        return locationArray;
    }

    public static Location[] computeLocations(String[] stringArray) {
        Location[] locationArray = Location.getCommonLocation(stringArray);
        if (locationArray == null) {
            locationArray = new Location[stringArray.length];
            for (int i2 = 0; i2 < locationArray.length; ++i2) {
                locationArray[i2] = Location.typeFor(stringArray[i2]);
            }
        }
        locationArray = Location.cleanInvalidLocations(locationArray);
        return locationArray;
    }

    public static Location[] cleanInvalidLocations(Location[] locationArray) {
        Location[] locationArray2 = locationArray;
        if (locationArray != null) {
            int n2 = 0;
            for (Location locationArray3 : locationArray) {
                if (locationArray3 != null) continue;
                ++n2;
            }
            if (n2 > 0) {
                int n3 = locationArray.length - n2;
                Location[] locationArray4 = new Location[n3];
                if (n3 > 0) {
                    int n4 = 0;
                    for (Location location : locationArray) {
                        if (location == null) continue;
                        locationArray4[n4] = location;
                        ++n4;
                    }
                }
                locationArray2 = locationArray4;
            }
        }
        return locationArray2;
    }

    static Location[] getCommonLocation(String[] stringArray) {
        Location[] locationArray = null;
        if (stringArray.length == 1) {
            String string = stringArray[0];
            if ("O".equals(string)) {
                locationArray = COMMON_O;
            } else if ("R".equals(string)) {
                locationArray = COMMON_R;
            } else if ("P1".equals(string)) {
                locationArray = COMMON_P1;
            } else if ("P2".equals(string)) {
                locationArray = COMMON_P2;
            } else if ("P3".equals(string)) {
                locationArray = COMMON_P3;
            } else if ("P*".equals(string)) {
                locationArray = COMMON_P_ALL;
            }
        }
        return locationArray;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "Location{'" + this.descriptor + "'}";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Location)) {
            return false;
        }
        return this.descriptor.equals(((Location)object).descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }
}

