/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.reflection;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Deprecated
@DontObfuscate
public final class ReflectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Constructor<?>[] getConstructors(Class<?> clazz) {
        return l.c() ? clazz.getConstructors() : AccessController.doPrivileged(clazz::getConstructors);
    }

    public static Field findField(Class<?> clazz, String string) {
        Objects.requireNonNull(string);
        for (Class<?> clazz2 = Objects.requireNonNull(clazz); Object.class != clazz2 && clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field field = ReflectionUtil.findDeclaredField(clazz2, string);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static Object getFieldValue(Object object, String string) {
        try {
            if (l.c()) {
                Field field = ReflectionUtil.findField(object.getClass(), string);
                return field == null ? null : field.get(object);
            }
            return AccessController.doPrivileged(() -> {
                Field field = ReflectionUtil.findField(object.getClass(), string);
                return field == null ? null : field.get(object);
            });
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Problem getting field value: {}#{}", object.getClass().getName(), string, throwable2);
            return null;
        }
    }

    public static Field findDeclaredField(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(string);
        return l.c() ? ReflectionUtil._findField(clazz, string) : AccessController.doPrivileged(() -> ReflectionUtil._findField(clazz, string));
    }

    private static Field _findField(Class<?> clazz, String string) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (!string.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for field: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    public static Field findPublicField(Class<?> clazz, String string) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(string);
        return l.c() ? ReflectionUtil._findPublicField(clazz, string) : AccessController.doPrivileged(() -> ReflectionUtil._findPublicField(clazz, string));
    }

    private static Field _findPublicField(Class<?> clazz, String string) {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getFields()) {
                if (!string.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for field: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    @Deprecated
    public static Field getDeclaredField(Object object, String string) throws NoSuchFieldException {
        return ReflectionUtil.getDeclaredField(object.getClass(), string);
    }

    @Deprecated
    public static Field getDeclaredField(Class<?> clazz, String string) throws NoSuchFieldException {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(string);
        if (l.c()) {
            return ReflectionUtil._getDeclaredField(clazz, string);
        }
        try {
            return AccessController.doPrivileged(() -> ReflectionUtil._getDeclaredField(clazz, string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwables.throwIfCritical(privilegedActionException);
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            throw Throwables.propagate(privilegedActionException2, NoSuchFieldException.class);
        }
    }

    private static Field _getDeclaredField(Class<?> clazz, String string) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for field: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        return l.c() ? ReflectionUtil._getDeclaredFields(clazz) : AccessController.doPrivileged(() -> ReflectionUtil._getDeclaredFields(clazz));
    }

    private static Field[] _getDeclaredFields(Class<?> clazz) {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                field.setAccessible(true);
            }
            return fieldArray;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for fields", noClassDefFoundError);
            return Empty.FIELDS;
        }
    }

    public static List<Field> findDeclaredFieldsWithType(Class<?> clazz, String string) {
        return l.c() ? ReflectionUtil._findFields(clazz, string) : AccessController.doPrivileged(() -> ReflectionUtil._findFields(clazz, string));
    }

    private static List<Field> _findFields(Class<?> clazz, String string) {
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (Field field : fieldArray) {
                if (!string.equals(field.getType().getName())) continue;
                field.setAccessible(true);
                arrayList.add(field);
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for fields", noClassDefFoundError);
            return Collections.emptyList();
        }
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Objects.requireNonNull(string);
        for (Class<?> clazz2 = Objects.requireNonNull(clazz); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method method;
            Class<?> clazz3 = clazz2;
            Method method2 = method = l.c() ? ReflectionUtil._findDeclaredMethod(clazz3, string, classArray) : AccessController.doPrivileged(() -> ReflectionUtil._findDeclaredMethod(clazz3, string, classArray));
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method _findDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            return ReflectionUtil._findMethod(string, methodArray, classArray);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for method: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    public static Method findPublicMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(string);
        return l.c() ? ReflectionUtil._findPublicMethod(clazz, string, classArray) : AccessController.doPrivileged(() -> ReflectionUtil._findPublicMethod(clazz, string, classArray));
    }

    private static Method _findPublicMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            Method[] methodArray = clazz.getMethods();
            return ReflectionUtil._findMethod(string, methodArray, classArray);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for method: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    private static Method _findMethod(String string, Method[] methodArray, Class<?>[] classArray) {
        if (classArray == null) {
            classArray = Empty.CLASS_ARRAY;
        }
        for (Method method : methodArray) {
            if (!string.equals(method.getName()) || !Arrays.equals(classArray, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Constructor<?> findDeclaredConstructor(Class<?> clazz, Class<?> ... classArray) {
        return l.c() ? ReflectionUtil._findDeclaredConstructor(clazz, classArray) : AccessController.doPrivileged(() -> ReflectionUtil._findDeclaredConstructor(clazz, classArray));
    }

    private static Constructor<?> _findDeclaredConstructor(Class<?> clazz, Class<?>[] classArray) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            if (!Arrays.equals(classArray, constructor.getParameterTypes())) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }

    public static Object invoke(Method method, Object object, Object ... objectArray) {
        try {
            if (l.c()) {
                return method.invoke(object, objectArray);
            }
            return AccessController.doPrivileged(() -> method.invoke(object, objectArray));
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Problem executing: {}#{}", object.getClass().getName(), method, throwable2);
            return null;
        }
    }

    @Deprecated
    public static Object findAndInvokeMethod(Object object, String string) throws InvocationTargetException, IllegalAccessException {
        return ReflectionUtil.findAndInvokeMethod(object, string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    @Deprecated
    public static Object findAndInvokeMethod(Object object, String string, Class<?>[] classArray, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
        Objects.requireNonNull(object);
        Preconditions.check(objectArray.length == classArray.length, "parameterTypes must be the same length as params");
        Method method = ReflectionUtil.findMethod(object.getClass(), string, classArray);
        if (method == null || Modifier.isAbstract(method.getModifiers())) {
            return null;
        }
        return method.invoke(object, objectArray);
    }

    @Deprecated
    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (l.c()) {
            return ReflectionUtil._getMethod(clazz, string, classArray);
        }
        try {
            return AccessController.doPrivileged(() -> ReflectionUtil._getMethod(clazz, string, classArray));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwables.throwIfCritical(privilegedActionException);
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            throw Throwables.propagate(privilegedActionException2, NoSuchMethodException.class);
        }
    }

    @Deprecated
    public static Method getMethod(Class<?> clazz, String string) throws NoSuchMethodException {
        return ReflectionUtil.getMethod(clazz, string, Empty.CLASS_ARRAY);
    }

    private static Method _getMethod(Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        try {
            Method method = clazz.getMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for method: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    @Deprecated
    public static Method getDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
        if (l.c()) {
            return ReflectionUtil._getDeclaredMethod(clazz, string, classArray);
        }
        try {
            return AccessController.doPrivileged(() -> ReflectionUtil._getDeclaredMethod(clazz, string, classArray));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwables.throwIfCritical(privilegedActionException);
            PrivilegedActionException privilegedActionException2 = privilegedActionException;
            throw Throwables.propagate(privilegedActionException2, NoSuchMethodException.class);
        }
    }

    @Deprecated
    public static Method getDeclaredMethod(Class<?> clazz, String string) throws NoSuchMethodException {
        return ReflectionUtil.getDeclaredMethod(clazz, string, Empty.CLASS_ARRAY);
    }

    private static Method _getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for method: {}", (Object)string, (Object)noClassDefFoundError);
            return null;
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        try {
            return l.c() ? clazz.getDeclaredMethods() : AccessController.doPrivileged(clazz::getDeclaredMethods);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.debug("Encountered NoClassDefFoundError while looking for methods", noClassDefFoundError);
            return Empty.METHODS;
        }
    }

    @Deprecated
    public static Object callPublicVirtualMethod(Object object, String string, Class<?>[] classArray, Object[] objectArray) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectionUtil.getMethod(object.getClass(), string, classArray);
        return method.invoke(object, objectArray);
    }

    @Deprecated
    public static Object callPublicVirtualMethod(Object object, String string) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectionUtil.callPublicVirtualMethod(object, string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    @Deprecated
    public static Object callPublicVirtualMethodOrNull(Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        try {
            return ReflectionUtil.callPublicVirtualMethod(object, string, classArray, objectArray);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            return null;
        }
    }

    @Deprecated
    public static Object callPublicVirtualMethodOrNull(Object object, String string) {
        return ReflectionUtil.callPublicVirtualMethodOrNull(object, string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    private ReflectionUtil() {
    }

    static Method lookupMethod(Class<?> clazz, String string, boolean bl2, Class<?>[] classArray, Object ... objectArray) {
        if (classArray == null) {
            throw new NullPointerException("Unable to reflect with a null argType array");
        }
        if (objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Argument lengths between argTypes and args do not match");
        }
        return bl2 ? ReflectionUtil.findPublicMethod(clazz, string, classArray) : ReflectionUtil.findMethod(clazz, string, classArray);
    }
}

