/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.services.b;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.util.E;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class h
implements a {
    private final Config a;
    private final Supplier<ContrastEngine> b;
    private final Supplier<Map<Thread, StackTraceElement[]>> c;
    private final TelemetryErrorEmitter d;
    private final b e;
    private ScheduledFuture<?> f;
    private static final String g = "Contrast";
    private static final String[] h = new String[]{"Finalizer thread", "Concurrent Mark Helper", "Attach API wait loop", "Signal Dispatcher", "JIT Compilation Thread"};
    private static final Logger i = LoggerFactory.getLogger(h.class);

    public h(Config config, Supplier<ContrastEngine> supplier, TelemetryErrorEmitter telemetryErrorEmitter, b b2) {
        this(config, supplier, Thread::getAllStackTraces, telemetryErrorEmitter, b2);
    }

    @o
    h(Config config, Supplier<ContrastEngine> supplier, Supplier<Map<Thread, StackTraceElement[]>> supplier2, TelemetryErrorEmitter telemetryErrorEmitter, b b2) {
        this.a = config;
        this.b = supplier;
        this.c = Objects.requireNonNull(supplier2);
        this.d = Objects.requireNonNull(telemetryErrorEmitter);
        this.e = b2;
    }

    @Override
    public synchronized void start(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        int n2 = this.a.getInt(ConfigProperty.ZOMBIE_CHECK_PERIOD_MS);
        if (n2 < 0) {
            i.debug("zombie service inactive because period is {}", (Object)n2);
            return;
        }
        if (this.f != null) {
            throw new IllegalStateException("ZombieService already started");
        }
        this.f = this.e.a().scheduleWithFixedDelay(() -> {
            if (this.a()) {
                try {
                    this.b.get().stop();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    i.error("Error stopping Contrast after zombie state detected", throwable2);
                    this.d.emit(throwable2);
                }
            }
        }, n2, n2, TimeUnit.MILLISECONDS);
    }

    @o
    boolean a() {
        Map<Thread, StackTraceElement[]> map = this.c.get();
        for (Thread thread : map.keySet()) {
            if (thread.getName().startsWith(g) || E.d(h, thread.getName())) continue;
            if (i.isDebugEnabled()) {
                i.debug("FOUND GOING THREAD: {}", (Object)thread.getName());
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        if (this.f != null) {
            i.debug("Attempting to stop ZombieService");
            this.f.cancel(false);
            this.f = null;
        }
    }

    @Override
    public boolean blocksOnStop() {
        return false;
    }

    @Override
    public String getName() {
        return "Zombie";
    }
}

