/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.exception.b;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.d;
import com.contrastsecurity.agent.services.ngreporting.e;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.l;
import com.contrastsecurity.agent.services.ngreporting.n;
import com.contrastsecurity.agent.services.ngreporting.p;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@m
public final class g
implements f {
    private final Map<Long, Long> a = new ConcurrentHashMap<Long, Long>();
    private final Queue<LegacyReport> b = new ConcurrentLinkedQueue<LegacyReport>();
    private volatile boolean c;
    private Thread d;
    private final d e;
    private final long f;
    private final boolean g;
    private final Config h;
    private final n i;
    private final Clock j;
    private final com.contrastsecurity.agent.d.g k;
    private final long l;
    private final TelemetryErrorEmitter m;
    private static final Logger n = LoggerFactory.getLogger(g.class);

    public g(Config config, Clock clock, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, TelemetryErrorEmitter telemetryErrorEmitter) {
        this(config, clock, !StringUtils.isEmpty(config.getOrNull(ConfigProperty.TEAMSERVER_URL)) ? new e(config, g2) : null, g2, workingDirectories, telemetryErrorEmitter);
    }

    public g(Config config, Clock clock, n n2, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, TelemetryErrorEmitter telemetryErrorEmitter) {
        this.h = Objects.requireNonNull(config);
        this.j = Objects.requireNonNull(clock);
        this.k = Objects.requireNonNull(g2);
        this.i = n2;
        this.m = Objects.requireNonNull(telemetryErrorEmitter);
        this.l = config.getLong(ConfigProperty.DUP_DELAY);
        this.e = new d(config, workingDirectories);
        this.f = config.getLong(ConfigProperty.LEGACY_REPORTING_PERIOD);
        this.g = config.getBoolean(ConfigProperty.PREFLIGHT_FAIL_OPEN);
        this.c = true;
    }

    Queue<LegacyReport> a() {
        return this.b;
    }

    @Override
    public boolean blocksOnStop() {
        return true;
    }

    @Override
    public String getName() {
        return "LegacyReporting";
    }

    @Override
    public synchronized void start(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        if (this.d != null) {
            return;
        }
        this.c = true;
        this.d = com.contrastsecurity.agent.scope.b.a("Contrast Reporting", this.m).newThread(() -> {
            while (this.c) {
                try {
                    this.b();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    n.error("Problem sending reports to Contrast TeamServer", throwable2);
                    this.m.emit(throwable2);
                }
                try {
                    Thread.sleep(this.f);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.b();
        });
        n.info("Starting reporting thread...");
        this.d.start();
    }

    @Override
    public synchronized void stop() {
        if (this.d == null) {
            return;
        }
        this.c = false;
        Thread thread = this.d;
        this.d = null;
        thread.interrupt();
        n.debug("Processing remaining elements in the reporting queue");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            n.debug("Processing remaining elements in the queue - interrupted");
            return;
        }
        n.debug("Processing remaining elements in the queue - done");
    }

    @Override
    public a.a f() {
        return a.a.b;
    }

    private boolean c(LegacyReport legacyReport) {
        long l2 = legacyReport.getHash();
        if (this.a(legacyReport.getApplication(), l2)) {
            legacyReport.onIgnoredAsAlreadyReported();
            if (n.isDebugEnabled()) {
                n.debug("LegacyReport {} already reported to server: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return false;
        }
        if (this.b.offer(legacyReport)) {
            this.a.put(com.contrastsecurity.agent.services.ngreporting.g.b(legacyReport.getApplication(), l2), this.j.now());
            legacyReport.onAcceptedIntoReportingQueue();
            if (n.isDebugEnabled()) {
                n.debug("Trace {} added to reporting queue: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return true;
        }
        if (n.isDebugEnabled()) {
            n.debug("Trace {} was skipped as reporting queue was full: {}", (Object)l2, (Object)legacyReport.getShortDescription());
        }
        return false;
    }

    @Override
    public boolean a(Application application, long l2) {
        if (l2 == 0L) {
            return false;
        }
        long l3 = this.j.now();
        Long l4 = this.a.get(com.contrastsecurity.agent.services.ngreporting.g.b(application, l2));
        return l4 != null && l3 - l4 <= this.l;
    }

    private static long b(Application application, long l2) {
        return (long)(application == null ? 0 : application.hashCode()) + l2;
    }

    @o
    void b() {
        int n2;
        ArrayList<LegacyReport> arrayList;
        SaveReportMode saveReportMode;
        boolean bl2;
        block20: {
            LegacyReport legacyReport;
            ArrayList<LegacyReport> arrayList2 = new ArrayList<LegacyReport>();
            ArrayList<LegacyReport> arrayList3 = new ArrayList<LegacyReport>();
            bl2 = false;
            saveReportMode = com.contrastsecurity.agent.services.ngreporting.g.a(this.h);
            boolean bl3 = SaveReportMode.Always.equals((Object)saveReportMode);
            while ((legacyReport = this.b.poll()) != null) {
                Application application = legacyReport.getApplication();
                if (application == null) {
                    arrayList3.add(legacyReport);
                } else if (!application.isUnwanted()) {
                    if (!application.getState().isCreated()) {
                        arrayList2.add(legacyReport);
                    } else {
                        arrayList3.add(legacyReport);
                    }
                }
                if (!bl3) continue;
                this.e.a(legacyReport);
                bl2 = true;
            }
            int n3 = arrayList2.size();
            if (n3 > 0) {
                this.b.addAll(arrayList2);
                n.debug("Held back {} reports until app created.", (Object)n3);
            }
            if (arrayList3.isEmpty()) {
                return;
            }
            if (this.i == null) {
                return;
            }
            arrayList = new ArrayList<LegacyReport>();
            HashMap<Integer, LegacyReport> hashMap = new HashMap<Integer, LegacyReport>();
            n2 = 0;
            for (LegacyReport object2 : arrayList3) {
                if (object2.requiresPreflight()) {
                    hashMap.put(n2++, object2);
                    if (!(object2 instanceof h)) continue;
                    this.a((h)object2);
                    continue;
                }
                n.debug("Adding {} to preflight approved reports", (Object)object2.getHash());
                arrayList.add(object2);
            }
            if (!hashMap.isEmpty()) {
                try {
                    arrayList.addAll(this.i.a(hashMap));
                }
                catch (IOException iOException) {
                    if (saveReportMode.equals((Object)SaveReportMode.OnError)) {
                        for (Object object : hashMap.values()) {
                            this.e.a((LegacyReport)object);
                        }
                        bl2 = true;
                    }
                    if (n.isDebugEnabled()) {
                        String string = this.g ? "adding all" : "not adding any";
                        n.debug("Problem asking for preflight acceptance of reports - {} to approved list", (Object)string, (Object)iOException);
                    }
                    if (!this.g) break block20;
                    arrayList.addAll(hashMap.values());
                }
            }
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n3;
            Object object;
            LegacyReport legacyReport = (LegacyReport)arrayList.get(i2);
            if (legacyReport instanceof h) {
                this.b((h)legacyReport);
            }
            int n4 = n3 = (object = this.i.a(legacyReport)) != null ? ((com.contrastsecurity.agent.e.f)object).a() : -1;
            if (saveReportMode.equals((Object)SaveReportMode.OnError) && n3 == -1 && !bl2) {
                this.e.a(legacyReport);
            }
            ++n2;
            if (!this.d()) continue;
            n.warn("Received bad response after sending {} of {} approved reports. Dumping the queue and pausing service.", (Object)n2, (Object)arrayList.size());
            this.e();
            break;
        }
        n.trace("Sent out {} reports to server", (Object)n2);
    }

    private void a(h h2) {
        p p2 = h2.getListener();
        if (p2 != null) {
            p2.a(h2);
        }
    }

    private void b(h h2) {
        p p2 = h2.getListener();
        if (p2 != null) {
            p2.b(h2);
        }
    }

    @Override
    public com.contrastsecurity.agent.e.f<String> b(LegacyReport legacyReport) {
        com.contrastsecurity.agent.e.f<String> f2 = null;
        if (this.c()) {
            n.debug("Not sending report because reporting service is still paused");
        } else if (!this.c) {
            n.debug("Not sending report because reporting service is stopped");
        } else if (this.i != null) {
            f2 = this.i.a(legacyReport);
            int n2 = f2 != null ? f2.a() : -1;
            SaveReportMode saveReportMode = com.contrastsecurity.agent.services.ngreporting.g.a(this.h);
            if (SaveReportMode.OnError.equals((Object)saveReportMode) && n2 == -1 || SaveReportMode.Always.equals((Object)saveReportMode)) {
                this.e.a(legacyReport);
            }
        }
        if (this.d()) {
            this.e();
        }
        return f2;
    }

    @Override
    public boolean a(LegacyReport legacyReport) {
        if (this.c()) {
            n.debug("Not queuing report because reporting service is still paused by an earlier 401 or 412");
            return false;
        }
        if (!this.c) {
            n.debug("Not queueing report because reporting service is stopped");
            return false;
        }
        String string = this.h.get(ConfigProperty.VM_ID);
        if (legacyReport.getApplication() != null) {
            string = legacyReport.getApplication().getName();
        }
        boolean bl2 = this.c(legacyReport);
        l l2 = null;
        String string2 = "Unable to generate report JSON";
        try {
            string2 = legacyReport.getPayload();
        }
        catch (l l3) {
            l2 = l3;
        }
        if (n.isDebugEnabled()) {
            n.debug("\n\tApplication: {}\n\tReportMethod: {}\n\tReportURL(): {}\n\tReportLevel(): {}\n\tReportType(): {}\n\tReportJSON():\n{}\n", new Object[]{string, legacyReport.getMethod(), legacyReport.getURL(), legacyReport.getLevel(), legacyReport.getClass().getSimpleName(), string2, l2});
        }
        return bl2;
    }

    boolean c() {
        return this.k.b();
    }

    boolean d() {
        return this.k.b();
    }

    void e() {
        this.b.clear();
        n.warn("Clearing reporting service queue and pausing reports because of paused TeamServer channel");
    }

    @o
    void g() {
        this.a.clear();
    }

    @o
    void h() {
        this.b.clear();
    }

    static SaveReportMode a(Config config) {
        String string = config.get(ConfigProperty.SAVERESULTS);
        SaveReportMode saveReportMode = SaveReportMode.valueOfIgnoreCase(string);
        if (saveReportMode == null) {
            throw new b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.SAVERESULTS) + ". Valid values are Always, Never, OnError.");
        }
        return saveReportMode;
    }

    @Override
    public com.contrastsecurity.agent.commons.e purgeStale() {
        long l2 = this.j.now();
        int n2 = this.a.size();
        this.a.entrySet().removeIf(entry -> l2 - (Long)entry.getValue() > this.l);
        return new com.contrastsecurity.agent.commons.e(n2, this.a.size());
    }

    @o
    long i() {
        return this.a.entrySet().stream().filter(entry -> this.j.now() - (Long)entry.getValue() > this.l).count();
    }
}

