/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.shim;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.shim.Shim;
import com.contrastsecurity.agent.telemetry.errors.TelemetryErrorEmitter;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@DontObfuscate
public final class ShimCache {
    private final ConcurrentReferenceHashMap<ClassLoader, Map<String, Shim>> cache = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private final TelemetryErrorEmitter emitter;
    private static final Logger logger = LoggerFactory.getLogger(ShimCache.class);

    public ShimCache(TelemetryErrorEmitter telemetryErrorEmitter) {
        this.emitter = telemetryErrorEmitter;
    }

    public <T extends Shim> T get(Class<T> clazz, T t2, String string, Object object) {
        return this.get(clazz, t2, string, Collections.emptyList(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Shim> T get(Class<T> clazz, T t2, String string, Collection<String> collection, Object object) {
        if (t2 == null) {
            Assert.fail("ShimCache _REQUIRES_ a non-null nop shim instance");
        }
        if (object == null || clazz == null || string == null) {
            return t2;
        }
        Class<?> clazz2 = object.getClass();
        ClassLoader classLoader2 = l.b(clazz2);
        if (classLoader2 == null) {
            logger.debug("Unable to get ClassLoader for context object: {}", (Object)clazz2.getName());
            return t2;
        }
        Map map = this.cache.computeIfAbsent(classLoader2, classLoader -> new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG));
        Shim shim = (Shim)map.get(string);
        if (shim != null) {
            return (T)shim;
        }
        Map map2 = map;
        synchronized (map2) {
            try {
                shim = (Shim)map.get(string);
                if (shim != null) {
                    return (T)shim;
                }
                Class clazz3 = ContrastClassLoaderUtil.findOrLoadContrastClass((ClassLoader)classLoader2, (String)string);
                if (clazz3 != null) {
                    if (!clazz.isAssignableFrom(clazz3)) {
                        logger.debug("Class {} is not assignable to expected shim class {}", (Object)clazz3.getName(), (Object)clazz.getName());
                        return t2;
                    }
                    for (String string2 : collection) {
                        Class clazz4 = ContrastClassLoaderUtil.findOrLoadContrastClass((ClassLoader)classLoader2, (String)string2);
                        if (clazz4 == null) {
                            logger.debug("Unable to load additional class: {}", (Object)string2);
                            map.put(string, t2);
                            return t2;
                        }
                        ShimCache.primeClasses(clazz4);
                    }
                    ShimCache.primeClasses(clazz3);
                    Shim shim2 = (Shim)clazz3.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    map.put(string, shim2);
                    return (T)shim2;
                }
                logger.debug("Unable to load class: {}", (Object)string);
                map.put(string, t2);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.debug("Unable to load class: {} via object: {}", string, clazz2.getName(), throwable2);
                map.put(string, t2);
                this.emitter.emit(throwable2);
            }
        }
        return t2;
    }

    private static void primeClasses(Class<?> clazz) {
        clazz.getDeclaredFields();
        clazz.getDeclaredMethods();
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            ShimCache.primeClasses(clazz2);
        }
    }
}

