/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.util.VMArguments;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DontObfuscate
public final class ContrastAgentUtil {
    private static final String PREFIX = "com.contrastsecurity.";
    private static final String PREFIX_SLASH = "com/contrastsecurity/";
    private static final int PREFIX_LENGTH = "com.contrastsecurity.".length();
    private static final String AGENT = "agent.";
    private static final String AGENT_SLASH = "agent/";
    private static final String THIRD_PARTY = "thirdparty.";
    private static final String THIRD_PARTY_SLASH = "thirdparty/";
    private static final int MINIMUM_AGENT_PREFIX_LENGTH = PREFIX_LENGTH + Math.min("agent.".length(), "thirdparty.".length());
    private static final int AGENT_THIRD_PARTY_LENGTH = PREFIX_LENGTH + "thirdparty.".length();
    public static final String AGENT_PREFIX = "com.contrastsecurity.agent.";
    public static final String AGENT_PREFIX_INTERNAL = "com.contrastsecurity.agent.".replace('.', '/');
    private static final String BASE_INJECTIONS_PACKAGE = "java.lang.";
    private static final int BASE_INJECTIONS_PACKAGE_LENGTH = "java.lang.".length();
    private static final String BASE_INJECTIONS_SIMPLE_NAME_PREFIX = "Contrast";
    private static final String BASE_INJECTIONS_PREFIX = "java.lang.Contrast";
    private static int BASE_INJECTIONS_PREFIX_LENGTH = "java.lang.Contrast".length();

    public static File findAgentJar() {
        return System.getSecurityManager() == null ? ContrastAgentUtil._findAgentJar() : AccessController.doPrivileged(ContrastAgentUtil::_findAgentJar);
    }

    private static File _findAgentJar() {
        File file = ContrastAgentUtil.findAgentJarFromClassPath();
        if (file != null) {
            return file;
        }
        file = ContrastAgentUtil.findAgentJarFromJavaAgentArgs();
        if (file != null) {
            return file;
        }
        String string = l.b("contrast.agent.location");
        file = string != null ? new File(string) : null;
        return ContrastAgentUtil.verifyAgentJar(file) ? file : null;
    }

    private static File findAgentJarFromClassPath() {
        ProtectionDomain protectionDomain = l.c(ContrastAgentUtil.class);
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL uRL = codeSource.getLocation();
        if (uRL == null) {
            return null;
        }
        try {
            File file = new File(uRL.toURI());
            if (ContrastAgentUtil.verifyAgentJar(file)) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static File findAgentJarFromJavaAgentArgs() {
        List<String> list = VMArguments.getVMArguments();
        Pattern pattern = Pattern.compile("-javaagent:([^=]+).*");
        for (String string : list) {
            String string2;
            File file;
            Matcher matcher;
            if (!string.startsWith("-javaagent") || !(matcher = pattern.matcher(string)).find() || !ContrastAgentUtil.verifyAgentJar(file = new File(string2 = matcher.group(1)))) continue;
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyAgentJar(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) return false;
        if (!file.isFile()) {
            return false;
        }
        try {
            Object object;
            JarFile jarFile;
            block9: {
                boolean bl2;
                jarFile = new JarFile(file);
                try {
                    object = jarFile.getManifest();
                    if (object != null) break block9;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    object = throwable;
                    try {
                        jarFile.close();
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        Throwables.throwIfCritical(throwable2);
                        Throwable throwable3 = throwable2;
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                    throw object;
                }
                jarFile.close();
                return bl2;
            }
            String string = ((Manifest)object).getMainAttributes().getValue("Premain-Class");
            boolean bl3 = "com.contrastsecurity.agent.ContrastLoaderAgent".equals(string);
            jarFile.close();
            return bl3;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isAgentClass(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < MINIMUM_AGENT_PREFIX_LENGTH) {
            return false;
        }
        if (!(string.startsWith(AGENT, PREFIX_LENGTH) || string.length() >= AGENT_THIRD_PARTY_LENGTH && string.startsWith(THIRD_PARTY, PREFIX_LENGTH))) {
            return false;
        }
        return string.startsWith(PREFIX);
    }

    public static boolean isAgentClassInternal(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < MINIMUM_AGENT_PREFIX_LENGTH) {
            return false;
        }
        if (!(string.startsWith(AGENT_SLASH, PREFIX_LENGTH) || string.length() >= AGENT_THIRD_PARTY_LENGTH && string.startsWith(THIRD_PARTY_SLASH, PREFIX_LENGTH))) {
            return false;
        }
        return string.startsWith(PREFIX_SLASH);
    }

    public static boolean isContrastBaseInjection(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < BASE_INJECTIONS_PREFIX_LENGTH) {
            return false;
        }
        if (!string.startsWith(BASE_INJECTIONS_SIMPLE_NAME_PREFIX, BASE_INJECTIONS_PACKAGE_LENGTH)) {
            return false;
        }
        return string.startsWith(BASE_INJECTIONS_PACKAGE);
    }

    private ContrastAgentUtil() {
    }
}

