/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.weakmap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.weakmap.ReentrantSegment;
import com.contrastsecurity.agent.weakmap.SynchronizedSegment;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

@DontObfuscate
@HeapUsage.SupportsHeapProfiling
public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final ReferenceType DEFAULT_KEY_TYPE = ReferenceType.WEAK;
    static final ReferenceType DEFAULT_VALUE_TYPE = ReferenceType.STRONG;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    @HeapUsage.Deep
    final Segment<K, V>[] segments;
    boolean identityComparisons;
    @HeapUsage.Deep
    transient Set<K> keySet;
    @HeapUsage.Deep
    transient Set<Map.Entry<K, V>> entrySet;
    @HeapUsage.Deep
    transient Collection<V> values;

    private static int hash(int n2) {
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    final Segment<K, V> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    private int hashOf(Object object) {
        return object instanceof String ? object.hashCode() : System.identityHashCode(object);
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3, ReferenceType referenceType, ReferenceType referenceType2, EnumSet<Option> enumSet, boolean bl2) {
        int n4;
        int n5;
        int n6;
        if (!(f2 > 0.0f) || n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n3 > 65536) {
            n3 = 65536;
        }
        int n7 = 0;
        for (n6 = 1; n6 < n3; n6 <<= 1) {
            ++n7;
        }
        this.segmentShift = 32 - n7;
        this.segmentMask = n6 - 1;
        Segment<K, V>[] segmentArray = this.segments = bl2 ? new SynchronizedSegment[n6] : new ReentrantSegment[n6];
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if ((n5 = n2 / n6) * n6 < n2) {
            ++n5;
        }
        for (n4 = 1; n4 < n5; n4 <<= 1) {
        }
        this.identityComparisons = enumSet != null && enumSet.contains((Object)Option.IDENTITY_COMPARISONS);
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = bl2 ? new SynchronizedSegment(n4, f2, referenceType, referenceType2, this.identityComparisons) : new ReentrantSegment(n4, f2, referenceType, referenceType2, this.identityComparisons);
        }
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3, ReferenceType referenceType, ReferenceType referenceType2, EnumSet<Option> enumSet) {
        this(n2, f2, n3, referenceType, referenceType2, enumSet, false);
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3) {
        this(n2, f2, n3, DEFAULT_KEY_TYPE, DEFAULT_VALUE_TYPE, null, false);
    }

    public ConcurrentReferenceHashMap(int n2, float f2) {
        this(n2, f2, 16);
    }

    public ConcurrentReferenceHashMap(int n2, ReferenceType referenceType, ReferenceType referenceType2) {
        this(n2, 0.75f, 16, referenceType, referenceType2, null, false);
    }

    public ConcurrentReferenceHashMap(ReferenceType referenceType, ReferenceType referenceType2) {
        this(16, 0.75f, 16, referenceType, referenceType2, null, false);
    }

    public ConcurrentReferenceHashMap(ReferenceType referenceType, ReferenceType referenceType2, EnumSet<Option> enumSet) {
        this(16, 0.75f, 16, referenceType, referenceType2, enumSet, false);
    }

    public ConcurrentReferenceHashMap(int n2) {
        this(n2, 0.75f, 16);
    }

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentReferenceHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        int n2;
        Segment<K, V>[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count() != 0) {
                return false;
            }
            nArray[n2] = segmentArray[n2].modCount();
            n3 += nArray[n2];
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count() == 0 && nArray[n2] == segmentArray[n2].modCount()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segmentArray = this.segments;
        long l2 = 0L;
        long l3 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2;
            l3 = 0L;
            l2 = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l2 += (long)segmentArray[n2].count();
                nArray[n2] = segmentArray[n2].modCount();
                n3 += nArray[n2];
            }
            if (n3 != 0) {
                for (n2 = 0; n2 < segmentArray.length; ++n2) {
                    l3 += (long)segmentArray[n2].count();
                    if (nArray[n2] == segmentArray[n2].modCount()) continue;
                    l3 = -1L;
                    break;
                }
            }
            if (l3 == l2) break;
        }
        if (l3 != l2) {
            l2 = 0L;
            for (Segment<K, V> segment : segmentArray) {
                l2 += (long)segment.count();
            }
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public V get(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).get(object, n2);
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n2 = this.hashOf(object);
        return this.segmentFor(n2).remove(object, n2, null, false);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n2 = this.hashOf(object);
        if (object2 == null) {
            return false;
        }
        return this.segmentFor(n2).remove(object, n2, object2, false) != null;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        if (v2 == null || v3 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    @Override
    public V replace(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.hashOf(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    public void purgeStaleEntries() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].removeStale();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    @DontObfuscate
    static interface Segment<K, V> {
        public int modCount();

        public int count();

        public HashEntry<K, V>[] table();

        public V get(Object var1, int var2);

        public boolean containsKey(Object var1, int var2);

        public boolean replace(K var1, int var2, V var3, V var4);

        public V replace(K var1, int var2, V var3);

        public V put(K var1, int var2, V var3, boolean var4);

        public V remove(Object var1, int var2, Object var3, boolean var4);

        public void removeStale();

        public void clear();
    }

    @DontObfuscate
    public static enum Option {
        IDENTITY_COMPARISONS;

    }

    @DontObfuscate
    public static enum ReferenceType {
        STRONG,
        WEAK,
        SOFT;

    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentReferenceHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentReferenceHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = ConcurrentReferenceHashMap.this.get(entry.getKey());
            return v2 != null && v2.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentReferenceHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentReferenceHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class KeyIterator
    extends HashIterator
    implements Enumeration,
    Iterator {
        KeyIterator() {
        }

        public K next() {
            return super.nextEntry().key();
        }

        public K nextElement() {
            return super.nextEntry().key();
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class ValueIterator
    extends HashIterator
    implements Enumeration,
    Iterator {
        ValueIterator() {
        }

        public V next() {
            return super.nextEntry().value();
        }

        public V nextElement() {
            return super.nextEntry().value();
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class EntryIterator
    extends HashIterator
    implements Iterator {
        EntryIterator() {
        }

        public Map.Entry<K, V> next() {
            HashEntry hashEntry = super.nextEntry();
            return new WriteThroughEntry(hashEntry.key(), hashEntry.value());
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    final class WriteThroughEntry
    extends SimpleEntry<K, V> {
        WriteThroughEntry(K k2, V v2) {
            super(k2, v2);
        }

        @Override
        public V setValue(V v2) {
            if (v2 == null) {
                throw new NullPointerException();
            }
            Object v3 = super.setValue(v2);
            ConcurrentReferenceHashMap.this.put(this.getKey(), v2);
            return v3;
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        @HeapUsage.Deep
        private final K key;
        @HeapUsage.Deep
        private V value;

        SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return Objects.equals(object, object2);
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        @HeapUsage.Deep
        HashEntry<K, V>[] currentTable;
        @HeapUsage.Deep
        HashEntry<K, V> nextEntry;
        @HeapUsage.Deep
        HashEntry<K, V> lastReturned;
        @HeapUsage.Deep
        K currentKey;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentReferenceHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment;
                if ((segment = ConcurrentReferenceHashMap.this.segments[this.nextSegmentIndex--]).count() == 0) continue;
                this.currentTable = segment.table();
                for (int i2 = this.currentTable.length - 1; i2 >= 0; --i2) {
                    this.nextEntry = this.currentTable[i2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            while (this.nextEntry != null) {
                if (this.nextEntry.key() != null) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        HashEntry<K, V> nextEntry() {
            do {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                this.currentKey = this.lastReturned.key();
                this.advance();
            } while (this.currentKey == null);
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReferenceHashMap.this.remove(this.currentKey);
            this.lastReturned = null;
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling
    static final class HashEntry<K, V> {
        @HeapUsage.Deep
        final Object keyRef;
        final int hash;
        @HeapUsage.Deep
        volatile Object valueRef;
        @HeapUsage.Deep
        final HashEntry<K, V> next;

        HashEntry(K k2, int n2, HashEntry<K, V> hashEntry, V v2, ReferenceType referenceType, ReferenceType referenceType2, ReferenceQueue<Object> referenceQueue) {
            this.hash = n2;
            this.next = hashEntry;
            this.keyRef = this.newKeyReference(k2, referenceType, referenceQueue);
            this.valueRef = this.newValueReference(v2, referenceType2, referenceQueue);
        }

        Object newKeyReference(K k2, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new WeakKeyReference<K>(k2, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new b<K>(k2, this.hash, referenceQueue);
            }
            return k2;
        }

        Object newValueReference(V v2, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            if (referenceType == ReferenceType.WEAK) {
                return new d<V>(v2, this.keyRef, this.hash, referenceQueue);
            }
            if (referenceType == ReferenceType.SOFT) {
                return new c<V>(v2, this.keyRef, this.hash, referenceQueue);
            }
            return v2;
        }

        K key() {
            if (this.keyRef instanceof a) {
                return (K)((Reference)this.keyRef).get();
            }
            return (K)this.keyRef;
        }

        V value() {
            return this.dereferenceValue(this.valueRef);
        }

        V dereferenceValue(Object object) {
            if (object instanceof a) {
                return (V)((Reference)object).get();
            }
            return (V)object;
        }

        void setValue(V v2, ReferenceType referenceType, ReferenceQueue<Object> referenceQueue) {
            this.valueRef = this.newValueReference(v2, referenceType, referenceQueue);
        }

        static <K, V> HashEntry<K, V>[] newArray(int n2) {
            return new HashEntry[n2];
        }
    }

    @HeapUsage.SupportsHeapProfiling
    static final class c<V>
    extends SoftReference<V>
    implements a {
        @HeapUsage.Deep
        final Object a;
        final int b;

        c(V v2, Object object, int n2, ReferenceQueue<Object> referenceQueue) {
            super(v2, referenceQueue);
            this.a = object;
            this.b = n2;
        }

        @Override
        public int keyHash() {
            return this.b;
        }

        @Override
        public Object keyRef() {
            return this.a;
        }
    }

    @HeapUsage.SupportsHeapProfiling
    static final class d<V>
    extends WeakReference<V>
    implements a {
        @HeapUsage.Deep
        final Object a;
        final int b;

        d(V v2, Object object, int n2, ReferenceQueue<Object> referenceQueue) {
            super(v2, referenceQueue);
            this.a = object;
            this.b = n2;
        }

        @Override
        public int keyHash() {
            return this.b;
        }

        @Override
        public Object keyRef() {
            return this.a;
        }
    }

    @HeapUsage.SupportsHeapProfiling
    static final class b<K>
    extends SoftReference<K>
    implements a {
        final int a;

        b(K k2, int n2, ReferenceQueue<Object> referenceQueue) {
            super(k2, referenceQueue);
            this.a = n2;
        }

        @Override
        public int keyHash() {
            return this.a;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    @DontObfuscate
    @HeapUsage.SupportsHeapProfiling
    static final class WeakKeyReference<K>
    extends WeakReference<K>
    implements a {
        final int hash;

        WeakKeyReference(K k2, int n2, ReferenceQueue<Object> referenceQueue) {
            super(k2, referenceQueue);
            this.hash = n2;
        }

        @Override
        public int keyHash() {
            return this.hash;
        }

        @Override
        public Object keyRef() {
            return this;
        }
    }

    static interface a {
        public int keyHash();

        public Object keyRef();
    }
}

