/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.weakmap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.weakmap.AbstractMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
@HeapUsage.SupportsHeapProfiling
public class WeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    @HeapUsage.Deep
    private a[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    @HeapUsage.Deep
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    @HeapUsage.Deep
    private transient Set<Map.Entry<K, V>> entrySet;

    public WeakIdentityHashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.table = new a[n3];
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    public WeakIdentityHashMap(int n2) {
        this(n2, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new a[16];
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static <K> K unmaskNull(Object object) {
        return (K)(object == NULL_KEY ? null : object);
    }

    static boolean eq(Object object, Object object2) {
        return object == object2;
    }

    static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public void expungeStaleEntries() {
        a a2;
        block0: while ((a2 = (a)this.queue.poll()) != null) {
            a a3;
            int n2 = a2.b;
            int n3 = WeakIdentityHashMap.indexFor(n2, this.table.length);
            a a4 = a3 = this.table[n3];
            while (a4 != null) {
                a a5 = a4.c;
                if (a4 == a2) {
                    if (a3 == a2) {
                        this.table[n3] = a5;
                    } else {
                        a3.c = a5;
                    }
                    a2.c = null;
                    a2.a = null;
                    --this.size;
                    continue block0;
                }
                a3 = a4;
                a4 = a5;
            }
        }
    }

    private a[] getTable() {
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        int n3 = WeakIdentityHashMap.hash(n2);
        a[] aArray = this.getTable();
        int n4 = WeakIdentityHashMap.indexFor(n3, aArray.length);
        a a2 = aArray[n4];
        while (a2 != null) {
            if (a2.b == n3 && WeakIdentityHashMap.eq(object2, a2.get())) {
                return (V)a2.a;
            }
            a2 = a2.c;
        }
        return null;
    }

    static int hash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    a<K, V> getEntry(Object object) {
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        int n3 = WeakIdentityHashMap.hash(n2);
        a[] aArray = this.getTable();
        int n4 = WeakIdentityHashMap.indexFor(n3, aArray.length);
        a a2 = aArray[n4];
        while (!(a2 == null || a2.b == n3 && WeakIdentityHashMap.eq(object2, a2.get()))) {
            a2 = a2.c;
        }
        return a2;
    }

    @Override
    public V put(K k2, V v2) {
        Object object = WeakIdentityHashMap.maskNull(k2);
        int n2 = System.identityHashCode(object);
        int n3 = WeakIdentityHashMap.hash(n2);
        a[] aArray = this.getTable();
        int n4 = WeakIdentityHashMap.indexFor(n3, aArray.length);
        a a2 = aArray[n4];
        while (a2 != null) {
            if (n3 == a2.b && WeakIdentityHashMap.eq(object, a2.get())) {
                Object object2 = a2.a;
                if (v2 != object2) {
                    a2.a = v2;
                }
                return (V)object2;
            }
            a2 = a2.c;
        }
        ++this.modCount;
        a2 = aArray[n4];
        aArray[n4] = new a<Object, V>(object, v2, this.queue, n3, a2);
        if (++this.size >= this.threshold) {
            this.resize(aArray.length * 2);
        }
        return null;
    }

    void resize(int n2) {
        a[] aArray = this.getTable();
        int n3 = aArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        a[] aArray2 = new a[n2];
        this.transfer(aArray, aArray2);
        this.table = aArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(aArray2, aArray);
            this.table = aArray;
        }
    }

    private void transfer(a[] aArray, a[] aArray2) {
        for (int i2 = 0; i2 < aArray.length; ++i2) {
            a a2 = aArray[i2];
            aArray[i2] = null;
            while (a2 != null) {
                a a3 = a2.c;
                Object t2 = a2.get();
                if (t2 == null) {
                    a2.c = null;
                    a2.a = null;
                    --this.size;
                } else {
                    int n2 = WeakIdentityHashMap.indexFor(a2.b, aArray2.length);
                    a2.c = aArray2[n2];
                    aArray2[n2] = a2;
                }
                a2 = a3;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            int n3;
            int n4 = (int)((float)n2 / this.loadFactor + 1.0f);
            if (n4 > 0x40000000) {
                n4 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n4; n3 <<= 1) {
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        a a2;
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        int n3 = WeakIdentityHashMap.hash(n2);
        a[] aArray = this.getTable();
        int n4 = WeakIdentityHashMap.indexFor(n3, aArray.length);
        a a3 = a2 = aArray[n4];
        while (a3 != null) {
            a a4 = a3.c;
            if (n3 == a3.b && WeakIdentityHashMap.eq(object2, a3.get())) {
                ++this.modCount;
                --this.size;
                if (a2 == a3) {
                    aArray[n4] = a4;
                } else {
                    a2.c = a4;
                }
                return (V)a3.a;
            }
            a2 = a3;
            a3 = a4;
        }
        return null;
    }

    a<K, V> removeMapping(Object object) {
        a a2;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        a[] aArray = this.getTable();
        Map.Entry entry = (Map.Entry)object;
        Object object2 = WeakIdentityHashMap.maskNull(entry.getKey());
        int n2 = System.identityHashCode(object2);
        int n3 = WeakIdentityHashMap.hash(n2);
        int n4 = WeakIdentityHashMap.indexFor(n3, aArray.length);
        a a3 = a2 = aArray[n4];
        while (a3 != null) {
            a a4 = a3.c;
            if (n3 == a3.b && a3.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (a2 == a3) {
                    aArray[n4] = a4;
                } else {
                    a2.c = a4;
                }
                return a3;
            }
            a2 = a3;
            a3 = a4;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        a[] aArray = this.table;
        for (int i2 = 0; i2 < aArray.length; ++i2) {
            aArray[i2] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        a[] aArray = this.getTable();
        int n2 = aArray.length;
        while (n2-- > 0) {
            a a2 = aArray[n2];
            while (a2 != null) {
                if (object == a2.a) {
                    return true;
                }
                a2 = a2.c;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        a[] aArray = this.getTable();
        int n2 = aArray.length;
        while (n2-- > 0) {
            a a2 = aArray[n2];
            while (a2 != null) {
                if (a2.a == null) {
                    return true;
                }
                a2 = a2.c;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new f());
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new h());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        c c2 = this.entrySet;
        return c2 != null ? c2 : (this.entrySet = new c());
    }

    @HeapUsage.SupportsHeapProfiling
    private static class a<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        @HeapUsage.Deep
        private V a;
        private final int b;
        @HeapUsage.Deep
        private a<K, V> c;

        a(K k2, V v2, ReferenceQueue<K> referenceQueue, int n2, a<K, V> a2) {
            super(k2, referenceQueue);
            this.a = v2;
            this.b = n2;
            this.c = a2;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        private static <K> K a(Object object) {
            return (K)(object == NULL_KEY ? null : object);
        }

        @Override
        public V getValue() {
            return this.a;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.a;
            this.a = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v3;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k3 = this.getKey();
            return Objects.equals(k3, k2 = entry.getKey()) && (v3 = this.getValue()) == (v2 = entry.getValue());
        }

        @Override
        public int hashCode() {
            K k2 = this.getKey();
            V v2 = this.getValue();
            return (k2 == null ? 0 : k2.hashCode()) ^ (v2 == null ? 0 : v2.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class f
    extends AbstractSet<K> {
        private f() {
        }

        @Override
        public Iterator<K> iterator() {
            return new e();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakIdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (WeakIdentityHashMap.this.containsKey(object)) {
                WeakIdentityHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class h
    extends AbstractCollection<V> {
        private h() {
        }

        @Override
        public Iterator<V> iterator() {
            return new g();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakIdentityHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class c
    extends AbstractSet<Map.Entry<K, V>> {
        private c() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new b();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            a a2 = WeakIdentityHashMap.this.getEntry(entry.getKey());
            return a2 != null && a2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return WeakIdentityHashMap.this.removeMapping(object) != null;
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> a() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new AbstractMap.a(entry));
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            return this.a().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.a().toArray(TArray);
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class b
    extends d {
        private b() {
        }

        public Map.Entry<K, V> a() {
            return this.b();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.a();
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class e
    extends d {
        private e() {
        }

        @Override
        public K next() {
            return this.b().getKey();
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private class g
    extends d {
        private g() {
        }

        @Override
        public V next() {
            return this.b().a;
        }
    }

    @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.DEEP)
    private abstract class d<T>
    implements Iterator<T> {
        int b;
        @HeapUsage.Deep
        a<K, V> c;
        @HeapUsage.Deep
        a<K, V> d;
        int e;
        @HeapUsage.Deep
        Object f;
        @HeapUsage.Deep
        Object g;

        d() {
            this.e = WeakIdentityHashMap.this.modCount;
            this.b = WeakIdentityHashMap.this.size() != 0 ? WeakIdentityHashMap.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            a[] aArray = WeakIdentityHashMap.this.table;
            while (this.f == null) {
                a a2 = this.c;
                int n2 = this.b;
                while (a2 == null && n2 > 0) {
                    a2 = aArray[--n2];
                }
                this.c = a2;
                this.b = n2;
                if (a2 == null) {
                    this.g = null;
                    return false;
                }
                this.f = a2.get();
                if (this.f != null) continue;
                this.c = this.c.c;
            }
            return true;
        }

        protected a<K, V> b() {
            if (WeakIdentityHashMap.this.modCount != this.e) {
                throw new ConcurrentModificationException();
            }
            if (this.f == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.d = this.c;
            this.c = this.c.c;
            this.g = this.f;
            this.f = null;
            return this.d;
        }

        @Override
        public void remove() {
            if (this.d == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.e) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.g);
            this.e = WeakIdentityHashMap.this.modCount;
            this.d = null;
            this.g = null;
        }
    }
}

