/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.gson;

import com.contrastsecurity.thirdparty.cggl.gson.JsonParseException;
import com.contrastsecurity.thirdparty.cggl.gson.ToNumberStrategy;
import com.contrastsecurity.thirdparty.cggl.gson.internal.LazilyParsedNumber;
import com.contrastsecurity.thirdparty.cggl.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.cggl.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader jsonReader) throws IOException {
            return jsonReader.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader jsonReader) throws IOException {
            return new LazilyParsedNumber(jsonReader.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader jsonReader) throws IOException, JsonParseException {
            String string = jsonReader.nextString();
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double d2 = Double.valueOf(string);
                    if ((d2.isInfinite() || d2.isNaN()) && !jsonReader.isLenient()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + "; at path " + jsonReader.getPreviousPath());
                    }
                    return d2;
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException2);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader jsonReader) throws IOException {
            String string = jsonReader.nextString();
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }
    };

}

