/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.InputStream;
import java.util.Properties;

public class ClientVersion {
    private static final Logger LOGGER;
    private static final char[] VERSION_PROPERTY;
    public static final String VERSION;

    private static final String getVersionFromPropertyFile() throws Exception {
        InputStream inputStream = ClientVersion.class.getClassLoader().getResourceAsStream("com/contrastsecurity/thirdparty/rabbitmq-amqp-client.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        String string = new String(VERSION_PROPERTY);
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new IllegalStateException("Couldn't find version property in property file");
        }
        return string2;
    }

    private static final String getVersionFromPackage() {
        if (ClientVersion.class.getPackage().getImplementationVersion() == null) {
            throw new IllegalStateException("Couldn't get version with Package#getImplementationVersion");
        }
        return ClientVersion.class.getPackage().getImplementationVersion();
    }

    private static final String getDefaultVersion() {
        return "0.0.0";
    }

    static {
        String string;
        LOGGER = LoggerFactory.getLogger(ClientVersion.class);
        VERSION_PROPERTY = new char[]{'c', 'o', 'm', '.', 'r', 'a', 'b', 'b', 'i', 't', 'm', 'q', '.', 'c', 'l', 'i', 'e', 'n', 't', '.', 'v', 'e', 'r', 's', 'i', 'o', 'n'};
        try {
            string = ClientVersion.getVersionFromPropertyFile();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Couldn't get version from property file", exception2);
            try {
                string = ClientVersion.getVersionFromPackage();
            }
            catch (Exception exception3) {
                Throwables.throwIfCritical(exception3);
                Exception exception4 = exception3;
                LOGGER.warn("Couldn't get version with Package#getImplementationVersion", exception2);
                string = ClientVersion.getDefaultVersion();
            }
        }
        VERSION = string;
    }
}

