/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.UnexpectedFrameError;
import com.contrastsecurity.thirdparty.crmq.client.impl.AMQContentHeader;
import com.contrastsecurity.thirdparty.crmq.client.impl.AMQImpl;
import com.contrastsecurity.thirdparty.crmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.crmq.client.impl.Method;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class CommandAssembler {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private CAState state;
    private Method method;
    private AMQContentHeader contentHeader;
    private final List<byte[]> bodyN;
    private int bodyLength;
    private long remainingBodyBytes;

    public CommandAssembler(Method method, AMQContentHeader aMQContentHeader, byte[] byArray) {
        this.method = method;
        this.contentHeader = aMQContentHeader;
        this.bodyN = new ArrayList<byte[]>(2);
        this.bodyLength = 0;
        this.remainingBodyBytes = 0L;
        this.appendBodyFragment(byArray);
        if (method == null) {
            this.state = CAState.EXPECTING_METHOD;
        } else if (aMQContentHeader == null) {
            this.state = method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
        } else {
            this.remainingBodyBytes = aMQContentHeader.getBodySize() - (long)this.bodyLength;
            this.updateContentBodyState();
        }
    }

    public synchronized Method getMethod() {
        return this.method;
    }

    public synchronized AMQContentHeader getContentHeader() {
        return this.contentHeader;
    }

    public synchronized boolean isComplete() {
        return this.state == CAState.COMPLETE;
    }

    private void updateContentBodyState() {
        this.state = this.remainingBodyBytes > 0L ? CAState.EXPECTING_CONTENT_BODY : CAState.COMPLETE;
    }

    private void consumeMethodFrame(Frame frame) throws IOException {
        if (frame.type != 1) {
            throw new UnexpectedFrameError(frame, 1);
        }
        this.method = AMQImpl.readMethodFrom(frame.getInputStream());
        this.state = this.method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
    }

    private void consumeHeaderFrame(Frame frame) throws IOException {
        if (frame.type != 2) {
            throw new UnexpectedFrameError(frame, 2);
        }
        this.contentHeader = AMQImpl.readContentHeaderFrom(frame.getInputStream());
        this.remainingBodyBytes = this.contentHeader.getBodySize();
        this.updateContentBodyState();
    }

    private void consumeBodyFrame(Frame frame) {
        byte[] byArray;
        if (frame.type == 3) {
            byArray = frame.getPayload();
            this.remainingBodyBytes -= (long)byArray.length;
            this.updateContentBodyState();
            if (this.remainingBodyBytes < 0L) {
                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
            }
        } else {
            throw new UnexpectedFrameError(frame, 3);
        }
        this.appendBodyFragment(byArray);
    }

    private byte[] coalesceContentBody() {
        if (this.bodyLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (this.bodyN.size() == 1) {
            return this.bodyN.get(0);
        }
        byte[] byArray = new byte[this.bodyLength];
        int n2 = 0;
        for (byte[] byArray2 : this.bodyN) {
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        this.bodyN.clear();
        this.bodyN.add(byArray);
        return byArray;
    }

    public synchronized byte[] getContentBody() {
        return this.coalesceContentBody();
    }

    private void appendBodyFragment(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.bodyN.add(byArray);
        this.bodyLength += byArray.length;
    }

    public synchronized boolean handleFrame(Frame frame) throws IOException {
        switch (this.state) {
            case EXPECTING_METHOD: {
                this.consumeMethodFrame(frame);
                break;
            }
            case EXPECTING_CONTENT_HEADER: {
                this.consumeHeaderFrame(frame);
                break;
            }
            case EXPECTING_CONTENT_BODY: {
                this.consumeBodyFrame(frame);
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad Command State " + (Object)((Object)this.state)));
            }
        }
        return this.isComplete();
    }

    private static enum CAState {
        EXPECTING_METHOD,
        EXPECTING_CONTENT_HEADER,
        EXPECTING_CONTENT_BODY,
        COMPLETE;

    }
}

