/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.tools.jsonrpc;

import com.contrastsecurity.thirdparty.crmq.tools.json.JSONUtil;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ParameterDescription;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class ProcedureDescription {
    public String name;
    public String summary;
    public String help;
    public boolean idempotent;
    private ParameterDescription[] params;
    private String returnType;
    private String javaReturnType;
    private Class<?> _javaReturnTypeAsClass;
    private Method method;

    public ProcedureDescription(Map<String, Object> map) {
        JSONUtil.tryFill(this, map);
        List list = (List)map.get("params");
        this.params = new ParameterDescription[list.size()];
        int n2 = 0;
        for (Map map2 : list) {
            ParameterDescription parameterDescription = new ParameterDescription(map2);
            this.params[n2++] = parameterDescription;
        }
    }

    public ProcedureDescription(Method method) {
        this.method = method;
        this.name = method.getName();
        this.summary = "";
        this.help = "";
        this.idempotent = false;
        Class<?>[] classArray = method.getParameterTypes();
        this.params = new ParameterDescription[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            this.params[i2] = new ParameterDescription(i2, classArray[i2]);
        }
        this.returnType = ParameterDescription.lookup(method.getReturnType());
        this.javaReturnType = method.getReturnType().getName();
    }

    public ProcedureDescription() {
    }

    public String getReturn() {
        return this.returnType;
    }

    public void setReturn(String string) {
        this.returnType = string;
    }

    public Method internal_getMethod() {
        return this.method;
    }

    public String getJavaReturnType() {
        return this.javaReturnType;
    }

    public void setJavaReturnType(String string) {
        this.javaReturnType = string;
        this._javaReturnTypeAsClass = this.computeReturnTypeAsJavaClass();
    }

    public Class<?> getReturnType() {
        return this._javaReturnTypeAsClass;
    }

    private Class<?> computeReturnTypeAsJavaClass() {
        try {
            if ("int".equals(this.javaReturnType)) {
                return Integer.TYPE;
            }
            if ("double".equals(this.javaReturnType)) {
                return Double.TYPE;
            }
            if ("long".equals(this.javaReturnType)) {
                return Long.TYPE;
            }
            if ("boolean".equals(this.javaReturnType)) {
                return Boolean.TYPE;
            }
            if ("char".equals(this.javaReturnType)) {
                return Character.TYPE;
            }
            if ("byte".equals(this.javaReturnType)) {
                return Byte.TYPE;
            }
            if ("short".equals(this.javaReturnType)) {
                return Short.TYPE;
            }
            if ("float".equals(this.javaReturnType)) {
                return Float.TYPE;
            }
            if ("void".equals(this.javaReturnType)) {
                return Void.TYPE;
            }
            return Class.forName(this.javaReturnType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to load class: " + this.javaReturnType, classNotFoundException);
        }
    }

    public ParameterDescription[] internal_getParams() {
        return this.params;
    }

    public int arity() {
        return this.params == null ? 0 : this.params.length;
    }

    public ParameterDescription[] getParams() {
        return this.params;
    }
}

