/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.db4j.automaton;

import com.contrastsecurity.thirdparty.db4j.automaton.Automaton;
import com.contrastsecurity.thirdparty.db4j.automaton.BasicOperations;
import com.contrastsecurity.thirdparty.db4j.automaton.SpecialOperations;
import com.contrastsecurity.thirdparty.db4j.automaton.State;
import com.contrastsecurity.thirdparty.db4j.automaton.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton automaton) {
        if (!automaton.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(automaton);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(automaton);
                    break;
                }
                case 3: {
                    MinimizationOperations.minimizeValmari(automaton);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(automaton);
                }
            }
        }
        automaton.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitionArray, boolean[][] blArray, int n2, int n3) {
        Transition[] transitionArray2 = transitionArray[n2];
        Transition[] transitionArray3 = transitionArray[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < transitionArray2.length && n5 < transitionArray3.length) {
            if (transitionArray2[n4].max < transitionArray3[n5].min) {
                ++n4;
                continue;
            }
            if (transitionArray3[n5].max < transitionArray2[n4].min) {
                ++n5;
                continue;
            }
            int n6 = transitionArray2[n4].to.number;
            int n7 = transitionArray3[n5].to.number;
            if (n6 > n7) {
                int n8 = n6;
                n6 = n7;
                n7 = n8;
            }
            if (blArray[n6][n7]) {
                return false;
            }
            if (transitionArray2[n4].max < transitionArray3[n5].max) {
                ++n4;
                continue;
            }
            ++n5;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitionArray, ArrayList<ArrayList<HashSet<IntPair>>> arrayList, int n2, int n3) {
        Transition[] transitionArray2 = transitionArray[n2];
        Transition[] transitionArray3 = transitionArray[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < transitionArray2.length && n5 < transitionArray3.length) {
            if (transitionArray2[n4].max < transitionArray3[n5].min) {
                ++n4;
                continue;
            }
            if (transitionArray3[n5].max < transitionArray2[n4].min) {
                ++n5;
                continue;
            }
            if (transitionArray2[n4].to != transitionArray3[n5].to) {
                int n6 = transitionArray2[n4].to.number;
                int n7 = transitionArray3[n5].to.number;
                if (n6 > n7) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                }
                if (arrayList.get(n6).get(n7) == null) {
                    arrayList.get(n6).set(n7, new HashSet());
                }
                arrayList.get(n6).get(n7).add(new IntPair(n2, n3));
            }
            if (transitionArray2[n4].max < transitionArray3[n5].max) {
                ++n4;
                continue;
            }
            ++n5;
        }
    }

    private static void markPair(boolean[][] blArray, ArrayList<ArrayList<HashSet<IntPair>>> arrayList, int n2, int n3) {
        blArray[n2][n3] = true;
        if (arrayList.get(n2).get(n3) != null) {
            for (IntPair intPair : arrayList.get(n2).get(n3)) {
                int n4 = intPair.n1;
                int n5 = intPair.n2;
                if (n4 > n5) {
                    int n6 = n4;
                    n4 = n5;
                    n5 = n6;
                }
                if (blArray[n4][n5]) continue;
                MinimizationOperations.markPair(blArray, arrayList, n4, n5);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> arrayList, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(null);
        }
    }

    public static void minimizeHuffman(Automaton automaton) {
        int n2;
        int n3;
        int n4;
        automaton.determinize();
        automaton.totalize();
        Set<State> set = automaton.getStates();
        Transition[][] transitionArray = new Transition[set.size()][];
        State[] stateArray = set.toArray(new State[set.size()]);
        boolean[][] blArray = new boolean[stateArray.length][stateArray.length];
        ArrayList<ArrayList<HashSet<IntPair>>> arrayList = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n4 = 0; n4 < stateArray.length; ++n4) {
            ArrayList arrayList2 = new ArrayList();
            MinimizationOperations.initialize(arrayList2, stateArray.length);
            arrayList.add(arrayList2);
        }
        for (n4 = 0; n4 < stateArray.length; ++n4) {
            stateArray[n4].number = n4;
            transitionArray[n4] = stateArray[n4].getSortedTransitionArray(false);
            for (int i2 = n4 + 1; i2 < stateArray.length; ++i2) {
                if (stateArray[n4].accept == stateArray[i2].accept) continue;
                blArray[n4][i2] = true;
            }
        }
        for (n4 = 0; n4 < stateArray.length; ++n4) {
            for (int i3 = n4 + 1; i3 < stateArray.length; ++i3) {
                if (blArray[n4][i3]) continue;
                if (MinimizationOperations.statesAgree(transitionArray, blArray, n4, i3)) {
                    MinimizationOperations.addTriggers(transitionArray, arrayList, n4, i3);
                    continue;
                }
                MinimizationOperations.markPair(blArray, arrayList, n4, i3);
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            stateArray[n3].number = -1;
        }
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            if (stateArray[n3].number != -1) continue;
            stateArray[n3].number = n4;
            for (n2 = n3 + 1; n2 < stateArray.length; ++n2) {
                if (blArray[n3][n2]) continue;
                stateArray[n2].number = n4;
            }
            ++n4;
        }
        State[] stateArray2 = new State[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            stateArray2[n2] = new State();
        }
        for (n2 = 0; n2 < stateArray.length; ++n2) {
            stateArray2[stateArray[n2].number].number = n2;
            if (stateArray[n2] != automaton.initial) continue;
            automaton.initial = stateArray2[stateArray[n2].number];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            State state = stateArray2[n2];
            state.accept = stateArray[state.number].accept;
            for (Transition transition : stateArray[state.number].transitions) {
                state.transitions.add(new Transition(transition.min, transition.max, stateArray2[transition.to.number]));
            }
        }
        automaton.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton automaton) {
        if (automaton.isSingleton()) {
            return;
        }
        BasicOperations.determinize(automaton, SpecialOperations.reverse(automaton));
        BasicOperations.determinize(automaton, SpecialOperations.reverse(automaton));
    }

    public static void minimizeHopcroft(Automaton automaton) {
        int n2;
        int n3;
        int n4;
        ArrayList arrayList;
        Serializable serializable;
        Object object;
        automaton.determinize();
        Set<Transition> set = automaton.initial.getTransitions();
        if (set.size() == 1) {
            object = set.iterator().next();
            if (((Transition)object).to == automaton.initial && ((Transition)object).min == '\u0000' && ((Transition)object).max == '\uffff') {
                return;
            }
        }
        automaton.totalize();
        object = automaton.getStates();
        State[] stateArray = new State[object.size()];
        int n5 = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            serializable = (State)object2.next();
            stateArray[n5] = serializable;
            ((State)serializable).number = n5++;
        }
        object2 = automaton.getStartPoints();
        serializable = new ArrayList();
        for (int i2 = 0; i2 < stateArray.length; ++i2) {
            arrayList = new ArrayList();
            MinimizationOperations.initialize(arrayList, ((Object)object2).length);
            ((ArrayList)serializable).add(arrayList);
        }
        boolean[][] blArray = new boolean[stateArray.length][((Object)object2).length];
        arrayList = new ArrayList();
        MinimizationOperations.initialize(arrayList, stateArray.length);
        int[] nArray = new int[stateArray.length];
        StateList[][] stateListArray = new StateList[stateArray.length][((Object)object2).length];
        StateListNode[][] stateListNodeArray = new StateListNode[stateArray.length][((Object)object2).length];
        LinkedList<IntPair> linkedList = new LinkedList<IntPair>();
        boolean[][] blArray2 = new boolean[((Object)object2).length][stateArray.length];
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean[] blArray3 = new boolean[stateArray.length];
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        boolean[] blArray4 = new boolean[stateArray.length];
        ArrayList arrayList4 = new ArrayList();
        MinimizationOperations.initialize(arrayList4, stateArray.length);
        for (n4 = 0; n4 < stateArray.length; ++n4) {
            arrayList4.set(n4, new ArrayList());
            arrayList.set(n4, new LinkedList());
            for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
                ((ArrayList)((ArrayList)serializable).get(n4)).set(i3, new LinkedList());
                stateListArray[n4][i3] = new StateList();
            }
        }
        for (n4 = 0; n4 < stateArray.length; ++n4) {
            State state = stateArray[n4];
            int n6 = state.accept ? 0 : 1;
            ((LinkedList)arrayList.get(n6)).add(state);
            nArray[state.number] = n6;
            for (int i4 = 0; i4 < ((Object)object2).length; ++i4) {
                Object object3 = object2[i4];
                State state2 = state.step((char)object3);
                ((LinkedList)((ArrayList)((ArrayList)serializable).get(state2.number)).get(i4)).add(state);
                blArray[state2.number][i4] = true;
            }
        }
        for (n4 = 0; n4 <= 1; ++n4) {
            for (int i5 = 0; i5 < ((Object)object2).length; ++i5) {
                for (State state : (LinkedList)arrayList.get(n4)) {
                    if (!blArray[state.number][i5]) continue;
                    stateListNodeArray[state.number][i5] = stateListArray[n4][i5].add(state);
                }
            }
        }
        for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
            int n7 = stateListArray[0][n4].size;
            int n8 = stateListArray[1][n4].size;
            n3 = n7 <= n8 ? 0 : 1;
            linkedList.add(new IntPair(n3, n4));
            blArray2[n4][n3] = true;
        }
        n4 = 2;
        while (!linkedList.isEmpty()) {
            IntPair intPair = (IntPair)linkedList.removeFirst();
            int n9 = intPair.n1;
            n3 = intPair.n2;
            blArray2[n3][n9] = false;
            Object object4 = stateListArray[n9][n3].first;
            while (object4 != null) {
                for (Object object5 : (LinkedList)((ArrayList)((ArrayList)serializable).get(((StateListNode)object4).q.number)).get(n3)) {
                    if (blArray3[((State)object5).number]) continue;
                    blArray3[((State)object5).number] = true;
                    arrayList2.add(object5);
                    int n10 = nArray[((State)object5).number];
                    ((ArrayList)arrayList4.get(n10)).add(object5);
                    if (blArray4[n10]) continue;
                    blArray4[n10] = true;
                    arrayList3.add(n10);
                }
                object4 = ((StateListNode)object4).next;
            }
            object4 = arrayList3.iterator();
            while (object4.hasNext()) {
                Object object5;
                int n11 = (Integer)object4.next();
                if (((ArrayList)arrayList4.get(n11)).size() < ((LinkedList)arrayList.get(n11)).size()) {
                    int n12;
                    object5 = (LinkedList)arrayList.get(n11);
                    LinkedList linkedList2 = (LinkedList)arrayList.get(n4);
                    for (State state : (ArrayList)arrayList4.get(n11)) {
                        ((LinkedList)object5).remove(state);
                        linkedList2.add(state);
                        nArray[state.number] = n4;
                        for (n12 = 0; n12 < ((Object)object2).length; ++n12) {
                            StateListNode stateListNode = stateListNodeArray[state.number][n12];
                            if (stateListNode == null || stateListNode.sl != stateListArray[n11][n12]) continue;
                            stateListNode.remove();
                            stateListNodeArray[state.number][n12] = stateListArray[n4][n12].add(state);
                        }
                    }
                    for (int i6 = 0; i6 < ((Object)object2).length; ++i6) {
                        int n13 = stateListArray[n11][i6].size;
                        n12 = stateListArray[n4][i6].size;
                        if (!blArray2[i6][n11] && 0 < n13 && n13 <= n12) {
                            blArray2[i6][n11] = true;
                            linkedList.add(new IntPair(n11, i6));
                            continue;
                        }
                        blArray2[i6][n4] = true;
                        linkedList.add(new IntPair(n4, i6));
                    }
                    ++n4;
                }
                object5 = ((ArrayList)arrayList4.get(n11)).iterator();
                while (object5.hasNext()) {
                    State state = (State)object5.next();
                    blArray3[state.number] = false;
                }
                blArray4[n11] = false;
                ((ArrayList)arrayList4.get(n11)).clear();
            }
            arrayList2.clear();
            arrayList3.clear();
        }
        State[] stateArray2 = new State[n4];
        for (n2 = 0; n2 < stateArray2.length; ++n2) {
            State state;
            stateArray2[n2] = state = new State();
            for (State state3 : (LinkedList)arrayList.get(n2)) {
                if (state3 == automaton.initial) {
                    automaton.initial = state;
                }
                state.accept = state3.accept;
                state.number = state3.number;
                state3.number = n2;
            }
        }
        for (n2 = 0; n2 < stateArray2.length; ++n2) {
            State state = stateArray2[n2];
            state.accept = stateArray[state.number].accept;
            for (Transition transition : stateArray[state.number].transitions) {
                state.transitions.add(new Transition(transition.min, transition.max, stateArray2[transition.to.number]));
            }
        }
        automaton.removeDeadTransitions();
    }

    public static void minimizeValmari(Automaton automaton) {
        int n2;
        Object object;
        automaton.determinize();
        Set<State> set = automaton.getStates();
        MinimizationOperations.splitTransitions(set);
        int n3 = set.size();
        int n4 = automaton.getNumberOfTransitions();
        Set<State> set2 = automaton.getAcceptStates();
        Partition partition = new Partition(n3);
        Partition partition2 = new Partition(n4);
        IntPair[] intPairArray = new IntPair[n4];
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        Automaton.setStateNumbers(set);
        int n5 = 0;
        for (State state : automaton.getStates()) {
            for (Transition transition : state.getTransitions()) {
                nArray[n5] = state.number;
                intPairArray[n5] = new IntPair(transition.min, transition.max);
                nArray2[n5] = transition.getDest().number;
                ++n5;
            }
        }
        for (State state : set2) {
            partition.mark(state.number);
        }
        partition.split();
        if (n4 > 0) {
            Arrays.sort(partition2.elements, new LabelComparator(intPairArray));
            partition2.markedElementCount[0] = 0;
            partition2.setCount = 0;
            object = intPairArray[partition2.elements[0]];
            int n6 = 0;
            while (n6 < n4) {
                int n7 = partition2.elements[n6];
                if (intPairArray[n7].n1 != ((IntPair)object).n1 || intPairArray[n7].n2 != ((IntPair)object).n2) {
                    object = intPairArray[n7];
                    partition2.past[partition2.setCount++] = n6;
                    partition2.first[partition2.setCount] = n6;
                    partition2.markedElementCount[partition2.setCount] = 0;
                }
                partition2.setNo[n7] = partition2.setCount;
                partition2.locations[n7] = n6++;
            }
            partition2.past[partition2.setCount++] = n4;
        }
        object = new int[n4];
        int[] nArray3 = new int[n3 + 1];
        MinimizationOperations.makeAdjacent((int[])object, nArray3, nArray2, n3, n4);
        for (int i2 = 0; i2 < partition2.setCount; ++i2) {
            int n8;
            for (n8 = partition2.first[i2]; n8 < partition2.past[i2]; ++n8) {
                partition.mark(nArray[partition2.elements[n8]]);
            }
            partition.split();
            for (n8 = 1; n8 < partition.setCount; ++n8) {
                for (int i3 = partition.first[n8]; i3 < partition.past[n8]; ++i3) {
                    for (int i4 = nArray3[partition.elements[i3]]; i4 < nArray3[partition.elements[i3] + 1]; ++i4) {
                        partition2.mark((int)object[i4]);
                    }
                }
                partition2.split();
            }
        }
        State[] stateArray = new State[partition.setCount];
        for (n2 = 0; n2 < partition.setCount; ++n2) {
            stateArray[n2] = new State();
            if (partition.first[n2] >= set2.size()) continue;
            stateArray[n2].accept = true;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (partition.locations[nArray[n2]] != partition.first[partition.setNo[nArray[n2]]]) continue;
            State state = stateArray[partition.setNo[nArray[n2]]];
            State state2 = stateArray[partition.setNo[nArray2[n2]]];
            state.addTransition(new Transition((char)intPairArray[n2].n1, (char)intPairArray[n2].n2, state2));
        }
        automaton.setInitialState(stateArray[partition.setNo[automaton.getInitialState().number]]);
        automaton.reduce();
    }

    private static void makeAdjacent(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 <= n2; ++n4) {
            nArray2[n4] = 0;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = nArray3[n4];
            nArray2[n5] = nArray2[n5] + 1;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n6 = n4 + 1;
            nArray2[n6] = nArray2[n6] + nArray2[n4];
        }
        n4 = n3;
        while (n4-- > 0) {
            int n7 = nArray3[n4];
            int n8 = nArray2[n7] - 1;
            nArray2[n7] = n8;
            nArray[n8] = n4;
        }
    }

    private static void splitTransitions(Set<State> set) {
        TreeSet<Character> treeSet = new TreeSet<Character>();
        for (State state : set) {
            for (Transition object : state.getTransitions()) {
                treeSet.add(Character.valueOf(object.min));
                treeSet.add(Character.valueOf(object.max));
            }
        }
        for (State state : set) {
            Set<Transition> set2 = state.getTransitions();
            state.resetTransitions();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Transition transition = (Transition)iterator.next();
                if (transition.min == transition.max) {
                    state.addTransition(transition);
                    continue;
                }
                NavigableSet<Character> navigableSet = treeSet.headSet(Character.valueOf(transition.max), true);
                NavigableSet<Character> navigableSet2 = treeSet.tailSet(Character.valueOf(transition.min), false);
                TreeSet<Character> treeSet2 = new TreeSet<Character>((SortedSet<Character>)navigableSet);
                treeSet2.retainAll(navigableSet2);
                char c2 = transition.min;
                for (Character c3 : treeSet2) {
                    state.addTransition(new Transition(c2, transition.to));
                    state.addTransition(new Transition(c3.charValue(), transition.to));
                    if (c3.charValue() - c2 > 1) {
                        state.addTransition(new Transition((char)(c2 + '\u0001'), (char)(c3.charValue() - '\u0001'), transition.to));
                    }
                    c2 = c3.charValue();
                }
            }
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n2, int n3) {
            this.n1 = n2;
            this.n2 = n3;
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State state) {
            return new StateListNode(state, this);
        }
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State state, StateList stateList) {
            this.q = state;
            this.sl = stateList;
            if (stateList.size++ == 0) {
                stateList.first = stateList.last = this;
            } else {
                stateList.last.next = this;
                this.prev = stateList.last;
                stateList.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static class Partition {
        int[] markedElementCount;
        int[] touchedSets;
        int touchedSetCount;
        int setCount;
        Integer[] elements;
        int[] locations;
        int[] setNo;
        int[] first;
        int[] past;

        Partition(int n2) {
            this.setCount = n2 == 0 ? 0 : 1;
            this.elements = new Integer[n2];
            this.locations = new int[n2];
            this.setNo = new int[n2];
            this.first = new int[n2];
            this.past = new int[n2];
            this.markedElementCount = new int[n2];
            this.touchedSets = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.locations[i2] = i2;
                this.elements[i2] = this.locations[i2];
                this.setNo[i2] = 0;
            }
            if (this.setCount != 0) {
                this.first[0] = 0;
                this.past[0] = n2;
            }
        }

        void mark(int n2) {
            int n3 = this.setNo[n2];
            int n4 = this.locations[n2];
            int n5 = this.first[n3] + this.markedElementCount[n3];
            this.elements[n4] = this.elements[n5];
            this.locations[this.elements[n4].intValue()] = n4;
            this.elements[n5] = n2;
            this.locations[n2] = n5;
            int n6 = n3;
            int n7 = this.markedElementCount[n6];
            this.markedElementCount[n6] = n7 + 1;
            if (n7 == 0) {
                this.touchedSets[this.touchedSetCount++] = n3;
            }
        }

        void split() {
            while (this.touchedSetCount > 0) {
                int n2;
                int n3;
                if ((n3 = this.first[n2 = this.touchedSets[--this.touchedSetCount]] + this.markedElementCount[n2]) == this.past[n2]) {
                    this.markedElementCount[n2] = 0;
                    continue;
                }
                if (this.markedElementCount[n2] <= this.past[n2] - n3) {
                    this.first[this.setCount] = this.first[n2];
                    this.past[this.setCount] = this.first[n2] = n3;
                } else {
                    this.past[this.setCount] = this.past[n2];
                    this.first[this.setCount] = this.past[n2] = n3;
                }
                for (int i2 = this.first[this.setCount]; i2 < this.past[this.setCount]; ++i2) {
                    this.setNo[this.elements[i2].intValue()] = this.setCount;
                }
                this.markedElementCount[this.setCount++] = 0;
                this.markedElementCount[n2] = 0;
            }
        }
    }

    static class LabelComparator
    implements Comparator<Integer> {
        private IntPair[] labels;

        LabelComparator(IntPair[] intPairArray) {
            this.labels = intPairArray;
        }

        @Override
        public int compare(Integer n2, Integer n3) {
            IntPair intPair = this.labels[n2];
            IntPair intPair2 = this.labels[n3];
            if (intPair.n1 < intPair2.n1) {
                return -1;
            }
            if (intPair.n1 > intPair2.n1) {
                return 1;
            }
            if (intPair.n2 < intPair2.n2) {
                return -1;
            }
            if (intPair.n2 > intPair2.n2) {
                return 1;
            }
            return 0;
        }
    }
}

