/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.common.annotation;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.KeyValue;
import com.contrastsecurity.thirdparty.imm.common.annotation.AnnotatedParameter;
import com.contrastsecurity.thirdparty.imm.common.annotation.AnnotationUtils;
import com.contrastsecurity.thirdparty.imm.common.annotation.ValueExpressionResolver;
import com.contrastsecurity.thirdparty.imm.common.annotation.ValueResolver;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class AnnotationHandler<T> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(AnnotationHandler.class);
    private final BiConsumer<KeyValue, T> keyValueConsumer;
    private final Function<Class<? extends ValueResolver>, ? extends ValueResolver> resolverProvider;
    private final Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> expressionResolverProvider;
    private final Class<? extends Annotation> annotationClass;
    private final BiFunction<Annotation, Object, KeyValue> toKeyValue;

    public AnnotationHandler(BiConsumer<KeyValue, T> biConsumer, Function<Class<? extends ValueResolver>, ? extends ValueResolver> function, Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> function2, Class<? extends Annotation> clazz, BiFunction<Annotation, Object, KeyValue> biFunction) {
        this.keyValueConsumer = biConsumer;
        this.resolverProvider = function;
        this.expressionResolverProvider = function2;
        this.annotationClass = clazz;
        this.toKeyValue = biFunction;
    }

    public void addAnnotatedParameters(T t2, ProceedingJoinPoint proceedingJoinPoint) {
        try {
            Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
            method = proceedingJoinPoint.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            List<AnnotatedParameter> list = AnnotationUtils.findAnnotatedParameters(this.annotationClass, method, proceedingJoinPoint.getArgs());
            this.getAnnotationsFromInterfaces(proceedingJoinPoint, method, list);
            this.addAnnotatedArguments(t2, list);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            log.error("Exception occurred while trying to add annotated parameters", exception2);
        }
    }

    private void getAnnotationsFromInterfaces(ProceedingJoinPoint proceedingJoinPoint, Method method, List<AnnotatedParameter> list) {
        Class<?>[] classArray;
        for (Class<?> clazz : classArray = proceedingJoinPoint.getThis().getClass().getInterfaces()) {
            for (Method method2 : clazz.getMethods()) {
                if (!this.methodsAreTheSame(method, method2)) continue;
                List<AnnotatedParameter> list2 = AnnotationUtils.findAnnotatedParameters(this.annotationClass, method2, proceedingJoinPoint.getArgs());
                this.mergeAnnotatedParameters(list, list2);
            }
        }
    }

    private boolean methodsAreTheSame(Method method, Method method2) {
        return method2.getName().equals(method.getName()) && Arrays.equals(method2.getParameterTypes(), method.getParameterTypes());
    }

    private void mergeAnnotatedParameters(List<AnnotatedParameter> list, List<AnnotatedParameter> list2) {
        for (AnnotatedParameter annotatedParameter : list2) {
            int n2 = annotatedParameter.parameterIndex;
            boolean bl2 = false;
            for (AnnotatedParameter annotatedParameter2 : list) {
                if (annotatedParameter2.parameterIndex != n2) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            list.add(annotatedParameter);
        }
    }

    private void addAnnotatedArguments(T t2, List<AnnotatedParameter> list) {
        for (AnnotatedParameter annotatedParameter : list) {
            KeyValue keyValue = this.toKeyValue.apply(annotatedParameter.annotation, annotatedParameter.argument);
            this.keyValueConsumer.accept(keyValue, (KeyValue)t2);
        }
    }

    public Function<Class<? extends ValueResolver>, ? extends ValueResolver> getResolverProvider() {
        return this.resolverProvider;
    }

    public Function<Class<? extends ValueExpressionResolver>, ? extends ValueExpressionResolver> getExpressionResolverProvider() {
        return this.expressionResolverProvider;
    }
}

