/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.NoopHistogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowPercentileHistogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.ClockDriftPauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.NoPauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.olu.IntervalEstimator;
import com.contrastsecurity.thirdparty.olu.SimplePauseDetector;
import com.contrastsecurity.thirdparty.olu.TimeCappedMovingAverageIntervalEstimator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public abstract class AbstractTimer
extends AbstractMeter
implements Timer {
    private static final Map<PauseDetector, Object> pauseDetectorCache = new ConcurrentHashMap<PauseDetector, Object>();
    protected final Clock clock;
    protected final Histogram histogram;
    private final TimeUnit baseTimeUnit;
    @Nullable
    private Object intervalEstimator;
    @Nullable
    private com.contrastsecurity.thirdparty.olu.PauseDetector pauseDetector;

    @Deprecated
    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit) {
        this(id, clock, distributionStatisticConfig, pauseDetector, timeUnit, false);
    }

    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, boolean bl2) {
        this(id, clock, pauseDetector, timeUnit, AbstractTimer.defaultHistogram(clock, distributionStatisticConfig, bl2));
    }

    protected AbstractTimer(Meter.Id id, Clock clock, PauseDetector pauseDetector, TimeUnit timeUnit, Histogram histogram) {
        super(id);
        this.clock = clock;
        this.baseTimeUnit = timeUnit;
        this.initPauseDetector(pauseDetector);
        this.histogram = histogram;
    }

    protected static Histogram defaultHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl2) {
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, bl2);
        }
        if (distributionStatisticConfig.isPublishingHistogram()) {
            return new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, bl2);
        }
        return NoopHistogram.INSTANCE;
    }

    private void initPauseDetector(PauseDetector pauseDetector2) {
        if (pauseDetector2 instanceof NoPauseDetector) {
            return;
        }
        this.pauseDetector = (com.contrastsecurity.thirdparty.olu.PauseDetector)pauseDetectorCache.computeIfAbsent(pauseDetector2, pauseDetector -> {
            if (pauseDetector instanceof ClockDriftPauseDetector) {
                ClockDriftPauseDetector clockDriftPauseDetector = (ClockDriftPauseDetector)pauseDetector;
                return new SimplePauseDetector(clockDriftPauseDetector.getSleepInterval().toNanos(), clockDriftPauseDetector.getPauseThreshold().toNanos(), 1, false);
            }
            return null;
        });
        if (this.pauseDetector instanceof SimplePauseDetector) {
            this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(128, 10000000000L, this.pauseDetector);
            this.pauseDetector.addListener((l2, l3) -> {
                long l4;
                long l5;
                if (this.intervalEstimator != null && (l5 = l2 - (l4 = ((IntervalEstimator)this.intervalEstimator).getEstimatedInterval(l3))) >= l4) {
                    this.recordValueWithExpectedInterval(l5, l4);
                }
            });
        }
    }

    private void recordValueWithExpectedInterval(long l2, long l3) {
        this.record(l2, TimeUnit.NANOSECONDS);
        if (l3 <= 0L) {
            return;
        }
        for (long i2 = l2 - l3; i2 >= l3; i2 -= l3) {
            this.record(i2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> callable) throws Exception {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> supplier) {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean record(BooleanSupplier booleanSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            boolean bl2 = booleanSupplier.getAsBoolean();
            return bl2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int record(IntSupplier intSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            int n2 = intSupplier.getAsInt();
            return n2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long record(LongSupplier longSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            long l3 = longSupplier.getAsLong();
            return l3;
        }
        finally {
            long l4 = this.clock.monotonicTime();
            this.record(l4 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double record(DoubleSupplier doubleSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            double d2 = doubleSupplier.getAsDouble();
            return d2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable runnable) {
        long l2 = this.clock.monotonicTime();
        try {
            runnable.run();
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public final void record(long l2, TimeUnit timeUnit) {
        if (l2 >= 0L) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(l2, timeUnit));
            this.recordNonNegative(l2, timeUnit);
            if (this.intervalEstimator != null) {
                ((IntervalEstimator)this.intervalEstimator).recordInterval(this.clock.monotonicTime());
            }
        }
    }

    protected abstract void recordNonNegative(long var1, TimeUnit var3);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalTime(TimeUnit.NANOSECONDS), this.max(TimeUnit.NANOSECONDS));
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    @Override
    public void close() {
        this.histogram.close();
        if (this.pauseDetector != null) {
            this.pauseDetector.shutdown();
        }
    }
}

