/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jpa;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;

@NonNullApi
@NonNullFields
@Deprecated
public class HibernateMetrics
implements MeterBinder {
    private static final String SESSION_FACTORY_TAG_NAME = "entityManagerFactory";
    private final Iterable<Tag> tags;
    @Nullable
    private final Statistics statistics;

    public static void monitor(MeterRegistry meterRegistry, SessionFactory sessionFactory, String string, String ... stringArray) {
        HibernateMetrics.monitor(meterRegistry, sessionFactory, string, (Iterable<Tag>)Tags.of(stringArray));
    }

    public static void monitor(MeterRegistry meterRegistry, SessionFactory sessionFactory, String string, Iterable<Tag> iterable) {
        new HibernateMetrics(sessionFactory, string, iterable).bindTo(meterRegistry);
    }

    @Deprecated
    public static void monitor(MeterRegistry meterRegistry, EntityManagerFactory entityManagerFactory, String string, String ... stringArray) {
        HibernateMetrics.monitor(meterRegistry, entityManagerFactory, string, (Iterable<Tag>)Tags.of(stringArray));
    }

    @Deprecated
    public static void monitor(MeterRegistry meterRegistry, EntityManagerFactory entityManagerFactory, String string, Iterable<Tag> iterable) {
        new HibernateMetrics(entityManagerFactory, string, iterable).bindTo(meterRegistry);
    }

    public HibernateMetrics(SessionFactory sessionFactory, String string, Iterable<Tag> iterable) {
        this.tags = Tags.concat(iterable, SESSION_FACTORY_TAG_NAME, string);
        Statistics statistics = sessionFactory.getStatistics();
        this.statistics = statistics.isStatisticsEnabled() ? statistics : null;
    }

    @Deprecated
    public HibernateMetrics(EntityManagerFactory entityManagerFactory, String string, Iterable<Tag> iterable) {
        Statistics statistics;
        this.tags = Tags.concat(iterable, SESSION_FACTORY_TAG_NAME, string);
        SessionFactory sessionFactory = this.unwrap(entityManagerFactory);
        this.statistics = sessionFactory != null ? ((statistics = sessionFactory.getStatistics()).isStatisticsEnabled() ? statistics : null) : null;
    }

    private void counter(MeterRegistry meterRegistry, String string, String string2, ToDoubleFunction<Statistics> toDoubleFunction, String ... stringArray) {
        if (this.statistics == null) {
            return;
        }
        FunctionCounter.builder(string, this.statistics, toDoubleFunction).tags(this.tags).tags(stringArray).description(string2).register(meterRegistry);
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        if (this.statistics == null) {
            return;
        }
        this.counter(meterRegistry, "hibernate.sessions.open", "Sessions opened", Statistics::getSessionOpenCount, new String[0]);
        this.counter(meterRegistry, "hibernate.sessions.closed", "Sessions closed", Statistics::getSessionCloseCount, new String[0]);
        this.counter(meterRegistry, "hibernate.transactions", "The number of transactions we know to have been successful", Statistics::getSuccessfulTransactionCount, "result", "success");
        this.counter(meterRegistry, "hibernate.transactions", "The number of transactions we know to have failed", statistics -> statistics.getTransactionCount() - statistics.getSuccessfulTransactionCount(), "result", "failure");
        this.counter(meterRegistry, "hibernate.optimistic.failures", "The number of StaleObjectStateExceptions that have occurred", Statistics::getOptimisticFailureCount, new String[0]);
        this.counter(meterRegistry, "hibernate.flushes", "The global number of flushes executed by sessions (either implicit or explicit)", Statistics::getFlushCount, new String[0]);
        this.counter(meterRegistry, "hibernate.connections.obtained", "Get the global number of connections asked by the sessions (the actual number of connections used may be much smaller depending whether you use a connection pool or not)", Statistics::getConnectCount, new String[0]);
        this.counter(meterRegistry, "hibernate.statements", "The number of prepared statements that were acquired", Statistics::getPrepareStatementCount, "status", "prepared");
        this.counter(meterRegistry, "hibernate.statements", "The number of prepared statements that were released", Statistics::getCloseStatementCount, "status", "closed");
        Arrays.stream(this.statistics.getSecondLevelCacheRegionNames()).filter(this::hasDomainDataRegionStatistics).forEach(string -> {
            this.counter(meterRegistry, "hibernate.second.level.cache.requests", "The number of cacheable entities/collections successfully retrieved from the cache", statistics -> statistics.getDomainDataRegionStatistics(string).getHitCount(), "region", (String)string, "result", "hit");
            this.counter(meterRegistry, "hibernate.second.level.cache.requests", "The number of cacheable entities/collections not found in the cache and loaded from the database", statistics -> statistics.getDomainDataRegionStatistics(string).getMissCount(), "region", (String)string, "result", "miss");
            this.counter(meterRegistry, "hibernate.second.level.cache.puts", "The number of cacheable entities/collections put in the cache", statistics -> statistics.getDomainDataRegionStatistics(string).getPutCount(), "region", (String)string);
        });
        this.counter(meterRegistry, "hibernate.entities.deletes", "The number of entity deletes", Statistics::getEntityDeleteCount, new String[0]);
        this.counter(meterRegistry, "hibernate.entities.fetches", "The number of entity fetches", Statistics::getEntityFetchCount, new String[0]);
        this.counter(meterRegistry, "hibernate.entities.inserts", "The number of entity inserts", Statistics::getEntityInsertCount, new String[0]);
        this.counter(meterRegistry, "hibernate.entities.loads", "The number of entity loads", Statistics::getEntityLoadCount, new String[0]);
        this.counter(meterRegistry, "hibernate.entities.updates", "The number of entity updates", Statistics::getEntityUpdateCount, new String[0]);
        this.counter(meterRegistry, "hibernate.collections.deletes", "The number of collection deletes", Statistics::getCollectionRemoveCount, new String[0]);
        this.counter(meterRegistry, "hibernate.collections.fetches", "The number of collection fetches", Statistics::getCollectionFetchCount, new String[0]);
        this.counter(meterRegistry, "hibernate.collections.loads", "The number of collection loads", Statistics::getCollectionLoadCount, new String[0]);
        this.counter(meterRegistry, "hibernate.collections.recreates", "The number of collections recreated", Statistics::getCollectionRecreateCount, new String[0]);
        this.counter(meterRegistry, "hibernate.collections.updates", "The number of collection updates", Statistics::getCollectionUpdateCount, new String[0]);
        this.counter(meterRegistry, "hibernate.cache.natural.id.requests", "The number of cached naturalId lookups successfully retrieved from cache", Statistics::getNaturalIdCacheHitCount, "result", "hit");
        this.counter(meterRegistry, "hibernate.cache.natural.id.requests", "The number of cached naturalId lookups not found in cache", Statistics::getNaturalIdCacheMissCount, "result", "miss");
        this.counter(meterRegistry, "hibernate.cache.natural.id.puts", "The number of cacheable naturalId lookups put in cache", Statistics::getNaturalIdCachePutCount, new String[0]);
        this.counter(meterRegistry, "hibernate.query.natural.id.executions", "The number of naturalId queries executed against the database", Statistics::getNaturalIdQueryExecutionCount, new String[0]);
        TimeGauge.builder("hibernate.query.natural.id.executions.max", this.statistics, TimeUnit.MILLISECONDS, Statistics::getNaturalIdQueryExecutionMaxTime).description("The maximum query time for naturalId queries executed against the database").tags(this.tags).register(meterRegistry);
        this.counter(meterRegistry, "hibernate.query.executions", "The number of executed queries", Statistics::getQueryExecutionCount, new String[0]);
        TimeGauge.builder("hibernate.query.executions.max", this.statistics, TimeUnit.MILLISECONDS, Statistics::getQueryExecutionMaxTime).description("The time of the slowest query").tags(this.tags).register(meterRegistry);
        this.counter(meterRegistry, "hibernate.cache.update.timestamps.requests", "The number of timestamps successfully retrieved from cache", Statistics::getUpdateTimestampsCacheHitCount, "result", "hit");
        this.counter(meterRegistry, "hibernate.cache.update.timestamps.requests", "The number of tables for which no update timestamps was not found in cache", Statistics::getUpdateTimestampsCacheMissCount, "result", "miss");
        this.counter(meterRegistry, "hibernate.cache.update.timestamps.puts", "The number of timestamps put in cache", Statistics::getUpdateTimestampsCachePutCount, new String[0]);
        this.counter(meterRegistry, "hibernate.cache.query.requests", "The number of cached queries successfully retrieved from cache", Statistics::getQueryCacheHitCount, "result", "hit");
        this.counter(meterRegistry, "hibernate.cache.query.requests", "The number of cached queries not found in cache", Statistics::getQueryCacheMissCount, "result", "miss");
        this.counter(meterRegistry, "hibernate.cache.query.puts", "The number of cacheable queries put in cache", Statistics::getQueryCachePutCount, new String[0]);
        this.counter(meterRegistry, "hibernate.cache.query.plan", "The global number of query plans successfully retrieved from cache", Statistics::getQueryPlanCacheHitCount, "result", "hit");
        this.counter(meterRegistry, "hibernate.cache.query.plan", "The global number of query plans lookups not found in cache", Statistics::getQueryPlanCacheMissCount, "result", "miss");
    }

    private boolean hasDomainDataRegionStatistics(String string) {
        try {
            return this.statistics.getDomainDataRegionStatistics(string) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Nullable
    private SessionFactory unwrap(EntityManagerFactory entityManagerFactory) {
        try {
            return (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        }
        catch (PersistenceException persistenceException) {
            return null;
        }
    }
}

