/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.search;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.MeterFilter;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.MeterFilterReply;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Search {
    private final MeterRegistry registry;
    private final List<Tag> tags = new ArrayList<Tag>();
    private Predicate<String> nameMatches = string -> true;
    private final Set<String> requiredTagKeys = new HashSet<String>();
    private final Map<String, Collection<Predicate<String>>> tagMatches = new HashMap<String, Collection<Predicate<String>>>();

    private Search(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }

    public Search name(String string) {
        return this.name((String string2) -> string2.equals(string));
    }

    public Search name(@Nullable Predicate<String> predicate) {
        if (predicate != null) {
            this.nameMatches = predicate;
        }
        return this;
    }

    public Search tags(Iterable<Tag> iterable) {
        iterable.forEach(this.tags::add);
        return this;
    }

    public Search tags(String ... stringArray) {
        return this.tags(Tags.of(stringArray));
    }

    public Search tag(String string, String string2) {
        return this.tags(Tags.of(string, string2));
    }

    public Search tagKeys(String ... stringArray) {
        return this.tagKeys(Arrays.asList(stringArray));
    }

    public Search tagKeys(Collection<String> collection) {
        this.requiredTagKeys.addAll(collection);
        return this;
    }

    public Search tag(String string2, Predicate<String> predicate) {
        this.tagMatches.computeIfAbsent(string2, string -> new ArrayList()).add(predicate);
        return this;
    }

    @Nullable
    public Timer timer() {
        return this.findOne(Timer.class);
    }

    @Nullable
    public Counter counter() {
        return this.findOne(Counter.class);
    }

    @Nullable
    public Gauge gauge() {
        return this.findOne(Gauge.class);
    }

    @Nullable
    public FunctionCounter functionCounter() {
        return this.findOne(FunctionCounter.class);
    }

    @Nullable
    public TimeGauge timeGauge() {
        return this.findOne(TimeGauge.class);
    }

    @Nullable
    public FunctionTimer functionTimer() {
        return this.findOne(FunctionTimer.class);
    }

    @Nullable
    public DistributionSummary summary() {
        return this.findOne(DistributionSummary.class);
    }

    @Nullable
    public LongTaskTimer longTaskTimer() {
        return this.findOne(LongTaskTimer.class);
    }

    @Nullable
    public Meter meter() {
        return this.findOne(Meter.class);
    }

    @Nullable
    private <M extends Meter> M findOne(Class<M> clazz) {
        return (M)((Meter)this.meterStream().filter(clazz::isInstance).findAny().map(clazz::cast).orElse(null));
    }

    public Collection<Meter> meters() {
        return this.meterStream().collect(Collectors.toList());
    }

    public MeterFilter acceptFilter() {
        return new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                if (!Search.this.nameMatches.test(id.getName())) {
                    return MeterFilterReply.NEUTRAL;
                }
                return Search.this.isTagsMatched(id) ? MeterFilterReply.ACCEPT : MeterFilterReply.NEUTRAL;
            }
        };
    }

    private boolean isTagsMatched(Meter.Id id) {
        return this.isRequiredTagKeysPresent(id) && this.isTagPredicatesMatched(id) && id.getTags().containsAll(this.tags);
    }

    private boolean isRequiredTagKeysPresent(Meter.Id id) {
        if (!this.requiredTagKeys.isEmpty()) {
            HashSet hashSet = new HashSet();
            id.getTags().forEach(tag -> hashSet.add(tag.getKey()));
            return hashSet.containsAll(this.requiredTagKeys);
        }
        return true;
    }

    private boolean isTagPredicatesMatched(Meter.Id id) {
        if (!this.tagMatches.isEmpty()) {
            HashSet hashSet = new HashSet();
            id.getTags().forEach(tag -> {
                Collection<Predicate<String>> collection = this.tagMatches.get(tag.getKey());
                if (collection != null && collection.stream().allMatch(predicate -> predicate.test(tag.getValue()))) {
                    hashSet.add(tag.getKey());
                }
            });
            return this.tagMatches.keySet().size() == hashSet.size();
        }
        return true;
    }

    private Stream<Meter> meterStream() {
        Stream<Meter> stream = this.registry.getMeters().stream().filter(meter -> this.nameMatches.test(meter.getId().getName()));
        if (!(this.tags.isEmpty() && this.requiredTagKeys.isEmpty() && this.tagMatches.isEmpty())) {
            stream = stream.filter(meter -> this.isTagsMatched(meter.getId()));
        }
        return stream;
    }

    public Collection<Counter> counters() {
        return this.findAll(Counter.class);
    }

    public Collection<Gauge> gauges() {
        return this.findAll(Gauge.class);
    }

    public Collection<Timer> timers() {
        return this.findAll(Timer.class);
    }

    public Collection<DistributionSummary> summaries() {
        return this.findAll(DistributionSummary.class);
    }

    public Collection<LongTaskTimer> longTaskTimers() {
        return this.findAll(LongTaskTimer.class);
    }

    public Collection<FunctionCounter> functionCounters() {
        return this.findAll(FunctionCounter.class);
    }

    public Collection<FunctionTimer> functionTimers() {
        return this.findAll(FunctionTimer.class);
    }

    public Collection<TimeGauge> timeGauges() {
        return this.findAll(TimeGauge.class);
    }

    private <M extends Meter> Collection<M> findAll(Class<M> clazz) {
        return this.meterStream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static Search in(MeterRegistry meterRegistry) {
        return new Search(meterRegistry);
    }
}

