/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.api.baggage.propagation;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class BaggageCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final int RADIX = 16;

    private BaggageCodec() {
    }

    private static byte[] decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by2 = byArray[i2];
            if (by2 == 37) {
                try {
                    int n2 = BaggageCodec.digit16(byArray[++i2]);
                    int n3 = BaggageCodec.digit16(byArray[++i2]);
                    byteArrayOutputStream.write((char)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid URL encoding: ", arrayIndexOutOfBoundsException);
                }
            }
            byteArrayOutputStream.write(by2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String decode(String string, Charset charset) {
        byte[] byArray = BaggageCodec.decode(string.getBytes(StandardCharsets.US_ASCII));
        return new String(byArray, charset);
    }

    private static int digit16(byte by2) {
        int n2 = Character.digit((char)by2, 16);
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid URL encoding: not a valid digit (radix 16): " + by2);
        }
        return n2;
    }
}

