/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.traces;

import com.contrastsecurity.thirdparty.iot.api.trace.TraceState;
import com.contrastsecurity.thirdparty.iot.api.trace.propagation.internal.W3CTraceContextEncoding;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.trace.v1.internal.Span;
import com.contrastsecurity.thirdparty.iot.sdk.trace.data.LinkData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class SpanLinkMarshaler
extends MarshalerWithSize {
    private static final SpanLinkMarshaler[] EMPTY = new SpanLinkMarshaler[0];
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String traceId;
    private final String spanId;
    private final byte[] traceStateUtf8;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;

    static SpanLinkMarshaler[] createRepeated(List<LinkData> list) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        SpanLinkMarshaler[] spanLinkMarshalerArray = new SpanLinkMarshaler[list.size()];
        int n2 = 0;
        for (LinkData linkData : list) {
            spanLinkMarshalerArray[n2++] = SpanLinkMarshaler.create(linkData);
        }
        return spanLinkMarshalerArray;
    }

    static SpanLinkMarshaler create(LinkData linkData) {
        TraceState traceState = linkData.getSpanContext().getTraceState();
        byte[] byArray = traceState.isEmpty() ? EMPTY_BYTES : W3CTraceContextEncoding.encodeTraceState(traceState).getBytes(StandardCharsets.UTF_8);
        return new SpanLinkMarshaler(linkData.getSpanContext().getTraceId(), linkData.getSpanContext().getSpanId(), byArray, KeyValueMarshaler.createRepeated(linkData.getAttributes()), linkData.getTotalAttributeCount() - linkData.getAttributes().size());
    }

    private SpanLinkMarshaler(String string, String string2, byte[] byArray, KeyValueMarshaler[] keyValueMarshalerArray, int n2) {
        super(SpanLinkMarshaler.calculateSize(string, string2, byArray, keyValueMarshalerArray, n2));
        this.traceId = string;
        this.spanId = string2;
        this.traceStateUtf8 = byArray;
        this.attributeMarshalers = keyValueMarshalerArray;
        this.droppedAttributesCount = n2;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeTraceId(Span.Link.TRACE_ID, this.traceId);
        serializer.serializeSpanId(Span.Link.SPAN_ID, this.spanId);
        serializer.serializeString(Span.Link.TRACE_STATE, this.traceStateUtf8);
        serializer.serializeRepeatedMessage(Span.Link.ATTRIBUTES, this.attributeMarshalers);
        serializer.serializeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
    }

    private static int calculateSize(String string, String string2, byte[] byArray, KeyValueMarshaler[] keyValueMarshalerArray, int n2) {
        int n3 = 0;
        n3 += MarshalerUtil.sizeTraceId(Span.Link.TRACE_ID, string);
        n3 += MarshalerUtil.sizeSpanId(Span.Link.SPAN_ID, string2);
        n3 += MarshalerUtil.sizeBytes(Span.Link.TRACE_STATE, byArray);
        n3 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.Link.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        return n3 += MarshalerUtil.sizeUInt32(Span.Link.DROPPED_ATTRIBUTES_COUNT, n2);
    }
}

