/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.http.metrics;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.iot.sdk.common.export.RetryPolicy;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.DefaultAggregationSelector;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpMetricExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private final HttpExporterBuilder<MetricsRequestMarshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();

    OtlpHttpMetricExporterBuilder(HttpExporterBuilder<MetricsRequestMarshaler> httpExporterBuilder) {
        this.delegate = httpExporterBuilder;
        httpExporterBuilder.setMeterProvider(MeterProvider.noop());
        OtlpUserAgent.addUserAgentHeader(httpExporterBuilder::addHeader);
    }

    OtlpHttpMetricExporterBuilder() {
        this(new HttpExporterBuilder<MetricsRequestMarshaler>("otlp", "metric", DEFAULT_ENDPOINT));
    }

    public OtlpHttpMetricExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        return this.setTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    OtlpHttpMetricExporterBuilder exportAsJson() {
        this.delegate.exportAsJson();
        return this;
    }

    public OtlpHttpMetricExporter build() {
        return new OtlpHttpMetricExporter(this.delegate, this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector);
    }
}

