/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.internal;

import com.contrastsecurity.thirdparty.iot.sdk.autoconfigure.spi.ConfigProperties;
import com.contrastsecurity.thirdparty.iot.sdk.autoconfigure.spi.ConfigurationException;
import com.contrastsecurity.thirdparty.iot.sdk.common.export.RetryPolicy;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.DefaultAggregationSelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AggregationUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class OtlpConfigUtil {
    public static final String DATA_TYPE_TRACES = "traces";
    public static final String DATA_TYPE_METRICS = "metrics";
    public static final String DATA_TYPE_LOGS = "logs";
    public static final String PROTOCOL_GRPC = "grpc";
    public static final String PROTOCOL_HTTP_PROTOBUF = "http/protobuf";

    public static String getOtlpProtocol(String string, ConfigProperties configProperties) {
        String string2 = configProperties.getString("otel.exporter.otlp." + string + ".protocol");
        if (string2 != null) {
            return string2;
        }
        return configProperties.getString("otel.exporter.otlp.protocol", PROTOCOL_GRPC);
    }

    public static void configureOtlpExporterBuilder(String string, ConfigProperties configProperties, Consumer<String> consumer, BiConsumer<String, String> biConsumer, Consumer<String> consumer2, Consumer<Duration> consumer3, Consumer<byte[]> consumer4, BiConsumer<byte[], byte[]> biConsumer2, Consumer<RetryPolicy> consumer5) {
        boolean bl2;
        Duration duration;
        Object object;
        String string2 = OtlpConfigUtil.getOtlpProtocol(string, configProperties);
        boolean bl3 = string2.equals(PROTOCOL_HTTP_PROTOBUF);
        URL uRL = OtlpConfigUtil.validateEndpoint(configProperties.getString("otel.exporter.otlp." + string + ".endpoint"), bl3);
        if (uRL != null) {
            if (uRL.getPath().isEmpty()) {
                uRL = OtlpConfigUtil.createUrl(uRL, "/");
            }
        } else {
            uRL = OtlpConfigUtil.validateEndpoint(configProperties.getString("otel.exporter.otlp.endpoint"), bl3);
            if (uRL != null && bl3) {
                object = uRL.getPath();
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                object = (String)object + OtlpConfigUtil.signalPath(string);
                uRL = OtlpConfigUtil.createUrl(uRL, (String)object);
            }
        }
        if (uRL != null) {
            consumer.accept(uRL.toString());
        }
        if ((object = configProperties.getMap("otel.exporter.otlp." + string + ".headers")).isEmpty()) {
            object = configProperties.getMap("otel.exporter.otlp.headers");
        }
        object.forEach(biConsumer);
        String string3 = configProperties.getString("otel.exporter.otlp." + string + ".compression");
        if (string3 == null) {
            string3 = configProperties.getString("otel.exporter.otlp.compression");
        }
        if (string3 != null) {
            consumer2.accept(string3);
        }
        if ((duration = configProperties.getDuration("otel.exporter.otlp." + string + ".timeout")) == null) {
            duration = configProperties.getDuration("otel.exporter.otlp.timeout");
        }
        if (duration != null) {
            consumer3.accept(duration);
        }
        String string4 = configProperties.getString(OtlpConfigUtil.determinePropertyByType(configProperties, "otel.exporter.otlp", string, "certificate"));
        String string5 = configProperties.getString(OtlpConfigUtil.determinePropertyByType(configProperties, "otel.exporter.otlp", string, "client.key"));
        String string6 = configProperties.getString(OtlpConfigUtil.determinePropertyByType(configProperties, "otel.exporter.otlp", string, "client.certificate"));
        if (string5 != null && string6 == null) {
            throw new ConfigurationException("Client key provided but certification chain is missing");
        }
        if (string5 == null && string6 != null) {
            throw new ConfigurationException("Client key chain provided but key is missing");
        }
        byte[] byArray = OtlpConfigUtil.readFileBytes(string4);
        if (byArray != null) {
            consumer4.accept(byArray);
        }
        byte[] byArray2 = OtlpConfigUtil.readFileBytes(string5);
        byte[] byArray3 = OtlpConfigUtil.readFileBytes(string6);
        if (byArray2 != null && byArray3 != null) {
            biConsumer2.accept(byArray2, byArray3);
        }
        if (bl2 = configProperties.getBoolean("otel.experimental.exporter.otlp.retry.enabled", false)) {
            consumer5.accept(RetryPolicy.getDefault());
        }
    }

    public static void configureOtlpAggregationTemporality(ConfigProperties configProperties, Consumer<AggregationTemporalitySelector> consumer) {
        AggregationTemporalitySelector aggregationTemporalitySelector;
        String string = configProperties.getString("otel.exporter.otlp.metrics.temporality.preference");
        if (string == null) {
            return;
        }
        switch (string.toLowerCase(Locale.ROOT)) {
            case "cumulative": {
                aggregationTemporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
                break;
            }
            case "delta": {
                aggregationTemporalitySelector = AggregationTemporalitySelector.deltaPreferred();
                break;
            }
            case "lowmemory": {
                aggregationTemporalitySelector = AggregationTemporalitySelector.lowMemory();
                break;
            }
            default: {
                throw new ConfigurationException("Unrecognized aggregation temporality: " + string);
            }
        }
        consumer.accept(aggregationTemporalitySelector);
    }

    public static void configureOtlpHistogramDefaultAggregation(ConfigProperties configProperties, Consumer<DefaultAggregationSelector> consumer) {
        String string = configProperties.getString("otel.exporter.otlp.metrics.default.histogram.aggregation");
        if (string == null) {
            return;
        }
        if (AggregationUtil.aggregationName(Aggregation.base2ExponentialBucketHistogram()).equalsIgnoreCase(string)) {
            consumer.accept(DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, Aggregation.base2ExponentialBucketHistogram()));
        } else if (!AggregationUtil.aggregationName(Aggregation.explicitBucketHistogram()).equalsIgnoreCase(string)) {
            throw new ConfigurationException("Unrecognized default histogram aggregation: " + string);
        }
    }

    private static URL createUrl(URL uRL, String string) {
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Unexpected exception creating URL.", malformedURLException);
        }
    }

    @Nullable
    private static URL validateEndpoint(@Nullable String string, boolean bl2) {
        URL uRL;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("OTLP endpoint must be a valid URL: " + string, malformedURLException);
        }
        if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) {
            throw new ConfigurationException("OTLP endpoint scheme must be http or https: " + uRL.getProtocol());
        }
        if (uRL.getQuery() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a query string: " + uRL.getQuery());
        }
        if (uRL.getRef() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a fragment: " + uRL.getRef());
        }
        if (!(bl2 || uRL.getPath().isEmpty() || uRL.getPath().equals("/"))) {
            throw new ConfigurationException("OTLP endpoint must not have a path: " + uRL.getPath());
        }
        return uRL;
    }

    @Nullable
    private static byte[] readFileBytes(@Nullable String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new ConfigurationException("Invalid OTLP certificate/key path: " + string);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Error reading content of file (" + string + ")", iOException);
        }
    }

    private static String determinePropertyByType(ConfigProperties configProperties, String string, String string2, String string3) {
        String string4 = string + "." + string2 + "." + string3;
        if (OtlpConfigUtil.configContainsKey(configProperties, string4)) {
            return string4;
        }
        return string + "." + string3;
    }

    private static boolean configContainsKey(ConfigProperties configProperties, String string) {
        return configProperties.getString(string) != null;
    }

    private static String signalPath(String string) {
        switch (string) {
            case "metrics": {
                return "v1/metrics";
            }
            case "traces": {
                return "v1/traces";
            }
            case "logs": {
                return "v1/logs";
            }
        }
        throw new IllegalArgumentException("Cannot determine signal path for unrecognized data type: " + string);
    }

    private OtlpConfigUtil() {
    }
}

