/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.metrics.BatchCallback;
import com.contrastsecurity.thirdparty.iot.api.metrics.DoubleGaugeBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.DoubleHistogramBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongCounterBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongUpDownCounterBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.Meter;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.api.metrics.ObservableMeasurement;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkDoubleGaugeBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkDoubleHistogram;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkLongCounter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkLongUpDownCounter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkObservableInstrument;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.export.RegisteredReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.CallbackRegistration;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.SdkObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

final class SdkMeter
implements Meter {
    private static final e logger = e.a(SdkMeter.class.getName());
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z]){1}([A-Za-z0-9\\_\\-\\.]){0,62}");
    private static final Meter NOOP_METER = MeterProvider.noop().get("noop");
    private static final String NOOP_INSTRUMENT_NAME = "noop";
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationScopeInfo instrumentationScopeInfo, List<RegisteredReader> list) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationScopeInfo, list);
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    Collection<MetricData> collectAll(RegisteredReader registeredReader, long l2) {
        return this.meterSharedState.collectAll(registeredReader, this.meterProviderSharedState, l2);
    }

    void resetForTest() {
        this.meterSharedState.resetForTest();
    }

    @Override
    public LongCounterBuilder counterBuilder(String string) {
        return !SdkMeter.checkValidInstrumentName(string) ? NOOP_METER.counterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongCounter.SdkLongCounterBuilder(this.meterProviderSharedState, this.meterSharedState, string);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String string) {
        return !SdkMeter.checkValidInstrumentName(string) ? NOOP_METER.upDownCounterBuilder(NOOP_INSTRUMENT_NAME) : new SdkLongUpDownCounter.SdkLongUpDownCounterBuilder(this.meterProviderSharedState, this.meterSharedState, string);
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String string) {
        return !SdkMeter.checkValidInstrumentName(string) ? NOOP_METER.histogramBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleHistogram.SdkDoubleHistogramBuilder(this.meterProviderSharedState, this.meterSharedState, string);
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String string) {
        return !SdkMeter.checkValidInstrumentName(string) ? NOOP_METER.gaugeBuilder(NOOP_INSTRUMENT_NAME) : new SdkDoubleGaugeBuilder(this.meterProviderSharedState, this.meterSharedState, string);
    }

    @Override
    public BatchCallback batchCallback(Runnable runnable, ObservableMeasurement observableMeasurement, ObservableMeasurement ... observableMeasurementArray) {
        HashSet<ObservableMeasurement> hashSet = new HashSet<ObservableMeasurement>();
        hashSet.add(observableMeasurement);
        Collections.addAll(hashSet, observableMeasurementArray);
        ArrayList<SdkObservableMeasurement> arrayList = new ArrayList<SdkObservableMeasurement>();
        for (ObservableMeasurement observableMeasurement2 : hashSet) {
            if (!(observableMeasurement2 instanceof SdkObservableMeasurement)) {
                logger.a(e.a.c, "batchCallback called with instruments that were not created by the SDK.");
                continue;
            }
            SdkObservableMeasurement sdkObservableMeasurement = (SdkObservableMeasurement)observableMeasurement2;
            if (!this.meterSharedState.getInstrumentationScopeInfo().equals(sdkObservableMeasurement.getInstrumentationScopeInfo())) {
                logger.a(e.a.c, "batchCallback called with instruments that belong to a different Meter.");
                continue;
            }
            arrayList.add(sdkObservableMeasurement);
        }
        CallbackRegistration callbackRegistration = CallbackRegistration.create(arrayList, runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    public String toString() {
        return "SdkMeter{instrumentationScopeInfo=" + this.instrumentationScopeInfo + "}";
    }

    static boolean checkValidInstrumentName(String string) {
        if (string != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(string).matches()) {
            return true;
        }
        if (logger.a(e.a.c)) {
            logger.a(e.a.c, "Instrument name \"" + string + "\" is invalid, returning noop instrument. Instrument names must consist of 63 or fewer characters including alphanumeric, _, ., -, and start with a letter.", (Throwable)((Object)new AssertionError()));
        }
        return false;
    }
}

