/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AdaptingIntegerArray;

final class AdaptingCircularBufferCounter {
    private static final int NULL_INDEX = Integer.MIN_VALUE;
    private int endIndex = Integer.MIN_VALUE;
    private int startIndex = Integer.MIN_VALUE;
    private int baseIndex = Integer.MIN_VALUE;
    private final AdaptingIntegerArray backing;

    AdaptingCircularBufferCounter(int n2) {
        this.backing = new AdaptingIntegerArray(n2);
    }

    AdaptingCircularBufferCounter(AdaptingCircularBufferCounter adaptingCircularBufferCounter) {
        this.backing = adaptingCircularBufferCounter.backing.copy();
        this.startIndex = adaptingCircularBufferCounter.getIndexStart();
        this.endIndex = adaptingCircularBufferCounter.getIndexEnd();
        this.baseIndex = adaptingCircularBufferCounter.baseIndex;
    }

    int getIndexStart() {
        return this.startIndex;
    }

    int getIndexEnd() {
        return this.endIndex;
    }

    boolean increment(int n2, long l2) {
        if (this.baseIndex == Integer.MIN_VALUE) {
            this.startIndex = n2;
            this.endIndex = n2;
            this.baseIndex = n2;
            this.backing.increment(0, l2);
            return true;
        }
        if (n2 > this.endIndex) {
            if ((long)n2 - (long)this.startIndex + 1L > (long)this.backing.length()) {
                return false;
            }
            this.endIndex = n2;
        } else if (n2 < this.startIndex) {
            if ((long)this.endIndex - (long)n2 + 1L > (long)this.backing.length()) {
                return false;
            }
            this.startIndex = n2;
        }
        int n3 = this.toBufferIndex(n2);
        this.backing.increment(n3, l2);
        return true;
    }

    long get(int n2) {
        if (n2 < this.startIndex || n2 > this.endIndex) {
            return 0L;
        }
        return this.backing.get(this.toBufferIndex(n2));
    }

    boolean isEmpty() {
        return this.baseIndex == Integer.MIN_VALUE;
    }

    int getMaxSize() {
        return this.backing.length();
    }

    void clear() {
        this.backing.clear();
        this.baseIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
    }

    private int toBufferIndex(int n2) {
        int n3 = n2 - this.baseIndex;
        if (n3 >= this.backing.length()) {
            n3 -= this.backing.length();
        } else if (n3 < 0) {
            n3 += this.backing.length();
        }
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i2 = this.startIndex; i2 <= this.endIndex && this.startIndex != Integer.MIN_VALUE; ++i2) {
            if (i2 != this.startIndex) {
                stringBuilder.append(',');
            }
            stringBuilder.append(i2).append('=').append(this.get(i2));
        }
        return stringBuilder.append("}").toString();
    }
}

