/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.LongExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableDoubleExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.data.ImmutableLongExemplarData;
import java.util.Set;
import javax.annotation.Nullable;

class ReservoirCell {
    private final Clock clock;
    @Nullable
    private Attributes attributes;
    private SpanContext spanContext = SpanContext.getInvalid();
    private long recordTime;
    private long longValue;
    private double doubleValue;

    ReservoirCell(Clock clock) {
        this.clock = clock;
    }

    synchronized void recordLongMeasurement(long l2, Attributes attributes, Context context) {
        this.longValue = l2;
        this.offerMeasurement(attributes, context);
    }

    synchronized void recordDoubleMeasurement(double d2, Attributes attributes, Context context) {
        this.doubleValue = d2;
        this.offerMeasurement(attributes, context);
    }

    private void offerMeasurement(Attributes attributes, Context context) {
        this.attributes = attributes;
        this.recordTime = this.clock.now();
        Span span = Span.fromContext(context);
        if (span.getSpanContext().isValid()) {
            this.spanContext = span.getSpanContext();
        }
    }

    @Nullable
    synchronized LongExemplarData getAndResetLong(Attributes attributes) {
        Attributes attributes2 = this.attributes;
        if (attributes2 == null) {
            return null;
        }
        LongExemplarData longExemplarData = ImmutableLongExemplarData.create(ReservoirCell.filtered(attributes2, attributes), this.recordTime, this.spanContext, this.longValue);
        this.reset();
        return longExemplarData;
    }

    @Nullable
    synchronized DoubleExemplarData getAndResetDouble(Attributes attributes) {
        Attributes attributes2 = this.attributes;
        if (attributes2 == null) {
            return null;
        }
        DoubleExemplarData doubleExemplarData = ImmutableDoubleExemplarData.create(ReservoirCell.filtered(attributes2, attributes), this.recordTime, this.spanContext, this.doubleValue);
        this.reset();
        return doubleExemplarData;
    }

    synchronized void reset() {
        this.attributes = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.spanContext = SpanContext.getInvalid();
        this.recordTime = 0L;
    }

    private static Attributes filtered(Attributes attributes, Attributes attributes2) {
        if (attributes2.isEmpty()) {
            return attributes;
        }
        Set<AttributeKey<?>> set = attributes2.asMap().keySet();
        return attributes.toBuilder().removeIf(set::contains).build();
    }
}

