/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.view;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import com.contrastsecurity.thirdparty.iot.sdk.internal.RandomSupplier;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.data.PointData;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramAggregator;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class Base2ExponentialHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final int DEFAULT_MAX_BUCKETS = 160;
    private static final int DEFAULT_MAX_SCALE = 20;
    private static final Aggregation DEFAULT = new Base2ExponentialHistogramAggregation(160, 20);
    private final int maxBuckets;
    private final int maxScale;

    private Base2ExponentialHistogramAggregation(int n2, int n3) {
        this.maxBuckets = n2;
        this.maxScale = n3;
    }

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(int n2, int n3) {
        Utils.checkArgument(n2 >= 1, "maxBuckets must be > 0");
        Utils.checkArgument(n3 <= 20 && n3 >= -10, "maxScale must be -10 <= x <= 20");
        return new Base2ExponentialHistogramAggregation(n2, n3);
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleBase2ExponentialHistogramAggregator(() -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault())), this.maxBuckets, this.maxScale);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Base2ExponentialHistogramAggregation{maxBuckets=" + this.maxBuckets + ",maxScale=" + this.maxScale + "}";
    }
}

