/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.schema;

import com.contrastsecurity.thirdparty.nsjsqlp.schema.MultiPartName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Server
implements MultiPartName {
    public static final Pattern SERVER_PATTERN = Pattern.compile("\\[([^\\]]+?)(?:\\\\([^\\]]+))?\\]");
    private String serverName;
    private String instanceName;
    private String simpleName;

    public Server(String string) {
        if (string != null) {
            Matcher matcher = SERVER_PATTERN.matcher(string);
            if (!matcher.find()) {
                this.simpleName = string;
            } else {
                this.setServerName(matcher.group(1));
                this.setInstanceName(matcher.group(2));
            }
        }
    }

    public Server(String string, String string2) {
        this.setServerName(string);
        this.setInstanceName(string2);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.serverName != null && !this.serverName.isEmpty() && this.instanceName != null && !this.instanceName.isEmpty()) {
            return String.format("[%s\\%s]", this.serverName, this.instanceName);
        }
        if (this.serverName != null && !this.serverName.isEmpty()) {
            return String.format("[%s]", this.serverName);
        }
        if (this.simpleName != null && !this.simpleName.isEmpty()) {
            return this.simpleName;
        }
        return "";
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

